/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSAnnotator;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.netbeans.modules.versioning.core.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.core.spi.VersioningSystem;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.spi.queries.CollocationQueryImplementation2;
import org.openide.util.ContextAwareAction;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class DelegatingVCS
extends VersioningSystem
implements VCSSystemProvider.VersioningSystem<VersioningSystem> {
    private final Map<?, ?> map;
    private VersioningSystem delegate;
    private Set<String> metadataFolderNames;
    private final Object DELEGATE_LOCK = new Object();
    private final String displayName;
    private final String menuLabel;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Set<VCSFileProxy> unversionedParents = Collections.synchronizedSet(new HashSet(20));

    public static DelegatingVCS create(Map<?, ?> map) {
        return new DelegatingVCS(map);
    }

    private DelegatingVCS(Map<?, ?> map) {
        this.map = map;
        this.displayName = (String)map.get("displayName");
        this.menuLabel = (String)map.get("menuLabel");
        VersioningManager.LOG.log(Level.FINE, "Created DelegatingVCS for : {0}", map.get("displayName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersioningSystem getDelegate() {
        VersioningManager manager = VersioningManager.getInstance();
        Object object = this.DELEGATE_LOCK;
        synchronized (object) {
            if (this.delegate == null) {
                manager.flushNullOwners();
                this.delegate = (VersioningSystem)this.map.get("delegate");
                if (this.delegate != null) {
                    PropertyChangeSupport propertyChangeSupport = this.support;
                    synchronized (propertyChangeSupport) {
                        PropertyChangeListener[] listeners;
                        for (PropertyChangeListener l : listeners = this.support.getPropertyChangeListeners()) {
                            this.delegate.addPropertyChangeListener(l);
                            this.support.removePropertyChangeListener(l);
                        }
                    }
                } else {
                    VersioningManager.LOG.log(Level.WARNING, "Couldn't create delegate for : {0}", this.map.get("displayName"));
                }
            }
            return this.delegate;
        }
    }

    @Override
    public void getOriginalFile(VCSFileProxy workingCopy, VCSFileProxy originalFile) {
        this.getDelegate().getOriginalFile(workingCopy, originalFile);
    }

    @Override
    public CollocationQueryImplementation2 getCollocationQueryImplementation() {
        return this.getDelegate().getCollocationQueryImplementation();
    }

    @Override
    public VCSFileProxy getTopmostManagedAncestor(VCSFileProxy file) {
        if (!this.isAlive()) {
            if (this.getMetadataFolderNames().contains(file.getName()) && file.isDirectory()) {
                VersioningManager.LOG.log(Level.FINE, "will awake VCS {0} because of metadata folder {1}", new Object[]{this.displayName, file});
                return this.getDelegate().getTopmostManagedAncestor(file);
            }
            if (this.hasMetadata(file)) {
                VersioningManager.LOG.log(Level.FINE, "will awake VCS {0} because {1} contains matadata", new Object[]{this.displayName, file});
                return this.getDelegate().getTopmostManagedAncestor(file);
            }
        } else {
            return this.getDelegate().getTopmostManagedAncestor(file);
        }
        return null;
    }

    @Override
    public boolean isLocalHistory() {
        return false;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getMenuLabel() {
        return this.menuLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addPropertyCL(PropertyChangeListener listener) {
        if (this.isAlive()) {
            this.getDelegate().addPropertyChangeListener(listener);
        } else {
            PropertyChangeSupport propertyChangeSupport = this.support;
            synchronized (propertyChangeSupport) {
                this.support.addPropertyChangeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removePropertyCL(PropertyChangeListener listener) {
        if (this.isAlive()) {
            this.getDelegate().removePropertyChangeListener(listener);
        } else {
            PropertyChangeSupport propertyChangeSupport = this.support;
            synchronized (propertyChangeSupport) {
                this.support.removePropertyChangeListener(listener);
            }
        }
    }

    @Override
    public boolean isExcluded(VCSFileProxy file) {
        return VersioningSupport.isExcluded(file);
    }

    @Override
    public VCSAnnotator getVCSAnnotator() {
        return this.getDelegate().getVCSAnnotator();
    }

    @Override
    public VCSVisibilityQuery getVisibilityQuery() {
        return this.getDelegate().getVisibilityQuery();
    }

    @Override
    public VCSInterceptor getVCSInterceptor() {
        return this.getDelegate().getVCSInterceptor();
    }

    @Override
    public VCSHistoryProvider getVCSHistoryProvider() {
        return this.getDelegate().getVCSHistoryProvider();
    }

    @Override
    public boolean accept(VCSContext ctx) {
        return true;
    }

    @Override
    public boolean isMetadataFile(VCSFileProxy file) {
        return this.getMetadataFolderNames().contains(file.getName());
    }

    private Collection<String> getMetadataFolderNames() {
        if (this.metadataFolderNames == null) {
            String name;
            this.metadataFolderNames = new HashSet<String>();
            int i = 0;
            while ((name = (String)this.map.get("metadataFolderName" + i++)) != null) {
                if ((name = this.parseName(name)) == null) continue;
                this.metadataFolderNames.add(name);
            }
        }
        return this.metadataFolderNames;
    }

    Action[] getActions(VCSContext ctx, VCSAnnotator.ActionDestination actionDestination) {
        if (this.map == null || this.isAlive()) {
            VCSAnnotator annotator = this.getVCSAnnotator();
            return annotator != null ? annotator.getActions(ctx, actionDestination) : new Action[]{};
        }
        Action[] ia = this.getInitActions(ctx);
        Action[] ga = this.getGlobalActions(ctx);
        ArrayList<Action> l = new ArrayList<Action>(ia.length + ga.length + 1);
        l.addAll(Arrays.asList(ia));
        if (ga.length > 0 && ia.length > 0 && l.get(l.size() - 1) != null) {
            l.add(null);
        }
        l.addAll(Arrays.asList(ga));
        return l.toArray(new Action[l.size()]);
    }

    Action[] getGlobalActions(VCSContext ctx) {
        assert (!this.isAlive());
        String category = (String)this.map.get("actionsCategory");
        List l = Utilities.actionsForPath((String)("Versioning/" + category + "/Actions/Global"));
        ArrayList<Action> ret = new ArrayList<Action>(l.size());
        for (Action action : l) {
            if (action instanceof ContextAwareAction) {
                ret.add(((ContextAwareAction)action).createContextAwareInstance(Lookups.singleton((Object)ctx)));
                continue;
            }
            ret.add(action);
        }
        return ret != null ? ret.toArray(new Action[ret.size()]) : new Action[]{};
    }

    Action[] getInitActions(VCSContext ctx) {
        String category = (String)this.map.get("actionsCategory");
        List l = Utilities.actionsForPath((String)("Versioning/" + category + "/Actions/Unversioned"));
        ArrayList<Action> ret = new ArrayList<Action>(l.size());
        for (Action action : l) {
            if (action instanceof ContextAwareAction) {
                ret.add(((ContextAwareAction)action).createContextAwareInstance(Lookups.singleton((Object)ctx)));
                continue;
            }
            ret.add(action);
        }
        return ret.toArray(new Action[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAlive() {
        Object object = this.DELEGATE_LOCK;
        synchronized (object) {
            return this.delegate != null;
        }
    }

    private boolean hasMetadata(VCSFileProxy file) {
        if (file == null) {
            return false;
        }
        VersioningManager.LOG.log(Level.FINE, "looking up metadata for {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            VersioningManager.LOG.fine(" cached as unversioned");
            return false;
        }
        boolean ret = false;
        HashSet<VCSFileProxy> done = new HashSet<VCSFileProxy>();
        for (String folderName : this.getMetadataFolderNames()) {
            VCSFileProxy parent = file.isDirectory() ? file : file.getParentFile();
            if (this.unversionedParents.contains(parent)) {
                VersioningManager.LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            while (parent != null) {
                boolean metadataFolder = VCSFileProxy.createFileProxy(parent, folderName).exists();
                if (metadataFolder) {
                    VersioningManager.LOG.log(Level.FINER, "found metadata folder {0} for file {1}", new Object[]{metadataFolder, file});
                    ret = true;
                } else {
                    done.add(parent);
                }
                parent = parent.getParentFile();
            }
        }
        if (!ret) {
            VersioningManager.LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.DELEGATE_LOCK;
        synchronized (object) {
            this.delegate = null;
        }
    }

    private String parseName(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.indexOf(":");
        if (idx < 0) {
            return name;
        }
        String[] cmd = name.split(":");
        if (cmd.length != 4 || !cmd[1].contains("getenv")) {
            return name;
        }
        assert (cmd[3].equals("notnull") || cmd[3].equals("null"));
        boolean notnull = cmd[3].trim().equals("notnull");
        if (notnull) {
            return System.getenv(cmd[2]) != null ? cmd[0] : null;
        }
        return System.getenv(cmd[2]) == null ? cmd[0] : null;
    }
}

