/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.util.TreePath;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.Document;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.javadoc.hints.Access;
import org.netbeans.modules.javadoc.hints.Analyzer;
import org.netbeans.modules.javadoc.hints.JavadocHintProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class JavadocHint {
    public static final String SCOPE_KEY = "scope";
    public static final String SCOPE_DEFAULT = "protected";
    public static final String AVAILABILITY_KEY = "availability";

    public static List<ErrorDescription> createHint(HintContext ctx) {
        return JavadocHint.run(ctx, true);
    }

    public static List<ErrorDescription> run(HintContext ctx, boolean createJavadocKind) {
        boolean isPubliclyA11e;
        Preferences pref = ctx.getPreferences();
        boolean createJavadocForNonPublic = pref.getBoolean("availabilitytrue", false);
        boolean correctJavadocForNonPublic = pref.getBoolean("availabilityfalse", false);
        CompilationInfo javac = ctx.getInfo();
        Boolean publiclyAccessible = AccessibilityQuery.isPubliclyAccessible((FileObject)javac.getFileObject().getParent());
        boolean bl = isPubliclyA11e = publiclyAccessible == null ? true : publiclyAccessible;
        if (createJavadocKind && !isPubliclyA11e && !createJavadocForNonPublic) {
            return null;
        }
        if (!(createJavadocKind || isPubliclyA11e || correctJavadocForNonPublic)) {
            return null;
        }
        if (javac.getElements().getTypeElement("java.lang.Object") == null) {
            return Collections.emptyList();
        }
        Document doc = null;
        try {
            doc = javac.getDocument();
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        if (doc == null) {
            return null;
        }
        TreePath path = ctx.getPath();
        Severity severity = ctx.getSeverity();
        Access access = Access.resolve(pref.get(SCOPE_KEY, SCOPE_DEFAULT));
        Analyzer a = new Analyzer(javac, doc, path, severity, createJavadocKind, access);
        return a.analyze();
    }

    private static JComponent createCustomizer(final Preferences node, final boolean createJavadocKind) {
        JPanel outerPanel = new JPanel(new GridBagLayout());
        outerPanel.setOpaque(false);
        JPanel res = new JPanel(new GridBagLayout());
        res.setOpaque(false);
        res.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(JavadocHintProvider.class, (String)"LBL_SCOPE")));
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton rb = (JRadioButton)e.getSource();
                node.put(JavadocHint.SCOPE_KEY, rb.getText());
            }
        };
        ButtonGroup group = new ButtonGroup();
        int row = 0;
        JRadioButton radio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)radio, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"CTL_PUBLIC_OPTION"));
        radio.setToolTipText(NbBundle.getMessage(JavadocHintProvider.class, (String)"HINT_PUBLIC_OPTION"));
        radio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACD_PUBLIC_OPTION"));
        radio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACN_PUBLIC_OPTION"));
        radio.addActionListener(l);
        group.add(radio);
        radio.setSelected(radio.getText().equals(node.get(SCOPE_KEY, SCOPE_DEFAULT)));
        radio.setOpaque(false);
        res.add((Component)radio, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        radio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)radio, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"CTL_PROTECTED_OPTION"));
        radio.setToolTipText(NbBundle.getMessage(JavadocHintProvider.class, (String)"HINT_PROTECTED_OPTION"));
        radio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACD_PROTECTED_OPTION"));
        radio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACN_PROTECTED_OPTION"));
        radio.addActionListener(l);
        group.add(radio);
        radio.setSelected(radio.getText().equals(node.get(SCOPE_KEY, SCOPE_DEFAULT)));
        radio.setOpaque(false);
        res.add((Component)radio, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        radio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)radio, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"CTL_PACKAGE_OPTION"));
        radio.setToolTipText(NbBundle.getMessage(JavadocHintProvider.class, (String)"HINT_PACKAGE_OPTION"));
        radio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACD_PACKAGE_OPTION"));
        radio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACN_PACKAGE_OPTION"));
        radio.addActionListener(l);
        group.add(radio);
        radio.setSelected(radio.getText().equals(node.get(SCOPE_KEY, SCOPE_DEFAULT)));
        radio.setOpaque(false);
        res.add((Component)radio, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        radio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)radio, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"CTL_PRIVATE_OPTION"));
        radio.setToolTipText(NbBundle.getMessage(JavadocHintProvider.class, (String)"HINT_PRIVATE_OPTION"));
        radio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACD_PRIVATE_OPTION"));
        radio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACN_PRIVATE_OPTION"));
        radio.addActionListener(l);
        group.add(radio);
        radio.setSelected(radio.getText().equals(node.get(SCOPE_KEY, SCOPE_DEFAULT)));
        radio.setOpaque(false);
        res.add((Component)radio, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        outerPanel.add((Component)res, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JCheckBox apiCheckbox = new JCheckBox();
        apiCheckbox.setText(NbBundle.getMessage(JavadocHintProvider.class, (String)"CTL_APICHECKBOX"));
        apiCheckbox.setSelected(node.getBoolean(AVAILABILITY_KEY + createJavadocKind, false));
        apiCheckbox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHintProvider.class, (String)"AN_APICHECKBOX"));
        apiCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"AD_APICHECKBOX"));
        apiCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                node.putBoolean(JavadocHint.AVAILABILITY_KEY + createJavadocKind, cb.isSelected());
            }
        });
        outerPanel.add((Component)apiCheckbox, new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return outerPanel;
    }

    public static final class CustomizerProviderImplCreate
    implements CustomizerProvider {
        public JComponent getCustomizer(Preferences prefs) {
            return JavadocHint.createCustomizer(prefs, true);
        }
    }
}

