/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.javadoc.hints.JavadocGenerator;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

final class GenerateJavadocFix
extends JavaFix {
    private static final int NOPOS = -2;
    private String name;
    private final SourceVersion spec;

    public GenerateJavadocFix(String name, TreePathHandle handle, SourceVersion spec) {
        super(handle);
        this.name = name;
        this.spec = spec;
    }

    public String getText() {
        return NbBundle.getMessage(GenerateJavadocFix.class, (String)"MISSING_JAVADOC_HINT", (Object)this.name);
    }

    protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
        WorkingCopy wc = ctx.getWorkingCopy();
        TreePath path = ctx.getPath();
        Element elm = wc.getTrees().getElement(path);
        Tree t = null;
        if (elm != null) {
            t = wc.getTrees().getTree(elm);
        }
        if (t != null) {
            Tree newTree;
            JavadocGenerator gen = new JavadocGenerator(this.spec);
            String javadocTxt = gen.generateComment(elm, (CompilationInfo)wc);
            Comment javadoc = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)javadocTxt);
            TreeMaker make = wc.getTreeMaker();
            switch (t.getKind()) {
                case ANNOTATION_TYPE: {
                    ClassTree old = (ClassTree)t;
                    newTree = make.AnnotationType(old.getModifiers(), (CharSequence)old.getSimpleName(), old.getMembers());
                    break;
                }
                case CLASS: {
                    ClassTree old = (ClassTree)t;
                    newTree = make.Class(old.getModifiers(), (CharSequence)old.getSimpleName(), old.getTypeParameters(), old.getExtendsClause(), old.getImplementsClause(), old.getMembers());
                    break;
                }
                case ENUM: {
                    ClassTree old = (ClassTree)t;
                    newTree = make.Enum(old.getModifiers(), (CharSequence)old.getSimpleName(), old.getImplementsClause(), old.getMembers());
                    break;
                }
                case INTERFACE: {
                    ClassTree old = (ClassTree)t;
                    newTree = make.Interface(old.getModifiers(), (CharSequence)old.getSimpleName(), old.getTypeParameters(), old.getImplementsClause(), old.getMembers());
                    break;
                }
                case METHOD: {
                    MethodTree old = (MethodTree)t;
                    newTree = make.Method(old.getModifiers(), (CharSequence)old.getName(), old.getReturnType(), old.getTypeParameters(), old.getParameters(), old.getThrows(), old.getBody(), (ExpressionTree)old.getDefaultValue());
                    break;
                }
                case VARIABLE: {
                    VariableTree old = (VariableTree)t;
                    newTree = make.Variable(old.getModifiers(), (CharSequence)old.getName(), old.getType(), old.getInitializer());
                    break;
                }
                default: {
                    newTree = null;
                }
            }
            if (newTree != null) {
                make.addComment(newTree, javadoc, true);
                wc.rewrite(t, newTree);
            }
        }
    }
}

