/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.javadoc.hints.Access;
import org.netbeans.modules.javadoc.hints.Analyzer;
import org.netbeans.modules.javadoc.hints.JavadocGenerator;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class GenerateJavadocAction
extends TextAction {
    GenerateJavadocAction() {
        super("fix-javadoc-action");
    }

    public static GenerateJavadocAction create() {
        return new GenerateJavadocAction();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final JTextComponent jtc = this.getTextComponent(e);
        final Document doc = jtc.getDocument();
        if (!(doc instanceof StyledDocument)) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    final Descriptor desc = GenerateJavadocAction.this.prepareGenerating(doc, jtc.getCaretPosition());
                    if (desc != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GenerateJavadocAction.this.generate(doc, desc, jtc);
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        });
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private Descriptor prepareGenerating(final Document doc, final int offset) throws IOException {
        JavaSource js = JavaSource.forDocument((Document)doc);
        if (js == null) {
            return null;
        }
        final Descriptor desc = new Descriptor();
        FileObject file = (FileObject)js.getFileObjects().iterator().next();
        SourceVersion sv = Analyzer.resolveSourceVersion(file);
        final JavadocGenerator gen = new JavadocGenerator(sv);
        gen.updateSettings(file);
        js.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController javac) throws Exception {
                Element el;
                javac.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TokenHierarchy tokens = javac.getTokenHierarchy();
                TokenSequence ts = tokens.tokenSequence();
                ts.move(offset);
                if (!ts.moveNext() || ts.token().id() != JavaTokenId.JAVADOC_COMMENT) {
                    return;
                }
                desc.caret = doc.createPosition(offset);
                int jdBeginOffset = ts.offset();
                int offsetBehindJavadoc = ts.offset() + ts.token().length();
                while (ts.moveNext()) {
                    TokenId tid = ts.token().id();
                    if (tid == JavaTokenId.WHITESPACE || tid == JavaTokenId.LINE_COMMENT || tid == JavaTokenId.BLOCK_COMMENT) continue;
                    offsetBehindJavadoc = ts.offset();
                    ++offsetBehindJavadoc;
                    break;
                }
                TreePath tp = javac.getTreeUtilities().pathFor(offsetBehindJavadoc);
                Tree leaf = tp.getLeaf();
                Tree.Kind kind = leaf.getKind();
                SourcePositions positions = javac.getTrees().getSourcePositions();
                while (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)kind) && kind != Tree.Kind.METHOD && kind != Tree.Kind.VARIABLE && kind != Tree.Kind.COMPILATION_UNIT) {
                    if ((tp = tp.getParentPath()) == null) {
                        leaf = null;
                        kind = null;
                        break;
                    }
                    leaf = tp.getLeaf();
                    kind = leaf.getKind();
                }
                if (leaf == null || positions.getStartPosition(javac.getCompilationUnit(), leaf) < (long)jdBeginOffset) {
                    return;
                }
                if (kind != Tree.Kind.COMPILATION_UNIT && !Analyzer.hasErrors(leaf) && Access.PRIVATE.isAccessible((CompilationInfo)javac, tp, true) && (el = javac.getTrees().getElement(tp)) != null) {
                    desc.javadoc = gen.generateComment(el, (CompilationInfo)javac);
                }
            }
        }, true);
        return desc.javadoc != null ? desc : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(final Document doc, final Descriptor desc, final JTextComponent jtc) throws BadLocationException {
        final Indent ie = Indent.get((Document)doc);
        try {
            ie.lock();
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)doc), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        int caretPos = jtc.getCaretPosition();
                        GenerateJavadocAction.this.generateJavadoc(doc, desc, ie);
                        jtc.setCaretPosition(caretPos);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        finally {
            ie.unlock();
        }
    }

    private void generateJavadoc(Document doc, Descriptor desc, Indent ie) throws BadLocationException {
        String content = desc.javadoc;
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - "\n".length());
        }
        if (content.length() == 0) {
            return;
        }
        Position pos = desc.caret;
        int startOffset = pos.getOffset();
        doc.insertString(startOffset, content, null);
        if (startOffset != pos.getOffset()) {
            ie.reindent(startOffset + 1, pos.getOffset());
        }
    }

    private static final class Descriptor {
        String javadoc;
        Position caret;

        private Descriptor() {
        }
    }
}

