/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javadoc.hints.Access;
import org.netbeans.modules.javadoc.hints.AddTagFix;
import org.netbeans.modules.javadoc.hints.GenerateJavadocFix;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.modules.javadoc.hints.RemoveTagFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

final class Analyzer {
    private static final String ERROR_IDENT = "<error>";
    private final CompilationInfo javac;
    private final SourceVersion spec;
    private final Document doc;
    private final FileObject file;
    private final Severity severity;
    private final TreePath currentPath;
    private final boolean createJavadocKind;
    private final Access access;

    Analyzer(CompilationInfo javac, Document doc, TreePath currentPath, Severity severity, boolean createJavadocKind, Access access) {
        this.javac = javac;
        this.doc = doc;
        this.file = javac.getFileObject();
        this.currentPath = currentPath;
        this.severity = severity;
        this.spec = Analyzer.resolveSourceVersion(javac.getFileObject());
        this.createJavadocKind = createJavadocKind;
        this.access = access;
    }

    private ErrorDescription createErrorDescription(String message, LazyFixList fixes, Position[] positions) {
        if (this.severity == Severity.HINT) {
            return ErrorDescriptionFactory.createErrorDescription((Severity)this.severity, (String)message, (LazyFixList)fixes, (FileObject)this.file, (int)CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)this.file), (int)CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)this.file));
        }
        return ErrorDescriptionFactory.createErrorDescription((Severity)this.severity, (String)message, (LazyFixList)fixes, (Document)this.doc, (Position)positions[0], (Position)positions[1]);
    }

    private ErrorDescription createErrorDescription(String message, List<Fix> fixes, Position[] positions) {
        return this.createErrorDescription(message, ErrorDescriptionFactory.lazyListForFixes(fixes), positions);
    }

    public List<ErrorDescription> analyze() {
        List<ErrorDescription> errors = Collections.emptyList();
        Tree node = this.currentPath.getLeaf();
        if (this.javac.getTreeUtilities().isSynthetic(this.currentPath) || !this.isValid(this.currentPath)) {
            return errors;
        }
        Element elm = this.javac.getTrees().getElement(this.currentPath);
        if (elm == null) {
            Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, "Cannot resolve element for " + node + " in " + this.file);
            return errors;
        }
        if (this.isGuarded(node)) {
            return errors;
        }
        String jdText = this.javac.getElements().getDocComment(elm);
        if (jdText == null || jdText.length() == 0 && null == JavadocUtilities.findTokenSequence(this.javac, elm)) {
            if (!this.createJavadocKind) {
                return errors;
            }
            if (Analyzer.hasErrors(node) || JavadocUtilities.hasInheritedDoc(this.javac, elm)) {
                return errors;
            }
            try {
                Position[] positions = this.createSignaturePositions(node);
                if (positions == null) {
                    return errors;
                }
                ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_JAVADOC_DESC"), this.createGenerateFixes(elm), positions);
                errors = new ArrayList<ErrorDescription>();
                errors.add(err);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        } else {
            if (this.createJavadocKind || Analyzer.hasErrors(node)) {
                return errors;
            }
            errors = new ArrayList<ErrorDescription>();
            Doc jDoc = this.javac.getElementUtilities().javaDocFor(elm);
            if (jDoc.isMethod() || jDoc.isConstructor()) {
                ExecutableMemberDoc methDoc = (ExecutableMemberDoc)jDoc;
                ExecutableElement methodEl = (ExecutableElement)elm;
                MethodTree methodTree = (MethodTree)node;
                this.processTypeParameters(methodEl, methodTree, methDoc, errors);
                this.processParameters(methodEl, methodTree, methDoc, errors);
                this.processReturn(methodEl, methodTree, methDoc, errors);
                this.processThrows(methodEl, methodTree, methDoc, errors);
            } else if (jDoc.isClass() || jDoc.isInterface()) {
                TypeElement classEl = (TypeElement)elm;
                ClassDoc classDoc = (ClassDoc)jDoc;
                ClassTree classTree = (ClassTree)node;
                this.processTypeParameters(classEl, classTree, classDoc, errors);
                this.processParameters(classEl, classTree, classDoc, errors);
            } else if (jDoc.isAnnotationType()) {
                this.processAnnTypeParameters(elm, node, jDoc, errors);
            } else if (jDoc.isAnnotationTypeElement()) {
                AnnotationTypeElementDoc annDoc = (AnnotationTypeElementDoc)jDoc;
                ExecutableElement methodEl = (ExecutableElement)elm;
                MethodTree methodTree = (MethodTree)node;
                this.processAnnTypeParameters(methodEl, methodTree, (Doc)annDoc, errors);
                this.processReturn(methodEl, methodTree, (ExecutableMemberDoc)annDoc, errors);
                this.processAnnTypeThrows(methodEl, methodTree, annDoc, errors);
            }
            this.processDeprecatedAnnotation(elm, jDoc, errors);
        }
        return errors;
    }

    static boolean hasErrors(Tree leaf) {
        switch (leaf.getKind()) {
            case METHOD: {
                MethodTree mt = (MethodTree)leaf;
                Tree rt = mt.getReturnType();
                if (rt != null && rt.getKind() == Tree.Kind.ERRONEOUS) {
                    return true;
                }
                if (ERROR_IDENT.contentEquals(mt.getName())) {
                    return true;
                }
                for (VariableTree variableTree : mt.getParameters()) {
                    if (!ERROR_IDENT.contentEquals(variableTree.getName())) continue;
                    return true;
                }
                for (ExpressionTree expressionTree : mt.getThrows()) {
                    if (expressionTree.getKind() != Tree.Kind.ERRONEOUS && (expressionTree.getKind() != Tree.Kind.IDENTIFIER || !ERROR_IDENT.contentEquals(((IdentifierTree)expressionTree).getName()))) continue;
                    return true;
                }
                break;
            }
            case VARIABLE: {
                VariableTree vt = (VariableTree)leaf;
                return vt.getType().getKind() == Tree.Kind.ERRONEOUS || ERROR_IDENT.contentEquals(vt.getName());
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                ClassTree classTree = (ClassTree)leaf;
                if (ERROR_IDENT.contentEquals(classTree.getSimpleName())) {
                    return true;
                }
                for (TypeParameterTree typeParameterTree : classTree.getTypeParameters()) {
                    if (!ERROR_IDENT.contentEquals(typeParameterTree.getName())) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private boolean isValid(TreePath path) {
        Tree leaf = path.getLeaf();
        int caret = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)this.javac.getFileObject());
        boolean onLine = this.severity == Severity.HINT;
        switch (leaf.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return this.access.isAccessible(this.javac, path, false) && (!onLine || Analyzer.isInHeader(this.javac, (ClassTree)leaf, caret));
            }
            case METHOD: {
                return this.access.isAccessible(this.javac, path, false) && (!onLine || Analyzer.isInHeader(this.javac, (MethodTree)leaf, caret));
            }
            case VARIABLE: {
                return this.access.isAccessible(this.javac, path, false);
            }
        }
        return false;
    }

    private void processDeprecatedAnnotation(Element elm, Doc jDoc, List<ErrorDescription> errors) {
        if (SourceVersion.RELEASE_5.compareTo(this.spec) > 0 || this.javac.getElements().getTypeElement("java.lang.Deprecated") == null) {
            return;
        }
        Tag[] deprTags = jDoc.tags("@deprecated");
        AnnotationMirror annMirror = JavadocUtilities.findDeprecated(this.javac, elm);
        if (annMirror != null) {
            if (deprTags.length == 0) {
                try {
                    Position[] poss = this.createPositions(this.javac.getTrees().getTree(elm, annMirror));
                    ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_DEPRECATED_DESC"), Collections.singletonList(AddTagFix.createAddDeprecatedTagFix(elm, this.file, this.spec)), poss);
                    this.addTagHint(errors, err);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                }
            } else if (deprTags.length > 1) {
                boolean isFirst = true;
                for (Tag tag : deprTags) {
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    this.addRemoveTagFix(tag, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_DEPRECATED_DESC"), elm, errors);
                }
            }
        } else {
            if (deprTags.length > 1) {
                boolean isFirst = true;
                for (Tag tag : deprTags) {
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    this.addRemoveTagFix(tag, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_DEPRECATED_DESC"), elm, errors);
                }
            }
            if (deprTags.length > 0) {
                // empty if block
            }
        }
    }

    private void processReturn(ExecutableElement exec, MethodTree node, ExecutableMemberDoc jdoc, List<ErrorDescription> errors) {
        Tag tag;
        int i;
        TypeMirror returnType = exec.getReturnType();
        Tree returnTree = node.getReturnType();
        Tag[] tags = jdoc.tags("@return");
        if (returnType.getKind() == TypeKind.VOID) {
            for (i = 0; i < tags.length; ++i) {
                tag = tags[i];
                this.addRemoveTagFix(tag, NbBundle.getMessage(Analyzer.class, (String)(jdoc.isMethod() ? "WRONG_RETURN_DESC" : "WRONG_CONSTRUCTOR_RETURN_DESC")), exec, errors);
            }
        } else {
            for (i = 0; i < tags.length; ++i) {
                tag = tags[i];
                if (i <= 0) continue;
                this.addRemoveTagFix(tag, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_RETURN_DESC"), exec, errors);
            }
        }
        if (returnType.getKind() != TypeKind.VOID && tags.length == 0 && JavadocUtilities.findReturnTag(this.javac, (MethodDoc)jdoc, true) == null) {
            try {
                Position[] poss = this.createPositions(returnTree);
                ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_RETURN_DESC"), Collections.singletonList(AddTagFix.createAddReturnTagFix(exec, this.file, this.spec)), poss);
                this.addTagHint(errors, err);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processThrows(ExecutableElement exec, MethodTree node, ExecutableMemberDoc jdoc, List<ErrorDescription> errors) {
        void var10_13;
        List<? extends ExpressionTree> throwz = node.getThrows();
        ThrowsTag[] tags = jdoc.throwsTags();
        HashMap<String, ThrowsTag> tagNames = new HashMap<String, ThrowsTag>();
        ThrowsTag[] arr$ = tags;
        int len$ = arr$.length;
        boolean bl = false;
        while (var10_13 < len$) {
            ThrowsTag throwsTag = arr$[var10_13];
            Type tagType = throwsTag.exceptionType();
            String tagFQN = null;
            tagFQN = tagType != null ? throwsTag.exceptionType().qualifiedTypeName() : throwsTag.exceptionName();
            if (tagNames.containsKey(tagFQN)) {
                this.addRemoveTagFix((Tag)throwsTag, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_THROWS_DESC", (Object)throwsTag.name(), (Object)throwsTag.exceptionName()), exec, errors);
            } else {
                tagNames.put(tagFQN, throwsTag);
            }
            ++var10_13;
        }
        int index = 0;
        for (ExpressionTree expressionTree : throwz) {
            boolean exists;
            String fqn;
            TreePath path = new TreePath(this.currentPath, expressionTree);
            Element el = this.javac.getTrees().getElement(path);
            if (ElementKind.CLASS == el.getKind()) {
                TypeElement tel = (TypeElement)el;
                fqn = tel.getQualifiedName().toString();
            } else if (ElementKind.TYPE_PARAMETER == el.getKind()) {
                fqn = el.getSimpleName().toString();
            } else {
                Logger.getLogger(Analyzer.class.getName()).log(Level.FINE, "Illegal throw kind: {0} of {1} in {2}", new Object[]{el.getKind(), el, exec});
                return;
            }
            boolean bl2 = exists = tagNames.remove(fqn) != null;
            if (!exists && (jdoc.isConstructor() || jdoc.isMethod() && JavadocUtilities.findThrowsTag(this.javac, (MethodDoc)jdoc, fqn, true) == null)) {
                try {
                    Position[] poss = this.createPositions(expressionTree);
                    String insertName = Analyzer.resolveThrowsName(el, fqn, expressionTree);
                    ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_THROWS_DESC", (Object)fqn), Collections.singletonList(AddTagFix.createAddThrowsTagFix(exec, insertName, index, this.file, this.spec)), poss);
                    this.addTagHint(errors, err);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                }
            }
            ++index;
        }
        TypeMirror rtException = this.javac.getElements().getTypeElement("java.lang.RuntimeException").asType();
        TypeMirror typeMirror = this.javac.getElements().getTypeElement("java.lang.Error").asType();
        for (ThrowsTag throwsTag : tagNames.values()) {
            Element throwEl;
            Type throwsType = throwsTag.exceptionType();
            ClassDoc throwClassDoc = null;
            if (throwsType != null) {
                throwClassDoc = throwsType.asClassDoc();
            }
            if (throwClassDoc != null && (throwEl = this.javac.getElementUtilities().elementFor((Doc)throwClassDoc)) != null && (this.javac.getTypes().isSubtype(throwEl.asType(), rtException) || this.javac.getTypes().isSubtype(throwEl.asType(), typeMirror))) continue;
            this.addRemoveTagFix((Tag)throwsTag, NbBundle.getMessage(Analyzer.class, (String)"UNKNOWN_THROWABLE_DESC", (Object)throwsTag.name(), (Object)throwsTag.exceptionName()), exec, errors);
        }
    }

    private void processAnnTypeThrows(ExecutableElement exec, MethodTree node, AnnotationTypeElementDoc jdoc, List<ErrorDescription> errors) {
        Tag[] tags;
        for (Tag tag : tags = jdoc.tags("@throws")) {
            ThrowsTag throwsTag = (ThrowsTag)tag;
            this.addRemoveTagFix((Tag)throwsTag, NbBundle.getMessage(Analyzer.class, (String)"ILLEGAL_ANNOTATION_TYPE_THROWS_DESC", (Object)throwsTag.name(), (Object)throwsTag.exceptionName()), exec, errors);
        }
    }

    private void processAnnTypeParameters(Element elm, Tree node, Doc jdoc, List<ErrorDescription> errors) {
        Tag[] tags;
        for (Tag tag : tags = jdoc.tags("@param")) {
            ParamTag paramTag = (ParamTag)tag;
            this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(Analyzer.class, (String)"ILLEGAL_ANNOTATION_TYPE_PARAM_DESC", (Object)paramTag.parameterName()), elm, errors);
        }
    }

    private void processParameters(ExecutableElement exec, MethodTree node, ExecutableMemberDoc jdoc, List<ErrorDescription> errors) {
        List<? extends VariableTree> params = node.getParameters();
        ParamTag[] tags = jdoc.paramTags();
        HashMap<String, ParamTag> tagNames = new HashMap<String, ParamTag>();
        for (ParamTag paramTag : tags) {
            if (tagNames.containsKey(paramTag.parameterName())) {
                this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_PARAM_DESC", (Object)paramTag.parameterName()), exec, errors);
                continue;
            }
            tagNames.put(paramTag.parameterName(), paramTag);
        }
        for (VariableTree variableTree : params) {
            boolean exists = tagNames.remove(variableTree.getName().toString()) != null;
            if (exists || !jdoc.isConstructor() && (!jdoc.isMethod() || JavadocUtilities.findParamTag(this.javac, (MethodDoc)jdoc, variableTree.getName().toString(), false, true) != null)) continue;
            try {
                Position[] poss = this.createPositions(variableTree);
                ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_PARAM_DESC", (Object)variableTree.getName()), Collections.singletonList(AddTagFix.createAddParamTagFix(exec, variableTree.getName().toString(), this.file, this.spec)), poss);
                this.addTagHint(errors, err);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
        for (ParamTag paramTag : tagNames.values()) {
            this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(Analyzer.class, (String)"UNKNOWN_PARAM_DESC", (Object)paramTag.parameterName()), exec, errors);
        }
    }

    private void processParameters(TypeElement elm, ClassTree node, ClassDoc jdoc, List<ErrorDescription> errors) {
        for (Tag tag : jdoc.tags("@param")) {
            ParamTag paramTag = (ParamTag)tag;
            if (paramTag.isTypeParameter()) continue;
            this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(Analyzer.class, (String)"UNKNOWN_PARAM_DESC", (Object)paramTag.parameterName()), elm, errors);
        }
    }

    private void processTypeParameters(TypeElement elm, ClassTree node, ClassDoc jdoc, List<ErrorDescription> errors) {
        this.processTypeParameters(elm, node.getTypeParameters(), jdoc.typeParamTags(), (Doc)jdoc, errors);
    }

    private void processTypeParameters(ExecutableElement elm, MethodTree node, ExecutableMemberDoc jdoc, List<ErrorDescription> errors) {
        this.processTypeParameters(elm, node.getTypeParameters(), jdoc.typeParamTags(), (Doc)jdoc, errors);
    }

    private void processTypeParameters(Element elm, List<? extends TypeParameterTree> params, ParamTag[] tags, Doc jdoc, List<ErrorDescription> errors) {
        HashMap<String, ParamTag> tagNames = new HashMap<String, ParamTag>();
        for (ParamTag paramTag : tags) {
            if (tagNames.containsKey(paramTag.parameterName())) {
                String typeParamName = '<' + paramTag.parameterName() + '>';
                this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_TYPEPARAM_DESC", (Object)typeParamName), elm, errors);
                continue;
            }
            tagNames.put(paramTag.parameterName(), paramTag);
        }
        for (TypeParameterTree typeParameterTree : params) {
            boolean exists = tagNames.remove(typeParameterTree.getName().toString()) != null;
            if (exists || jdoc.isMethod() && (!jdoc.isMethod() || JavadocUtilities.findParamTag(this.javac, (MethodDoc)jdoc, typeParameterTree.getName().toString(), true, true) != null)) continue;
            try {
                Position[] poss = this.createPositions(typeParameterTree);
                String paramName = typeParameterTree.getName().toString();
                String typeParamName = '<' + paramName + '>';
                ErrorDescription err = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_TYPEPARAM_DESC", (Object)typeParamName), Collections.singletonList(AddTagFix.createAddTypeParamTagFix(elm, paramName, this.file, this.spec)), poss);
                this.addTagHint(errors, err);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
        for (ParamTag paramTag : tagNames.values()) {
            String typeParamName = '<' + paramTag.parameterName() + '>';
            this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(Analyzer.class, (String)"UNKNOWN_TYPEPARAM_DESC", (Object)typeParamName), elm, errors);
        }
    }

    Position[] createPositions(Tree t) throws BadLocationException {
        Position[] poss = new Position[2];
        int start = (int)this.javac.getTrees().getSourcePositions().getStartPosition(this.javac.getCompilationUnit(), t);
        int end = (int)this.javac.getTrees().getSourcePositions().getEndPosition(this.javac.getCompilationUnit(), t);
        poss[0] = this.doc.createPosition(start);
        poss[1] = this.doc.createPosition(end);
        return poss;
    }

    Position[] createSignaturePositions(final Tree t) throws BadLocationException {
        final Position[] pos = new Position[2];
        final BadLocationException[] blex = new BadLocationException[1];
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    int[] span = null;
                    if (t.getKind() == Tree.Kind.METHOD) {
                        span = Analyzer.this.javac.getTreeUtilities().findNameSpan((MethodTree)t);
                    } else if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
                        span = Analyzer.this.javac.getTreeUtilities().findNameSpan((ClassTree)t);
                    } else if (Tree.Kind.VARIABLE == t.getKind()) {
                        span = Analyzer.this.javac.getTreeUtilities().findNameSpan((VariableTree)t);
                    }
                    if (span != null) {
                        pos[0] = Analyzer.this.doc.createPosition(span[0]);
                        pos[1] = Analyzer.this.doc.createPosition(span[1]);
                    }
                }
                catch (BadLocationException ex) {
                    blex[0] = ex;
                }
            }
        });
        if (blex[0] != null) {
            throw (BadLocationException)new BadLocationException(blex[0].getMessage(), blex[0].offsetRequested()).initCause(blex[0]);
        }
        return pos[0] != null ? pos : null;
    }

    private boolean isGuarded(Tree node) {
        GuardedSectionManager guards = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)this.doc));
        if (guards != null) {
            try {
                int startOff = (int)this.javac.getTrees().getSourcePositions().getStartPosition(this.javac.getCompilationUnit(), node);
                Position startPos = this.doc.createPosition(startOff);
                for (GuardedSection guard : guards.getGuardedSections()) {
                    if (!guard.contains(startPos, false)) continue;
                    return true;
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                return true;
            }
        }
        return false;
    }

    private void addRemoveTagFix(Tag tag, String description, Element elm, List<ErrorDescription> errors) {
        try {
            Position[] poss = JavadocUtilities.findTagNameBounds(this.javac, this.doc, tag);
            if (poss == null) {
                throw new BadLocationException("no position for " + tag, -1);
            }
            ErrorDescription err = this.createErrorDescription(description, Collections.singletonList(new RemoveTagFix(tag.name(), JavadocUtilities.TagHandle.create(tag), ElementHandle.create((Element)elm), this.file, this.spec)), poss);
            this.addTagHint(errors, err);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
    }

    JavadocLazyFixList createGenerateFixes(Element elm) {
        ArrayList<Fix> fixes = new ArrayList<Fix>(3);
        TreePathHandle handle = TreePathHandle.create((TreePath)this.javac.getTrees().getPath(elm), (CompilationInfo)this.javac);
        String description = elm.getKind() == ElementKind.CONSTRUCTOR ? elm.getEnclosingElement().getSimpleName().toString() : elm.getSimpleName().toString();
        JavadocLazyFixList fixList = new JavadocLazyFixList(fixes);
        GenerateJavadocFix javadocFix = new GenerateJavadocFix(description, handle, this.spec);
        fixes.add(javadocFix.toEditorFix());
        return fixList;
    }

    private void addTagHint(List<ErrorDescription> errors, ErrorDescription desc) {
        errors.add(desc);
    }

    private static boolean isInHeader(CompilationInfo info, ClassTree tree, int offset) {
        CompilationUnitTree cut = info.getCompilationUnit();
        SourcePositions sp = info.getTrees().getSourcePositions();
        long lastKnownOffsetInHeader = sp.getStartPosition(cut, tree);
        List<? extends Tree> impls = tree.getImplementsClause();
        if (impls != null && !impls.isEmpty()) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, impls.get(impls.size() - 1));
        } else {
            List<? extends TypeParameterTree> typeparams = tree.getTypeParameters();
            if (typeparams != null && !typeparams.isEmpty()) {
                lastKnownOffsetInHeader = sp.getEndPosition(cut, typeparams.get(typeparams.size() - 1));
            } else if (tree.getExtendsClause() != null) {
                lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getExtendsClause());
            } else if (tree.getModifiers() != null) {
                lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getModifiers());
            }
        }
        TokenSequence ts = info.getTreeUtilities().tokensFor((Tree)tree);
        ts.move((int)lastKnownOffsetInHeader);
        while (ts.moveNext()) {
            if (ts.token().id() != JavaTokenId.LBRACE) continue;
            return offset < ts.offset();
        }
        return false;
    }

    private static boolean isInHeader(CompilationInfo info, MethodTree tree, int offset) {
        CompilationUnitTree cut = info.getCompilationUnit();
        SourcePositions sp = info.getTrees().getSourcePositions();
        long lastKnownOffsetInHeader = sp.getStartPosition(cut, tree);
        List<? extends ExpressionTree> throwz = tree.getThrows();
        if (throwz != null && !throwz.isEmpty()) {
            lastKnownOffsetInHeader = sp.getEndPosition(cut, throwz.get(throwz.size() - 1));
        } else {
            List<? extends VariableTree> params = tree.getParameters();
            if (params != null && !params.isEmpty()) {
                lastKnownOffsetInHeader = sp.getEndPosition(cut, params.get(params.size() - 1));
            } else {
                List<? extends TypeParameterTree> typeparams = tree.getTypeParameters();
                if (typeparams != null && !typeparams.isEmpty()) {
                    lastKnownOffsetInHeader = sp.getEndPosition(cut, typeparams.get(typeparams.size() - 1));
                } else if (tree.getReturnType() != null) {
                    lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getReturnType());
                } else if (tree.getModifiers() != null) {
                    lastKnownOffsetInHeader = sp.getEndPosition(cut, tree.getModifiers());
                }
            }
        }
        TokenSequence ts = info.getTreeUtilities().tokensFor((Tree)tree);
        ts.move((int)lastKnownOffsetInHeader);
        while (ts.moveNext()) {
            if (ts.token().id() != JavaTokenId.LBRACE && ts.token().id() != JavaTokenId.SEMICOLON) continue;
            return offset < ts.offset();
        }
        return false;
    }

    static SourceVersion resolveSourceVersion(FileObject file) {
        String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)file);
        if (sourceLevel == null) {
            return SourceVersion.latest();
        }
        if (sourceLevel.startsWith("1.6")) {
            return SourceVersion.RELEASE_6;
        }
        if (sourceLevel.startsWith("1.5")) {
            return SourceVersion.RELEASE_5;
        }
        if (sourceLevel.startsWith("1.4")) {
            return SourceVersion.RELEASE_4;
        }
        if (sourceLevel.startsWith("1.3")) {
            return SourceVersion.RELEASE_3;
        }
        if (sourceLevel.startsWith("1.2")) {
            return SourceVersion.RELEASE_2;
        }
        if (sourceLevel.startsWith("1.1")) {
            return SourceVersion.RELEASE_1;
        }
        if (sourceLevel.startsWith("1.0")) {
            return SourceVersion.RELEASE_0;
        }
        return SourceVersion.latest();
    }

    static String resolveThrowsName(Element el, String fqn, ExpressionTree throwTree) {
        boolean nestedClass = ElementKind.CLASS == el.getKind() && NestingKind.TOP_LEVEL != ((TypeElement)el).getNestingKind();
        String insertName = nestedClass ? fqn : throwTree.toString();
        return insertName;
    }

    private static final class JavadocLazyFixList
    implements LazyFixList {
        private List<Fix> contexFixes;

        public JavadocLazyFixList(List<Fix> contexFixes) {
            this.contexFixes = contexFixes;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public boolean probablyContainsFixes() {
            return true;
        }

        public List<Fix> getFixes() {
            return this.contexFixes;
        }

        public boolean isComputed() {
            return true;
        }
    }
}

