/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.j2ee.core;

import java.util.Comparator;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.NbBundle;

public final class Profile {
    public static final Comparator<Profile> UI_COMPARATOR = new Comparator<Profile>(){

        @Override
        public int compare(Profile o1, Profile o2) {
            return -(o1.order - o2.order);
        }
    };
    public static final Profile J2EE_13 = new Profile(1, "1.3", null, "J2EE13.displayName");
    public static final Profile J2EE_14 = new Profile(2, "1.4", null, "J2EE14.displayName");
    public static final Profile JAVA_EE_5 = new Profile(3, "1.5", null, "JavaEE5.displayName");
    public static final Profile JAVA_EE_6_FULL = new Profile(4, "1.6", null, "JavaEE6Full.displayName");
    public static final Profile JAVA_EE_6_WEB = new Profile(5, "1.6", "web", "JavaEE6Web.displayName");
    public static final Profile JAVA_EE_7_FULL = new Profile(6, "1.7", null, "JavaEE7Full.displayName");
    public static final Profile JAVA_EE_7_WEB = new Profile(7, "1.7", "web", "JavaEE7Web.displayName");
    private final int order;
    private final String propertiesString;
    private final String bundleKey;

    private Profile(int order, String canonicalName, String profile, String bundleKey) {
        this.order = order;
        this.bundleKey = bundleKey;
        StringBuilder builder = new StringBuilder(canonicalName);
        if (profile != null) {
            builder.append("-").append(profile);
        }
        this.propertiesString = builder.toString();
    }

    @NonNull
    public String getDisplayName() {
        return NbBundle.getMessage(Profile.class, (String)this.bundleKey);
    }

    @NonNull
    public String toPropertiesString() {
        return this.propertiesString;
    }

    public String toString() {
        return this.toPropertiesString();
    }

    @CheckForNull
    public static Profile fromPropertiesString(@NullAllowed String value) {
        if (J2EE_13.toPropertiesString().equals(value)) {
            return J2EE_13;
        }
        if (J2EE_14.toPropertiesString().equals(value)) {
            return J2EE_14;
        }
        if (JAVA_EE_5.toPropertiesString().equals(value)) {
            return JAVA_EE_5;
        }
        if (JAVA_EE_6_FULL.toPropertiesString().equals(value) || "EE_6_FULL".equals(value)) {
            return JAVA_EE_6_FULL;
        }
        if (JAVA_EE_6_WEB.toPropertiesString().equals(value) || "EE_6_WEB".equals(value)) {
            return JAVA_EE_6_WEB;
        }
        if (JAVA_EE_7_FULL.toPropertiesString().equals(value) || "EE_7_FULL".equals(value)) {
            return JAVA_EE_7_FULL;
        }
        if (JAVA_EE_7_WEB.toPropertiesString().equals(value) || "EE_7_WEB".equals(value)) {
            return JAVA_EE_7_WEB;
        }
        return null;
    }
}

