/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.jaxwsmodelapi.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.jaxwsmodelapi.wsdlmodel.WsdlModelProvider;
import org.netbeans.modules.websvc.manager.WebServicePersistenceManager;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.codegen.Wsdl2Java;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.model.WebServiceGroup;
import org.netbeans.modules.websvc.manager.model.WebServiceListModel;
import org.netbeans.modules.websvc.manager.spi.WebServiceManagerExt;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class WebServiceManager {
    public static final String WEBSVC_HOME = WebServiceDescriptor.WEBSVC_HOME;
    private int mutatorCount;
    private static final WebServiceManager INSTANCE = new WebServiceManager();

    private WebServiceManager() {
    }

    public static WebServiceManager getInstance() {
        return INSTANCE;
    }

    public void addWebService(WebServiceData wsData) throws IOException {
        this.addWebService(wsData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebService(WebServiceData wsData, boolean compile) throws IOException {
        block26: {
            try {
                this.incrementMutatorCount();
                WebServiceListModel listModel = WebServiceListModel.getInstance();
                if (wsData.getState().equals((Object)WebServiceData.State.WSDL_UNRETRIEVED) || wsData.getState().equals((Object)WebServiceData.State.WSDL_RETRIEVING) && !wsData.isResolved()) {
                    wsData.setState(WebServiceData.State.WSDL_RETRIEVING);
                    File localWsdlFile = null;
                    try {
                        localWsdlFile = WebServiceManager.copyWsdlResources(wsData.getOriginalWsdlUrl());
                    }
                    catch (IOException ex) {
                        wsData.setState(WebServiceData.State.WSDL_UNRETRIEVED);
                        throw ex;
                    }
                    File catalogFile = new File(WEBSVC_HOME, WsdlUtil.getCatalogForWsdl((String)wsData.getOriginalWsdlUrl()));
                    wsData.setWsdlFile(localWsdlFile.getAbsolutePath());
                    wsData.setCatalog(catalogFile.getAbsolutePath());
                    wsData.setState(WebServiceData.State.WSDL_RETRIEVED);
                }
                assert (wsData.getWsdlFile() != null);
                WsdlModel wsdlModel = this.getWsdlModel(wsData);
                boolean dataInModel = listModel.webServiceExists(wsData);
                if (wsdlModel == null) {
                    wsData.setResolved(false);
                    this.removeWebService(wsData, true, false);
                    return;
                }
                if (wsdlModel.getServices().isEmpty()) {
                    this.removeWebService(wsData);
                    String message = NbBundle.getMessage(WebServiceManager.class, (String)"WS_NO_METHODS_ERROR");
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)message);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                    return;
                }
                if (dataInModel) {
                    boolean assigned = false;
                    for (WSService service : wsdlModel.getServices()) {
                        if (!service.getName().equals(wsData.getName())) continue;
                        assigned = true;
                        wsData.setWsdlService(service);
                        wsData.setResolved(true);
                    }
                    if (!assigned) {
                        WSService defaultService = (WSService)wsdlModel.getServices().get(0);
                        wsData.setWsdlService(defaultService);
                        wsData.setName(defaultService.getName());
                        wsData.setResolved(true);
                    }
                    listModel.getWebServiceGroup(wsData.getGroupId()).modify(wsData.getId());
                    try {
                        if (compile && !wsData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILED)) {
                            WebServiceManager.compileService(wsData);
                        }
                        break block26;
                    }
                    finally {
                        if (wsData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILE_FAILED)) {
                            wsData.setResolved(false);
                        }
                    }
                }
                boolean first = true;
                for (WSService service : wsdlModel.getServices()) {
                    WebServiceData newData;
                    if (first) {
                        first = false;
                        newData = wsData;
                    } else {
                        newData = new WebServiceData(wsData.getWsdlFile(), wsData.getOriginalWsdlUrl(), wsData.getGroupId());
                    }
                    newData.setWsdlService(service);
                    newData.setResolved(true);
                    newData.setName(service.getName());
                    listModel.addWebService(newData);
                    WebServiceGroup group = listModel.getWebServiceGroup(newData.getGroupId());
                    if (group != null) {
                        group.add(newData.getId());
                    }
                    try {
                        if (!compile || newData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILED)) continue;
                        WebServiceManager.compileService(newData);
                    }
                    finally {
                        if (!newData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILE_FAILED)) continue;
                        this.removeWebService(newData);
                    }
                }
            }
            finally {
                this.save();
            }
        }
    }

    public WsdlModel getWsdlModel(WebServiceData wsData) throws IOException {
        File localWsdlFile = new File(wsData.getWsdlFile());
        URL wsdlUrl = localWsdlFile.toURI().toURL();
        WsdlModelProvider wsdlModelProvider = null;
        Collection providers = Lookup.getDefault().lookupAll(WsdlModelProvider.class);
        boolean notAccepted = false;
        if (providers != null) {
            for (WsdlModelProvider provider : providers) {
                if (provider.canAccept(wsdlUrl)) {
                    wsdlModelProvider = provider;
                    break;
                }
                notAccepted = true;
            }
        }
        WsdlModel wsdlModel = null;
        Throwable exc = null;
        if (wsdlModelProvider != null) {
            String packageName = wsData.getPackageName();
            if (packageName == null || packageName.trim().length() == 0) {
                packageName = wsdlModelProvider.getEffectivePackageName();
            }
            File catalogFile = new File(wsData.getCatalog());
            URL catalogUrl = catalogFile.toURI().toURL();
            try {
                wsdlModel = wsdlModelProvider.getWsdlModel(wsdlUrl, packageName, catalogUrl, true);
            }
            catch (Exception ex) {
                Throwable e = ex.getCause();
                Throwable throwable = exc = e == null ? ex : e;
            }
        }
        if (wsdlModel == null) {
            wsData.setResolved(false);
            this.removeWebService(wsData, true, false);
            if (wsdlModelProvider == null && notAccepted) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServiceManager.class, (String)"JAX_RPC_MODELER_ERROR")));
            } else if (wsdlModelProvider != null) {
                Throwable ex = wsdlModelProvider.getCreationException();
                if (ex != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServiceManager.class, (String)"JAX_WS_MODEL_CREATION_ERROR", (Object)ex.getLocalizedMessage())));
                } else if (exc != null) {
                    Logger.getLogger(WebServiceManager.class.getName()).log(Level.WARNING, NbBundle.getMessage(WebServiceManager.class, (String)"JAX_WS_MODELER_ERROR"), exc);
                } else {
                    String message = NbBundle.getMessage(WebServiceManager.class, (String)"WS_MODELER_ERROR");
                    exc = new IllegalStateException(message);
                    Exceptions.printStackTrace((Throwable)exc);
                }
            } else {
                String message = NbBundle.getMessage(WebServiceManager.class, (String)"WS_MODELER_ERROR");
                exc = new IllegalStateException(message);
                Exceptions.printStackTrace((Throwable)exc);
            }
        }
        return wsdlModel;
    }

    public void refreshWebService(WebServiceData wsData) throws IOException {
        this.removeWebService(wsData, false, true);
        wsData.setWsdlFile(null);
        wsData.setState(WebServiceData.State.WSDL_UNRETRIEVED);
        wsData.setCatalog(null);
        wsData.setWsdlService(null);
        wsData.setJaxRpcDescriptorPath(null);
        wsData.setJaxRpcDescriptor(null);
        wsData.setJaxWsDescriptor(null);
        wsData.setJaxWsDescriptorPath(null);
        this.addWebService(wsData, true);
    }

    public void resetWebService(WebServiceData wsData) {
        this.removeWebService(wsData, false, true);
        wsData.setWsdlFile(null);
        wsData.setState(WebServiceData.State.WSDL_UNRETRIEVED);
        wsData.setCatalog(null);
        wsData.setWsdlService(null);
        wsData.setJaxRpcDescriptorPath(null);
        wsData.setJaxRpcDescriptor(null);
        wsData.setJaxWsDescriptor(null);
        wsData.setJaxWsDescriptorPath(null);
    }

    public WebServiceData addWebService(String wsdl, String packageName, String groupId) throws IOException {
        WebServiceData wsData = new WebServiceData(wsdl, groupId);
        wsData.setPackageName(packageName);
        wsData.setResolved(false);
        this.addWebService(wsData, true);
        return wsData;
    }

    public void removeWebService(WebServiceData wsData) {
        this.removeWebService(wsData, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWebService(WebServiceData wsData, boolean removeFromModel, boolean deleteWsdl) {
        try {
            this.incrementMutatorCount();
            if (removeFromModel) {
                WebServiceListModel.getInstance().removeWebService(wsData.getId());
            }
            Collection extensions = Lookup.getDefault().lookupAll(WebServiceManagerExt.class);
            WebServiceDescriptor jaxRpcDescriptor = wsData.getJaxRpcDescriptor();
            WebServiceDescriptor jaxWsDescriptor = wsData.getJaxWsDescriptor();
            for (WebServiceManagerExt extension : extensions) {
                if (jaxRpcDescriptor != null) {
                    extension.wsServiceRemovedExt(jaxRpcDescriptor);
                }
                if (jaxWsDescriptor == null) continue;
                extension.wsServiceRemovedExt(jaxWsDescriptor);
            }
            this.deleteWsArtifacts(jaxRpcDescriptor);
            this.deleteWsArtifacts(jaxWsDescriptor);
            if (wsData.getName() != null) {
                new File(WEBSVC_HOME, wsData.getName()).delete();
            }
            if (wsData.getWsdlFile() == null) {
                return;
            }
            if (!deleteWsdl) {
                return;
            }
            WebServiceListModel model = WebServiceListModel.getInstance();
            for (WebServiceData data : model.getWebServiceSet()) {
                if (data == wsData || !wsData.getWsdlFile().equals(data.getWsdlFile())) continue;
                deleteWsdl = false;
                break;
            }
            if (deleteWsdl) {
                File catalogFile;
                WebServiceManager.rmDir(new File(wsData.getWsdlFile()));
                if (wsData.getCatalog() != null && (catalogFile = new File(wsData.getCatalog())).exists()) {
                    WebServiceManager.rmDir(catalogFile.getParentFile());
                }
            }
        }
        finally {
            this.save();
        }
    }

    private void deleteWsArtifacts(WebServiceDescriptor proxyDescriptor) {
        if (proxyDescriptor == null) {
            return;
        }
        File proxyRoot = proxyDescriptor.getXmlDescriptorFile().getParentFile();
        assert (proxyRoot != null);
        for (WsdlServiceProxyDescriptor.JarEntry jar : proxyDescriptor.getJars()) {
            File jarFile = new File(proxyRoot, jar.getName());
            jarFile.delete();
        }
        proxyDescriptor.getXmlDescriptorFile().delete();
        proxyRoot.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rmDir(File dir) {
        if (dir == null) {
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)dir);
        if (fo != null) {
            FileLock lock = null;
            try {
                lock = fo.lock();
                fo.delete(lock);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    static File copyWsdlResources(String wsdlUrl) throws IOException {
        File userDirFile = new File(WEBSVC_HOME);
        File catalogFile = new File(userDirFile, WsdlUtil.getCatalogForWsdl((String)wsdlUrl));
        File dir = catalogFile.getParentFile();
        boolean success = false;
        dir = catalogFile.getParentFile();
        try {
            FileObject dirFO = FileUtil.createFolder((File)dir);
            URI catalog = catalogFile.toURI();
            URI wsdlUri = new URL(wsdlUrl).toURI();
            Retriever retriever = Retriever.getDefault();
            FileObject wsdlFO = retriever.retrieveResource(dirFO, catalog, wsdlUri);
            if (wsdlFO == null) {
                throw new IOException(NbBundle.getMessage(WebServiceManager.class, (String)"WSDL_COPY_ERROR"));
            }
            FileUtil.createFolder((File)new File(WEBSVC_HOME));
            File result = FileUtil.toFile((FileObject)wsdlFO);
            success = true;
            File file = result;
            return file;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        finally {
            if (catalogFile.exists() && !success) {
                WebServiceManager.rmDir(catalogFile.getParentFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void compileService(WebServiceData wsData) {
        boolean compileAttempted = false;
        try {
            if (WebServiceListModel.getInstance().getWebService(wsData.getId()) == null || wsData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILED) || wsData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILING)) {
                return;
            }
            wsData.setState(WebServiceData.State.WSDL_SERVICE_COMPILING);
            compileAttempted = true;
            Collection extensions = Lookup.getDefault().lookupAll(WebServiceManagerExt.class);
            WSService svc = wsData.getWsdlService();
            Wsdl2Java wsdl2Java = new Wsdl2Java(wsData);
            boolean success = wsdl2Java.createProxyJars();
            if (!success) {
                return;
            }
            URL wsdl = new File(wsData.getWsdlFile()).toURI().toURL();
            String packageName = wsData.getEffectivePackageName();
            if (wsData.isJaxRpcEnabled()) {
                WebServiceDescriptor jaxRpcDescriptor = new WebServiceDescriptor(wsData.getName(), packageName, 0, wsdl, new File(WEBSVC_HOME, wsData.getJaxRpcDescriptorPath()), svc);
                jaxRpcDescriptor.addJar(wsData.getName() + ".jar", "proxy");
                jaxRpcDescriptor.addJar(wsData.getName() + "-src.jar", "source");
                wsData.setJaxRpcDescriptor(jaxRpcDescriptor);
            }
            if (wsData.isJaxWsEnabled()) {
                WebServiceDescriptor jaxWsDescriptor = new WebServiceDescriptor(wsData.getName(), packageName, 1, wsdl, new File(WEBSVC_HOME, wsData.getJaxWsDescriptorPath()), svc);
                jaxWsDescriptor.addJar(wsData.getName() + ".jar", "proxy");
                jaxWsDescriptor.addJar(wsData.getName() + "-src.jar", "source");
                wsData.setJaxWsDescriptor(jaxWsDescriptor);
            }
            boolean hasJaxWsConsumer = false;
            boolean hasJaxRpcConsumer = false;
            for (WebServiceManagerExt extension : extensions) {
                if (wsData.getJaxRpcDescriptor() != null && extension.wsServiceAddedExt(wsData.getJaxRpcDescriptor())) {
                    hasJaxRpcConsumer = true;
                }
                if (wsData.getJaxWsDescriptor() == null || !extension.wsServiceAddedExt(wsData.getJaxWsDescriptor())) continue;
                hasJaxWsConsumer = true;
            }
            if (!hasJaxWsConsumer && !hasJaxRpcConsumer) {
                WebServiceManager.getInstance().removeWebService(wsData);
            } else if (!hasJaxWsConsumer && wsData.getJaxWsDescriptor() != null) {
                WebServiceManager.getInstance().deleteWsArtifacts(wsData.getJaxWsDescriptor());
                wsData.setJaxWsDescriptor(null);
                wsData.setJaxWsDescriptorPath(null);
                wsData.setJaxWsEnabled(false);
            } else if (!hasJaxRpcConsumer && wsData.getJaxRpcDescriptor() != null) {
                WebServiceManager.getInstance().deleteWsArtifacts(wsData.getJaxRpcDescriptor());
                wsData.setJaxRpcDescriptor(null);
                wsData.setJaxRpcDescriptorPath(null);
                wsData.setJaxRpcEnabled(false);
            }
            if (hasJaxWsConsumer || hasJaxRpcConsumer) {
                wsData.setState(WebServiceData.State.WSDL_SERVICE_COMPILED);
                wsData.setCompiled(true);
            }
        }
        catch (IOException ex) {
            Logger.global.log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        finally {
            if (!wsData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILED) && compileAttempted) {
                wsData.setState(WebServiceData.State.WSDL_SERVICE_COMPILE_FAILED);
            } else {
                WebServiceManager.saveDescriptor(wsData);
            }
        }
    }

    private synchronized void incrementMutatorCount() {
        ++this.mutatorCount;
    }

    private synchronized void save() {
        if (--this.mutatorCount <= 0 && WebServiceListModel.getInstance().isDirty()) {
            new WebServicePersistenceManager().save();
            WebServiceListModel.getInstance().setDirty(false);
        }
    }

    private static void saveDescriptor(WebServiceData data) {
        WebServicePersistenceManager mgr = new WebServicePersistenceManager();
        try {
            WebServiceDescriptor desc = data.getJaxWsDescriptor();
            mgr.saveDescriptor(desc);
            desc = data.getJaxRpcDescriptor();
            mgr.saveDescriptor(desc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

