/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.ui.options;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.smarty.SmartyFramework;
import org.netbeans.modules.php.smarty.ui.options.SmartyOptions;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SmartyOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -1384644114740L;
    private final transient ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final int MAX_SCANNING_DEPTH = 3;
    private JRadioButton asSmartyRadioButton;
    private JLabel closeDelimiterLabel;
    private JTextField closeDelimiterTextField;
    private JComboBox depthOfScanningComboBox;
    private JLabel depthOfScanningLabel;
    private JLabel depthOfScanningNoteLabel;
    private JLabel editorSettingsLabel;
    private JLabel errorLabel;
    private JLabel installationInfoLabel;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel learnMoreLabel;
    private JLabel openDelimiterLabel;
    private JTextField openDelimiterTextField;
    private JRadioButton perContextRadioButton;
    private JLabel projectSettingsLabel;
    private JComboBox smartyVersionComboBox;
    private JLabel smartyVersionLabel;
    private ButtonGroup toggleCommentButtonGroup;
    private JLabel toggleCommentLable;

    public SmartyOptionsPanel() {
        this.initComponents();
        this.initSmartyVersionsComboBox();
        this.errorLabel.setText(" ");
        this.setDepthOfScanningComboBox();
        this.setSmartyVersion(SmartyOptions.getInstance().getSmartyVersion());
        this.setOpenDelimiter(SmartyOptions.getInstance().getDefaultOpenDelimiter());
        this.setCloseDelimiter(SmartyOptions.getInstance().getDefaultCloseDelimiter());
        this.setToggleCommentOption(SmartyOptions.getInstance().getToggleCommentOption());
        this.setDepthOfScanning(SmartyFramework.getDepthOfScanningForTpl());
        this.smartyVersionComboBox.addActionListener(new SmartyActionListener());
        this.openDelimiterTextField.getDocument().addDocumentListener(new SmartyDocumentListener());
        this.closeDelimiterTextField.getDocument().addDocumentListener(new SmartyDocumentListener());
        this.depthOfScanningComboBox.addActionListener(new SmartyActionListener());
    }

    private void setDepthOfScanningComboBox() {
        for (int i = 0; i <= 3; ++i) {
            this.depthOfScanningComboBox.addItem(String.valueOf(i));
        }
    }

    public String getCloseDelimiter() {
        return this.closeDelimiterTextField.getText();
    }

    public final void setCloseDelimiter(String closeDelimiter) {
        this.closeDelimiterTextField.setText(closeDelimiter);
    }

    public String getOpenDelimiter() {
        return this.openDelimiterTextField.getText();
    }

    public final void setOpenDelimiter(String openDelimiter) {
        this.openDelimiterTextField.setText(openDelimiter);
    }

    public int getDepthOfScanning() {
        return this.depthOfScanningComboBox.getSelectedIndex();
    }

    public final void setDepthOfScanning(int depth) {
        if (depth > 3) {
            depth = 3;
        } else if (depth < 0) {
            depth = 0;
        }
        this.depthOfScanningComboBox.setSelectedIndex(depth);
    }

    public final void setSmartyVersion(SmartyFramework.Version version) {
        this.smartyVersionComboBox.setSelectedItem((Object)version);
    }

    public SmartyFramework.Version getSmartyVersion() {
        return (SmartyFramework.Version)((Object)this.smartyVersionComboBox.getSelectedItem());
    }

    private void setToggleCommentOption(SmartyFramework.ToggleCommentOption toggleCommentOption) {
        if (toggleCommentOption == SmartyFramework.ToggleCommentOption.SMARTY) {
            this.asSmartyRadioButton.setSelected(true);
        } else {
            this.perContextRadioButton.setSelected(true);
        }
    }

    private SmartyFramework.ToggleCommentOption getToggleCommentOption() {
        if (this.asSmartyRadioButton.isSelected()) {
            return SmartyFramework.ToggleCommentOption.SMARTY;
        }
        return SmartyFramework.ToggleCommentOption.CONTEXT;
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(Color.ORANGE);
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    protected void update() {
        this.setSmartyVersion(this.getOptions().getSmartyVersion());
        this.setOpenDelimiter(this.getOptions().getDefaultOpenDelimiter());
        this.setCloseDelimiter(this.getOptions().getDefaultCloseDelimiter());
        this.setDepthOfScanning(this.getOptions().getScanningDepth());
        this.setToggleCommentOption(this.getOptions().getToggleCommentOption());
    }

    protected void applyChanges() {
        this.getOptions().setSmartyVersion(this.getSmartyVersion());
        this.getOptions().setDefaultOpenDelimiter(this.getOpenDelimiter());
        this.getOptions().setDefaultCloseDelimiter(this.getCloseDelimiter());
        this.getOptions().setScanningDepth(this.getDepthOfScanning());
        this.getOptions().setToggleCommentOption(this.getToggleCommentOption());
    }

    protected boolean valid() {
        if (this.getOpenDelimiter().equals("") || this.getCloseDelimiter().equals("")) {
            this.setError(NbBundle.getMessage(SmartyOptionsPanel.class, (String)"WRN_EmptyDelimiterFields"));
            return false;
        }
        if (this.getDepthOfScanning() > 1) {
            this.setWarning(NbBundle.getMessage(SmartyOptionsPanel.class, (String)"WRN_TooDeepScanningLevel"));
            return true;
        }
        this.setWarning(" ");
        return true;
    }

    private SmartyOptions getOptions() {
        return SmartyOptions.getInstance();
    }

    private void initComponents() {
        this.toggleCommentButtonGroup = new ButtonGroup();
        this.errorLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.installationInfoLabel = new JLabel();
        this.editorSettingsLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.smartyVersionLabel = new JLabel();
        this.smartyVersionComboBox = new JComboBox();
        this.openDelimiterLabel = new JLabel();
        this.openDelimiterTextField = new JTextField();
        this.closeDelimiterLabel = new JLabel();
        this.closeDelimiterTextField = new JTextField();
        this.toggleCommentLable = new JLabel();
        this.asSmartyRadioButton = new JRadioButton();
        this.perContextRadioButton = new JRadioButton();
        this.projectSettingsLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.depthOfScanningLabel = new JLabel();
        this.depthOfScanningComboBox = new JComboBox();
        this.depthOfScanningNoteLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.errorLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SmartyOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SmartyOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.installationInfoLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.installationInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.editorSettingsLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"LBL_OptionsEditorPanel"));
        this.smartyVersionLabel.setDisplayedMnemonic('v');
        this.smartyVersionLabel.setLabelFor(this.smartyVersionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.smartyVersionLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.smartyVersionLabel.text"));
        this.openDelimiterLabel.setDisplayedMnemonic('O');
        this.openDelimiterLabel.setLabelFor(this.openDelimiterTextField);
        Mnemonics.setLocalizedText((JLabel)this.openDelimiterLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.openDelimiterLabel.text"));
        this.openDelimiterTextField.setPreferredSize(new Dimension(4, 24));
        this.closeDelimiterLabel.setDisplayedMnemonic('C');
        this.closeDelimiterLabel.setLabelFor(this.closeDelimiterTextField);
        Mnemonics.setLocalizedText((JLabel)this.closeDelimiterLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.closeDelimiterLabel.text"));
        this.closeDelimiterTextField.setMinimumSize(new Dimension(4, 24));
        this.closeDelimiterTextField.setPreferredSize(new Dimension(4, 24));
        Mnemonics.setLocalizedText((JLabel)this.toggleCommentLable, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.toggleCommentLable.text"));
        this.toggleCommentButtonGroup.add(this.asSmartyRadioButton);
        this.asSmartyRadioButton.setMnemonic('a');
        this.asSmartyRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.asSmartyRadioButton, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.asSmartyRadioButton.text"));
        this.toggleCommentButtonGroup.add(this.perContextRadioButton);
        this.perContextRadioButton.setMnemonic('l');
        Mnemonics.setLocalizedText((AbstractButton)this.perContextRadioButton, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.perContextRadioButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.projectSettingsLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"LBL_OptionsProjectPanel"));
        this.depthOfScanningLabel.setDisplayedMnemonic('S');
        this.depthOfScanningLabel.setLabelFor(this.depthOfScanningComboBox);
        Mnemonics.setLocalizedText((JLabel)this.depthOfScanningLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.depthOfScanningLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.depthOfScanningNoteLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.depthOfScanningNoteLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.editorSettingsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1)).addGroup(layout.createSequentialGroup().addComponent(this.projectSettingsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addComponent(this.learnMoreLabel, -2, -1, -2).addComponent(this.installationInfoLabel).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.openDelimiterLabel).addComponent(this.smartyVersionLabel).addComponent(this.toggleCommentLable)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.smartyVersionComboBox, -2, 393, -2).addGroup(layout.createSequentialGroup().addComponent(this.openDelimiterTextField, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeDelimiterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeDelimiterTextField, -2, 50, -2)))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.asSmartyRadioButton).addGap(18, 18, 18).addComponent(this.perContextRadioButton, -2, 178, -2)))).addGroup(layout.createSequentialGroup().addComponent(this.depthOfScanningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.depthOfScanningComboBox, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.depthOfScanningNoteLabel))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.editorSettingsLabel).addComponent(this.jSeparator1, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.smartyVersionLabel).addComponent(this.smartyVersionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openDelimiterLabel).addComponent(this.openDelimiterTextField, -2, 24, -2).addComponent(this.closeDelimiterLabel).addComponent(this.closeDelimiterTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.toggleCommentLable).addComponent(this.asSmartyRadioButton).addComponent(this.perContextRadioButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.projectSettingsLabel).addComponent(this.jSeparator2, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.depthOfScanningLabel, -2, 24, -2).addComponent(this.depthOfScanningComboBox, -2, -1, -2).addComponent(this.depthOfScanningNoteLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 180, Short.MAX_VALUE).addComponent(this.installationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel)));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://www.smarty.net/manual/en/installing.smarty.basic.php");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initSmartyVersionsComboBox() {
        for (SmartyFramework.Version version : SmartyFramework.Version.values()) {
            this.smartyVersionComboBox.addItem(version);
        }
    }

    private final class SmartyActionListener
    implements ActionListener {
        private SmartyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SmartyOptionsPanel.this.fireChange();
        }
    }

    private final class SmartyDocumentListener
    implements DocumentListener {
        private SmartyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            SmartyOptionsPanel.this.fireChange();
        }
    }
}

