/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.ui.options;

import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.smarty.SmartyFramework;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public final class SmartyOptions {
    protected static final String PREFERENCES_PATH = "smarty";
    private static final SmartyOptions INSTANCE = new SmartyOptions();
    public static final int DEFAULT_TPL_SCANNING_DEPTH = 1;
    private static final String OPEN_DELIMITER = "{";
    private static final String CLOSE_DELIMITER = "}";
    protected static final String PROP_TPL_SCANNING_DEPTH = "tpl-scanning-depth";
    protected static final String PROP_TPL_VERSION = "tpl-version";
    protected static final String PROP_TPL_TOGGLE_COMMENT = "tpl-toggle-comment";
    protected static final String PROP_TPL_SCANNING_DEPTH_OLD = "1";
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private SmartyOptions() {
        SmartyOptions.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                SmartyOptions.this.changeSupport.fireChange();
            }
        });
    }

    public static SmartyOptions getInstance() {
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getDefaultOpenDelimiter() {
        return SmartyOptions.getPreferences().get(OPEN_DELIMITER, OPEN_DELIMITER);
    }

    public void setDefaultOpenDelimiter(String delimiter) {
        SmartyOptions.getPreferences().put(OPEN_DELIMITER, delimiter);
        SmartyFramework.setDelimiterDefaultOpen(delimiter);
    }

    public String getDefaultCloseDelimiter() {
        return SmartyOptions.getPreferences().get(CLOSE_DELIMITER, CLOSE_DELIMITER);
    }

    public void setDefaultCloseDelimiter(String delimiter) {
        SmartyOptions.getPreferences().put(CLOSE_DELIMITER, delimiter);
        SmartyFramework.setDelimiterDefaultClose(delimiter);
    }

    public SmartyFramework.Version getSmartyVersion() {
        String version = SmartyOptions.getPreferences().get(PROP_TPL_VERSION, "SMARTY3");
        return SmartyFramework.Version.valueOf(version);
    }

    public void setSmartyVersion(SmartyFramework.Version version) {
        SmartyOptions.getPreferences().put(PROP_TPL_VERSION, version.name());
        SmartyFramework.setSmartyVersion(version);
    }

    public SmartyFramework.ToggleCommentOption getToggleCommentOption() {
        String commentOption = SmartyOptions.getPreferences().get(PROP_TPL_TOGGLE_COMMENT, SmartyFramework.ToggleCommentOption.SMARTY.name());
        return SmartyFramework.ToggleCommentOption.valueOf(commentOption);
    }

    public void setToggleCommentOption(SmartyFramework.ToggleCommentOption commentOption) {
        SmartyOptions.getPreferences().put(PROP_TPL_TOGGLE_COMMENT, commentOption.name());
        SmartyFramework.setToggleCommentOption(commentOption);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(SmartyOptions.class).node(PREFERENCES_PATH);
    }

    public static void updateSmartyScanningDepthProperty() {
        Preferences preferences = SmartyOptions.getPreferences();
        int originalValue = preferences.getInt(PROP_TPL_SCANNING_DEPTH_OLD, -1);
        if (originalValue != -1) {
            preferences.remove(PROP_TPL_SCANNING_DEPTH_OLD);
            preferences.putInt(PROP_TPL_SCANNING_DEPTH, originalValue);
        }
    }

    public int getScanningDepth() {
        SmartyOptions.updateSmartyScanningDepthProperty();
        return SmartyOptions.getPreferences().getInt(PROP_TPL_SCANNING_DEPTH, 1);
    }

    public void setScanningDepth(int depth) {
        SmartyOptions.getPreferences().putInt(PROP_TPL_SCANNING_DEPTH, depth);
        SmartyFramework.setDepthOfScanningForTpl(depth);
    }
}

