/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.utlis;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.php.smarty.editor.TplKit;
import org.netbeans.modules.php.smarty.editor.lexer.TplTokenId;
import org.netbeans.modules.php.smarty.editor.lexer.TplTopTokenId;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.text.CloneableEditor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class LexerUtils {
    private LexerUtils() {
    }

    public static final boolean isVariablePart(int character) {
        return Character.isJavaIdentifierPart(character);
    }

    public static final boolean isWS(int character) {
        return Character.isWhitespace(character);
    }

    public static final void relexerOpenedTpls() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                TopComponent[] topComponents;
                for (TopComponent topComponent : topComponents = WindowManager.getDefault().getOpenedTopComponents(WindowManager.getDefault().findMode("editor"))) {
                    if (!(topComponent instanceof CloneableEditor)) continue;
                    final Document doc = ((CloneableEditor)topComponent).getEditorPane().getDocument();
                    if (((CloneableEditor)topComponent).getEditorPane().getEditorKit() instanceof TplKit) {
                        ((TplKit)((Object)((CloneableEditor)topComponent).getEditorPane().getEditorKit())).initLexerColoringListener(doc);
                    }
                    NbEditorDocument nbdoc = (NbEditorDocument)doc;
                    nbdoc.runAtomic(new Runnable(){

                        @Override
                        public void run() {
                            MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                            if (mti != null) {
                                mti.tokenHierarchyControl().rebuild();
                            }
                        }
                    });
                }
            }
        });
    }

    public static TokenSequence<TplTopTokenId> getTplTopTokenSequence(Document doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        return LexerUtils.getTokenSequence(th, offset, TplTopTokenId.language());
    }

    public static TokenSequence<TplTopTokenId> getTplTopTokenSequence(Snapshot snapshot, int offset) {
        TokenHierarchy th = snapshot.getTokenHierarchy();
        return LexerUtils.getTokenSequence(th, offset, TplTopTokenId.language());
    }

    public static TokenSequence<TplTopTokenId> getTplTopTokenSequence(TokenHierarchy th, int offset) {
        return LexerUtils.getTokenSequence(th, offset, TplTopTokenId.language());
    }

    public static TokenSequence<TplTokenId> getTplTokenSequence(TokenHierarchy th, int offset) {
        return LexerUtils.getTokenSequence(th, offset, TplTokenId.language());
    }

    public static <K> TokenSequence<? extends K> getTokenSequence(TokenHierarchy th, int offset, Language<? extends K> language) {
        TokenSequence ts = th.tokenSequence(language);
        if (ts == null) {
            List list = th.embeddedTokenSequences(offset, true);
            for (TokenSequence t : list) {
                if (t.language() != language) continue;
                ts = t;
                break;
            }
            if (ts == null) {
                list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence t : list) {
                    if (t.language() != language) continue;
                    ts = t;
                    break;
                }
            }
        }
        return ts;
    }
}

