/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.php.smarty.editor.TplDataObject;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.windows.CloneableOpenSupport;

public final class TplEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie {
    private static final String DOCUMENT_SAVE_ENCODING = "Document_Save_Encoding";
    private static final String UTF_8_ENCODING = "UTF-8";
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            try {
                TplEditorSupport.this.saveDocument();
            }
            catch (UserCancelException userCancelException) {
                // empty catch block
            }
        }
    };

    TplEditorSupport(TplDataObject obj) {
        super((DataObject)obj, null, (CloneableEditorSupport.Env)new Environment(obj));
        this.setMIMEType(obj.getPrimaryFile().getMIMEType());
    }

    protected CloneableEditorSupport.Pane createPane() {
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)"text/x-tpl", (Serializable)this.getDataObject());
    }

    protected boolean asynchronousOpen() {
        return true;
    }

    public void saveDocument() throws IOException {
        this.updateEncoding();
        super.saveDocument();
    }

    void updateEncoding() throws UserCancelException {
        NotifyDescriptor.Confirmation nd;
        String documentContent = this.getDocumentText();
        String encoding = TplDataObject.findEncoding(documentContent);
        String feqEncoding = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile()).name();
        String finalEncoding = null;
        if (encoding != null) {
            if (!this.isSupportedEncoding(encoding) || !this.canEncode(documentContent, encoding)) {
                finalEncoding = this.canEncode(documentContent, feqEncoding) ? feqEncoding : UTF_8_ENCODING;
                nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TplEditorSupport.class, (String)"MSG_unsupportedEncodingSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding, finalEncoding, finalEncoding.equals(UTF_8_ENCODING) ? "" : " the original"}), 0, 2);
                nd.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                    throw new UserCancelException();
                }
            } else {
                finalEncoding = encoding;
            }
        } else if (!this.canEncode(documentContent, feqEncoding)) {
            nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TplEditorSupport.class, (String)"MSG_badCharConversionSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), feqEncoding}), 0, 2);
            nd.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                throw new UserCancelException();
            }
            finalEncoding = UTF_8_ENCODING;
        } else {
            finalEncoding = feqEncoding;
        }
        StyledDocument document = this.getDocument();
        if (document != null) {
            document.putProperty(DOCUMENT_SAVE_ENCODING, finalEncoding);
        }
    }

    private String getDocumentText() {
        String text = "";
        try {
            StyledDocument doc = this.getDocument();
            if (doc != null) {
                text = doc.getText(doc.getStartPosition().getOffset(), doc.getLength());
            }
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.WARNING, null, e);
        }
        return text;
    }

    private boolean canEncode(String docText, String encoding) {
        CharsetEncoder encoder = Charset.forName(encoding).newEncoder();
        return encoder.canEncode(docText);
    }

    private boolean isSupportedEncoding(String encoding) {
        boolean supported;
        try {
            supported = Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException e) {
            supported = false;
        }
        return supported;
    }

    public void open() {
        String encoding = ((TplDataObject)this.getDataObject()).getFileEncoding();
        String feqEncoding = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile()).name();
        if (encoding != null && !this.isSupportedEncoding(encoding)) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TplEditorSupport.class, (String)"MSG_unsupportedEncodingLoad", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding, feqEncoding}), 0, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        String foundEncoding = (String)doc.getProperty(DOCUMENT_SAVE_ENCODING);
        String usedEncoding = foundEncoding != null ? foundEncoding : UTF_8_ENCODING;
        Charset c = Charset.forName(usedEncoding);
        OutputStreamWriter w = new OutputStreamWriter(stream, c);
        try {
            kit.write(w, (Document)doc, 0, doc.getLength());
        }
        finally {
            ((Writer)w).close();
        }
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument doc = super.createStyledDocument(kit);
        Runnable postInitRunnable = (Runnable)doc.getProperty("postInitRunnable");
        if (postInitRunnable != null) {
            postInitRunnable.run();
        }
        return doc;
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        TplDataObject obj = (TplDataObject)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.getCookieSet0().add((Node.Cookie)this.saveCookie);
            obj.setModified(true);
        }
    }

    private void removeSaveCookie() {
        TplDataObject obj = (TplDataObject)this.getDataObject();
        Node.Cookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            obj.setModified(false);
        }
    }

    protected CloneableEditor createCloneableEditor() {
        return new TplEditor(this);
    }

    public static class TplEditor
    extends CloneableEditor {
        public TplEditor() {
        }

        public TplEditor(TplEditorSupport s) {
            super((CloneableEditorSupport)s);
            this.initialize();
        }

        private void initialize() {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initialize();
        }
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543158452715818L;

        public Environment(TplDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((TplDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(TplEditorSupport.class);
        }
    }
}

