/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.smarty.editor.lexer.TplTokenId;
import org.netbeans.modules.php.smarty.editor.lexer.TplTopTokenId;
import org.netbeans.modules.php.smarty.editor.parser.TplParserResult;
import org.netbeans.modules.php.smarty.editor.utlis.LexerUtils;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.openide.util.Exceptions;

public class TplBracesMatching
implements BracesMatcher,
BracesMatcherFactory {
    private MatcherContext context;
    private static boolean testMode = false;

    public TplBracesMatching() {
        this(null);
    }

    protected static void setTestMode(boolean testMode) {
        TplBracesMatching.testMode = testMode;
    }

    private TplBracesMatching(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        int searchOffset = this.context.getSearchOffset();
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            if (!testMode && MatcherContext.isTaskCanceled()) {
                int[] nArray = null;
                return nArray;
            }
            TokenSequence<TplTopTokenId> ts = LexerUtils.getTplTopTokenSequence(this.context.getDocument(), searchOffset);
            TokenHierarchy th = TokenHierarchy.get((Document)this.context.getDocument());
            if (ts != null && ts.language() == TplTopTokenId.language()) {
                int[] delims = this.findDelimsLength(ts);
                block10: while (searchOffset != this.context.getLimitOffset()) {
                    int diff = ts.move(searchOffset);
                    searchOffset += this.context.isSearchingBackward() ? -1 : 1;
                    if (diff == 0 && this.context.isSearchingBackward() ? !ts.movePrevious() : !ts.moveNext()) continue;
                    Token t = ts.token();
                    boolean afterComment = this.afterCommentTag((TokenHierarchy<Document>)th, ts, delims, searchOffset);
                    if (!this.tokenInTag(t) && !afterComment) continue;
                    do {
                        Token t2 = ts.token();
                        int t2offs = ts.offset();
                        if (!this.tokenInTag(t2) && !afterComment) {
                            int[] nArray = null;
                            return nArray;
                        }
                        if (t2.id() != TplTopTokenId.T_SMARTY_OPEN_DELIMITER) continue;
                        int tagNameEnd = -1;
                        while (ts.moveNext()) {
                            int[] nArray;
                            Token t3 = ts.token();
                            int t3offs = ts.offset();
                            int from = t2offs;
                            int to = t3offs + t3.length();
                            if (!this.tokenInTag(t3) || t3.id() == TplTopTokenId.T_SMARTY_OPEN_DELIMITER) {
                                nArray = null;
                                return nArray;
                            }
                            if (t3.id() == TplTopTokenId.T_SMARTY) {
                                TokenSequence<TplTokenId> tplTS = LexerUtils.getTplTokenSequence(th, t3offs);
                                if (tplTS == null) {
                                    int[] nArray2 = null;
                                    return nArray2;
                                }
                                if (tplTS.token().id() == TplTokenId.FUNCTION) {
                                    tagNameEnd = tplTS.token().offset(th) + tplTS.token().length();
                                }
                                continue;
                            }
                            if (t3.id() != TplTopTokenId.T_SMARTY_CLOSE_DELIMITER) continue;
                            if (tagNameEnd != -1) {
                                nArray = new int[]{from, to, from, tagNameEnd, to - t3.length(), to};
                                return nArray;
                            }
                            nArray = new int[]{from, to};
                            return nArray;
                        }
                        continue block10;
                    } while (ts.movePrevious());
                }
                int[] nArray = null;
                return nArray;
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private boolean tokenInTag(Token t) {
        return t.id() == TplTopTokenId.T_SMARTY || t.id() == TplTopTokenId.T_SMARTY_CLOSE_DELIMITER || t.id() == TplTopTokenId.T_SMARTY_OPEN_DELIMITER || t.id() == TplTopTokenId.T_LITERAL_DEL || t.id() == TplTopTokenId.T_PHP_DEL || t.id() == TplTopTokenId.T_COMMENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            if (!testMode && MatcherContext.isTaskCanceled()) {
                int[] nArray = null;
                return nArray;
            }
            final int searchOffset = this.context.getSearchOffset();
            final Source source = Source.create((Document)this.context.getDocument());
            if (source == null) {
                int[] nArray = null;
                return nArray;
            }
            TokenSequence<TplTopTokenId> ts = LexerUtils.getTplTopTokenSequence(this.context.getDocument(), searchOffset);
            int[] delims = new int[]{1, 1};
            if (ts != null && ts.language() == TplTopTokenId.language()) {
                delims = this.findDelimsLength(ts);
                ts.move(searchOffset);
                ts.moveNext();
                ts.movePrevious();
                if (ts.token().id() == TplTopTokenId.T_COMMENT || this.atCommentTag((TokenHierarchy<Document>)TokenHierarchy.get((Document)this.context.getDocument()), ts, delims, searchOffset)) {
                    int[] nArray = new int[]{searchOffset, searchOffset};
                    return nArray;
                }
            }
            final int[] delimiterLengths = delims;
            final int[][] ret = new int[1][];
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        if (!testMode && MatcherContext.isTaskCanceled() || !source.getMimeType().equals("text/x-tpl")) {
                            return;
                        }
                        if (resultIterator == null) {
                            ret[0] = new int[]{searchOffset, searchOffset};
                            return;
                        }
                        TplParserResult parserResult = (TplParserResult)resultIterator.getParserResult();
                        if (parserResult == null) {
                            return;
                        }
                        for (int searchOffsetLocal = searchOffset; searchOffsetLocal != TplBracesMatching.this.context.getLimitOffset(); searchOffsetLocal += TplBracesMatching.this.context.isSearchingBackward() ? -1 : 1) {
                            int searched = parserResult.getSnapshot().getEmbeddedOffset(searchOffsetLocal);
                            TplParserResult.Block block = TplBracesMatching.getBlockForOffset(parserResult, searched, TplBracesMatching.this.context.isSearchingBackward(), delimiterLengths);
                            if (block == null) {
                                return;
                            }
                            if (block.getSections().size() == 1) {
                                ret[0] = new int[]{searchOffset, searchOffset};
                                return;
                            }
                            LinkedList result = new LinkedList();
                            TplParserResult.Section lastSection = null;
                            for (TplParserResult.Section section : block.getSections()) {
                                OffsetRange or = section.getOffset();
                                if (!(or = new OffsetRange(or.getStart() - delimiterLengths[0], or.getEnd() + delimiterLengths[1])).containsInclusive(searchOffset)) {
                                    TplBracesMatching.insertMatchingSection(result, section, delimiterLengths);
                                    continue;
                                }
                                if (lastSection == null) {
                                    lastSection = section;
                                    continue;
                                }
                                if (section.getOffset().getStart() < lastSection.getOffset().getStart() && TplBracesMatching.this.context.isSearchingBackward() || section.getOffset().getStart() > lastSection.getOffset().getStart() && !TplBracesMatching.this.context.isSearchingBackward()) {
                                    TplBracesMatching.insertMatchingSection(result, lastSection, delimiterLengths);
                                    lastSection = section;
                                    continue;
                                }
                                TplBracesMatching.insertMatchingSection(result, section, delimiterLengths);
                            }
                            ret[0] = TplBracesMatching.convertToIntegers(result);
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            int[] nArray = ret[0];
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private static void insertMatchingSection(List<Integer> result, TplParserResult.Section section, int[] delimLengths) {
        OffsetRange offset = section.getOffset();
        result.add(offset.getStart() - delimLengths[0]);
        result.add(offset.getStart() + section.getFunctionNameLength());
        result.add(offset.getEnd());
        result.add(offset.getEnd() + delimLengths[1]);
    }

    private static int[] convertToIntegers(List<Integer> list) {
        int[] integers = new int[list.size()];
        Iterator<Integer> iterator = list.iterator();
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = iterator.next();
        }
        return integers;
    }

    private static TplParserResult.Block getBlockForOffset(TplParserResult parserResult, int offset, boolean backwardSearching, int[] delimLengths) {
        TplParserResult.Block lastBlock = null;
        int previousBlockOffset = -1;
        for (TplParserResult.Block block : parserResult.getBlocks()) {
            for (TplParserResult.Section section : block.getSections()) {
                OffsetRange or = section.getOffset();
                if (!(or = new OffsetRange(or.getStart() - delimLengths[0], or.getEnd() + delimLengths[1])).containsInclusive(offset)) continue;
                if (lastBlock != null) {
                    if (section.getOffset().getStart() < previousBlockOffset && backwardSearching || section.getOffset().getStart() > previousBlockOffset && !backwardSearching) {
                        return block;
                    }
                    return lastBlock;
                }
                lastBlock = block;
                previousBlockOffset = section.getOffset().getStart();
            }
        }
        return lastBlock;
    }

    public BracesMatcher createMatcher(final MatcherContext context) {
        final TplBracesMatching[] ret = new TplBracesMatching[]{null};
        context.getDocument().render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy hierarchy = TokenHierarchy.get((Document)context.getDocument());
                if (hierarchy.tokenSequence().language() == TplTopTokenId.language()) {
                    ret[0] = new TplBracesMatching(context);
                }
            }
        });
        return ret[0];
    }

    private int[] findDelimsLength(TokenSequence<TplTopTokenId> ts) {
        int[] delimLengths = new int[]{-1, -1};
        ts.moveStart();
        while (ts.moveNext()) {
            if (ts.token().id() == TplTopTokenId.T_SMARTY_OPEN_DELIMITER) {
                delimLengths[0] = ts.token().length();
            } else if (ts.token().id() == TplTopTokenId.T_SMARTY_CLOSE_DELIMITER) {
                delimLengths[1] = ts.token().length();
            }
            if (delimLengths[0] <= 0 || delimLengths[1] <= 0) continue;
            return delimLengths;
        }
        return new int[]{1, 1};
    }

    private boolean afterCommentTag(TokenHierarchy<Document> th, TokenSequence<TplTopTokenId> ts, int[] delimsLength, int searchOffset) {
        Token prevToken;
        if (ts.movePrevious() && (prevToken = ts.token()) != null) {
            ts.moveNext();
            return searchOffset - prevToken.offset(th) <= delimsLength[1] + 1;
        }
        return false;
    }

    private boolean beforeCommentTag(TokenHierarchy<Document> th, TokenSequence<TplTopTokenId> ts, int[] delimsLength, int searchOffset) {
        Token nextToken;
        if (ts.moveNext() && (nextToken = ts.token()) != null) {
            if (nextToken.id() == TplTopTokenId.T_COMMENT) {
                ts.movePrevious();
                return nextToken.offset(th) - searchOffset <= delimsLength[0];
            }
            if (nextToken.id() == TplTopTokenId.T_SMARTY_OPEN_DELIMITER) {
                if (ts.moveNext()) {
                    Token nextNextToken = ts.token();
                    ts.movePrevious();
                    if (nextNextToken != null && nextNextToken.id() == TplTopTokenId.T_COMMENT) {
                        ts.movePrevious();
                        return nextToken.offset(th) - searchOffset <= delimsLength[0];
                    }
                }
                ts.movePrevious();
            }
        }
        return false;
    }

    private boolean atCommentTag(TokenHierarchy<Document> get, TokenSequence<TplTopTokenId> ts, int[] delims, int searchOffset) {
        boolean end = ts.token().id() == TplTopTokenId.T_SMARTY_CLOSE_DELIMITER && this.afterCommentTag(get, ts, delims, searchOffset);
        boolean start = (ts.token().id() == TplTopTokenId.T_SMARTY_OPEN_DELIMITER || ts.token().id() == TplTopTokenId.T_HTML) && this.beforeCommentTag(get, ts, delims, searchOffset);
        return end || start;
    }
}

