/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.util;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class EarProjectUtil {
    private static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.j2ee.earproject");
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.j2ee.earproject");

    private EarProjectUtil() {
    }

    public static boolean isDDCompulsory(Project earProject) {
        assert (earProject != null);
        J2eeModuleProvider provider = (J2eeModuleProvider)earProject.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && provider.getConfigSupport().isDescriptorRequired()) {
            return true;
        }
        EarImplementation impl = (EarImplementation)earProject.getLookup().lookup(EarImplementation.class);
        if (impl != null) {
            return EarProjectUtil.isDDCompulsory(Profile.fromPropertiesString((String)impl.getJ2eePlatformVersion()));
        }
        return EarProjectUtil.isDDCompulsory(Profile.J2EE_14);
    }

    public static boolean isDDCompulsory(Profile j2eeVersion) {
        if (j2eeVersion == null) {
            return false;
        }
        return Profile.J2EE_13.equals(j2eeVersion) || Profile.J2EE_14.equals(j2eeVersion);
    }

    public static boolean isDDWritable(EarProject earProject) {
        return earProject.getAppModule().getDeploymentDescriptor() != null;
    }

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static void logUI(ResourceBundle bundle, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        Parameters.notNull((CharSequence)"bundle", (Object)bundle);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(UI_LOGGER.getName());
        logRecord.setResourceBundle(bundle);
        if (params != null) {
            logRecord.setParameters(params);
        }
        UI_LOGGER.log(logRecord);
    }

    public static void logUsage(Class srcClass, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        USG_LOGGER.log(logRecord);
    }

    public static boolean isJavaEEModule(Project project) {
        return project != null && project.getLookup().lookup(J2eeModuleProvider.class) != null && project.getLookup().lookup(J2eeApplicationProvider.class) == null;
    }
}

