/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.clientproject.api.AppClientProjectCreateData;
import org.netbeans.modules.j2ee.clientproject.api.AppClientProjectGenerator;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.common.project.ui.ProjectLocationWizardPanel;
import org.netbeans.modules.j2ee.common.project.ui.ProjectServerWizardPanel;
import org.netbeans.modules.j2ee.common.project.ui.UserProjectSettings;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.EarProjectGenerator;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerRun;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.ui.wizards.ImportBlueprintEarWizardIterator;
import org.netbeans.modules.j2ee.earproject.util.EarProjectUtil;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectCreateData;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectGenerator;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewEarProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    transient WizardDescriptor wiz;

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new ProjectLocationWizardPanel(J2eeModule.EAR, NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_NWP1_ProjectTitleName"), NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"TXT_NewProject"), NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_NPW1_DefaultProjectName")), new ProjectServerWizardPanel(J2eeModule.EAR, NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"NewEarProjectWizardIterator.secondStep"), NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"TXT_NewProject"), false, false, false, true, false, true)};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_NWP1_ProjectTitleName"), NbBundle.getMessage(ImportBlueprintEarWizardIterator.class, (String)"NewEarProjectWizardIterator.secondStep")};
    }

    public Set instantiate() throws IOException {
        assert (false) : "This method cannot be called if the class implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        handle.start(9);
        handle.progress(NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_NewEarProjectWizardIterator_WizardProgress_CreatingProject"), 1);
        File dirF = (File)this.wiz.getProperty("projdir");
        if (dirF != null) {
            dirF = FileUtil.normalizeFile((File)dirF);
        }
        String name = (String)this.wiz.getProperty("name");
        String serverInstanceID = (String)this.wiz.getProperty("serverInstanceID");
        Profile j2eeLevel = (Profile)this.wiz.getProperty("j2eeLevel");
        Boolean createWAR = (Boolean)this.wiz.getProperty("createWAR");
        String warName = null;
        if (createWAR.booleanValue()) {
            warName = (String)this.wiz.getProperty("warName");
        }
        Boolean createJAR = (Boolean)this.wiz.getProperty("createJAR");
        String ejbJarName = null;
        if (createJAR.booleanValue()) {
            ejbJarName = (String)this.wiz.getProperty("jarName");
        }
        Boolean createCAR = (Boolean)this.wiz.getProperty("createCAR");
        String carName = null;
        String mainClass = null;
        if (createCAR.booleanValue()) {
            carName = (String)this.wiz.getProperty("carName");
            mainClass = (String)this.wiz.getProperty("mainClass");
        }
        String platformName = (String)this.wiz.getProperty("setJavaPlatform");
        String sourceLevel = (String)this.wiz.getProperty("setSourceLevel");
        Boolean cdi = (Boolean)this.wiz.getProperty("cdi");
        UserProjectSettings.getDefault().setLastUsedServer(serverInstanceID);
        String librariesDefinition = SharabilityUtility.getLibraryLocation((String)((String)this.wiz.getProperty("sharedLibraries")));
        SharableLibrariesUtils.setLastProjectSharable((librariesDefinition != null ? 1 : 0) != 0);
        String serverLibraryName = (String)this.wiz.getProperty("serverLibrary");
        return NewEarProjectWizardIterator.testableInstantiate(dirF, name, j2eeLevel, serverInstanceID, warName, ejbJarName, carName, mainClass, platformName, sourceLevel, handle, librariesDefinition, serverLibraryName, cdi);
    }

    static Set<FileObject> testableInstantiate(File dirF, String name, Profile j2eeProfile, String serverInstanceID, String warName, String ejbJarName, String carName, String mainClass, String platformName, String sourceLevel, ProgressHandle handle, String librariesDefinition, String serverLibraryName, Boolean cdi) throws IOException {
        AppClientProjectCreateData createData;
        File libLocation;
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        AntProjectHelper h = EarProjectGenerator.createProject(dirF, name, j2eeProfile, serverInstanceID, sourceLevel, librariesDefinition, serverLibraryName);
        if (handle != null) {
            handle.progress(2);
        }
        FileObject dir = FileUtil.toFileObject((File)dirF);
        Project p = ProjectManager.getDefault().findProject(dir);
        EarProject earProject = (EarProject)p.getLookup().lookup(EarProject.class);
        if (null != earProject) {
            Application app = null;
            try {
                app = earProject.getAppModule().getApplication();
                app.setDisplayName(name);
                if (EarProjectUtil.isDDWritable(earProject)) {
                    app.write(earProject.getAppModule().getDeploymentDescriptor());
                }
            }
            catch (IOException ioe) {
                Logger.getLogger("global").log(Level.INFO, ioe.getLocalizedMessage());
            }
        }
        resultSet.add(dir);
        if (librariesDefinition != null && !(libLocation = new File(librariesDefinition)).isAbsolute()) {
            librariesDefinition = ".." + File.separatorChar + librariesDefinition;
        }
        AuxiliaryConfiguration aux = h.createAuxiliaryConfiguration();
        Project webProject = null;
        if (null != warName) {
            File webAppDir = FileUtil.normalizeFile((File)new File(dirF, warName));
            WebProjectCreateData createData2 = new WebProjectCreateData();
            createData2.setProjectDir(webAppDir);
            createData2.setName(warName);
            createData2.setServerInstanceID(serverInstanceID);
            createData2.setSourceStructure("BluePrints");
            createData2.setJavaEEProfile(EarProjectGenerator.getAcceptableProfile(j2eeProfile, serverInstanceID, J2eeModule.Type.WAR));
            createData2.setContextPath('/' + warName);
            createData2.setJavaPlatformName(platformName);
            createData2.setSourceLevel(sourceLevel);
            createData2.setLibrariesDefinition(librariesDefinition);
            createData2.setServerLibraryName(serverLibraryName);
            createData2.setCDIEnabled(cdi.booleanValue());
            if (handle != null) {
                handle.progress(NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_NewEarProjectWizardIterator_WizardProgress_WAR"), 3);
            }
            AntProjectHelper webHelper = WebProjectUtilities.createProject((WebProjectCreateData)createData2);
            if (handle != null) {
                handle.progress(4);
            }
            FileObject webAppDirFO = FileUtil.toFileObject((File)webAppDir);
            webProject = ProjectManager.getDefault().findProject(webAppDirFO);
            WebModule wm = WebModule.getWebModule((FileObject)webAppDirFO);
            WebProjectUtilities.ensureWelcomePage((FileObject)wm.getDocumentBase(), (FileObject)wm.getDeploymentDescriptor());
            EarProjectProperties.addJ2eeSubprojects(earProject, new Project[]{webProject});
            resultSet.add(webAppDirFO);
        }
        Project appClient = null;
        if (null != carName) {
            File carDir = FileUtil.normalizeFile((File)new File(dirF, carName));
            createData = new AppClientProjectCreateData();
            createData.setProjectDir(carDir);
            createData.setName(carName);
            createData.setMainClass(mainClass);
            createData.setJavaEEProfile(EarProjectGenerator.getAcceptableProfile(j2eeProfile, serverInstanceID, J2eeModule.Type.CAR));
            createData.setServerInstanceID(serverInstanceID);
            createData.setLibrariesDefinition(librariesDefinition);
            createData.setServerLibraryName(serverLibraryName);
            createData.setCDIEnabled(cdi.booleanValue());
            if (handle != null) {
                handle.progress(NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_NewEarProjectWizardIterator_WizardProgress_AppClient"), 5);
            }
            AntProjectHelper clientHelper = AppClientProjectGenerator.createProject((AppClientProjectCreateData)createData);
            if (handle != null) {
                handle.progress(6);
            }
            if (platformName != null || sourceLevel != null) {
                AppClientProjectGenerator.setPlatform((AntProjectHelper)clientHelper, (String)platformName, (String)sourceLevel);
            }
            FileObject carDirFO = FileUtil.toFileObject((File)carDir);
            appClient = ProjectManager.getDefault().findProject(carDirFO);
            EarProjectProperties.addJ2eeSubprojects(earProject, new Project[]{appClient});
            resultSet.add(carDirFO);
        }
        if (null != ejbJarName) {
            File ejbJarDir = FileUtil.normalizeFile((File)new File(dirF, ejbJarName));
            createData = new EjbJarProjectCreateData();
            createData.setProjectDir(ejbJarDir);
            createData.setName(ejbJarName);
            createData.setJavaEEProfile(EarProjectGenerator.getAcceptableProfile(j2eeProfile, serverInstanceID, J2eeModule.Type.EJB));
            createData.setServerInstanceID(serverInstanceID);
            createData.setLibrariesDefinition(librariesDefinition);
            createData.setServerLibraryName(serverLibraryName);
            createData.setCDIEnabled(cdi.booleanValue());
            if (handle != null) {
                handle.progress(NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_NewEarProjectWizardIterator_WizardProgress_EJB"), 7);
            }
            AntProjectHelper ejbHelper = EjbJarProjectGenerator.createProject((EjbJarProjectCreateData)createData);
            if (handle != null) {
                handle.progress(8);
            }
            if (platformName != null || sourceLevel != null) {
                EjbJarProjectGenerator.setPlatform((AntProjectHelper)ejbHelper, (String)platformName, (String)sourceLevel);
            }
            FileObject ejbJarDirFO = FileUtil.toFileObject((File)ejbJarDir);
            Project ejbJarProject = ProjectManager.getDefault().findProject(ejbJarDirFO);
            EarProjectProperties.addJ2eeSubprojects(earProject, new Project[]{ejbJarProject});
            resultSet.add(ejbJarDirFO);
            EarProjectGenerator.addEJBToClassPaths(ejbJarProject, appClient, webProject);
        }
        CustomizerRun.ApplicationUrisComboBoxModel.initializeProperties(earProject, warName, carName);
        NewEarProjectWizardIterator.setProjectChooserFolder(dirF);
        if (handle != null) {
            handle.progress(NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_NewEarProjectWizardIterator_WizardProgress_PreparingToOpen"), 9);
        }
        return resultSet;
    }

    static void setProjectChooserFolder(File dirF) {
        File parentF;
        File file = parentF = dirF != null ? dirF.getParentFile() : null;
        if (parentF != null && parentF.exists()) {
            ProjectChooser.setProjectsFolder((File)parentF);
        }
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
        }
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewEarProjectWizardIterator.class, (String)"LBL_WizardStepsCount"), this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    FileObject getIndexJSPFO(FileObject webRoot, String indexJSP) {
        return webRoot.getFileObject(indexJSP.replace('.', '/'), "jsp");
    }
}

