/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.clientproject.api.AppClientProjectCreateData;
import org.netbeans.modules.j2ee.clientproject.api.AppClientProjectGenerator;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.common.project.CompilationOnlyClassPathModifier;
import org.netbeans.modules.j2ee.common.project.ui.DeployOnSaveUtils;
import org.netbeans.modules.j2ee.common.project.ui.J2EEProjectProperties;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ModuleType;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.util.EarProjectUtil;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectCreateData;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectGenerator;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class EarProjectGenerator {
    private static final Logger LOGGER = Logger.getLogger(EarProjectGenerator.class.getName());
    private static final String DEFAULT_DOC_BASE_FOLDER = "src/conf";
    private static final String DEFAULT_BUILD_DIR = "build";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String SOURCE_ROOT_REF = "${source.root}";
    private final File prjDir;
    private final String name;
    private final Profile j2eeProfile;
    private final String serverInstanceID;
    private final String sourceLevel;
    private final FileObject prjDirFO;
    private String librariesDefinition;
    private String serverLibraryName;

    private EarProjectGenerator(File prjDir, FileObject prjDirFO, String name, Profile j2eeProfile, String serverInstanceID, String sourceLevel, String librariesDefinition, String serverLibraryName) {
        this.prjDir = prjDir;
        this.prjDirFO = prjDirFO;
        this.name = name;
        this.j2eeProfile = j2eeProfile;
        this.serverInstanceID = serverInstanceID;
        if (sourceLevel != null && sourceLevel.equals("1.7")) {
            sourceLevel = "1.6";
        }
        this.sourceLevel = sourceLevel;
        this.librariesDefinition = librariesDefinition;
        this.serverLibraryName = serverLibraryName;
    }

    public static AntProjectHelper createProject(File prjDir, String name, Profile j2eeProfile, String serverInstanceId, String sourceLevel, String librariesDefinition, String serverLibraryName) throws IOException {
        FileObject projectDir = FileUtil.createFolder((File)prjDir);
        final EarProjectGenerator earGen = new EarProjectGenerator(prjDir, projectDir, name, j2eeProfile, serverInstanceId, sourceLevel, librariesDefinition, serverLibraryName);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        FileSystem fs = projectDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper helper;
                h[0] = helper = earGen.doCreateProject();
            }
        });
        return h[0];
    }

    public static AntProjectHelper importProject(File pDir, final File sDir, String name, Profile j2eeProfile, String serverInstanceID, final String platformName, String sourceLevel, final Map<FileObject, ModuleType> userModules, String librariesDefinition, String serverLibraryName) throws IOException {
        FileObject projectDir = FileUtil.createFolder((File)pDir);
        final EarProjectGenerator earGen = new EarProjectGenerator(pDir, projectDir, name, j2eeProfile, serverInstanceID, sourceLevel, librariesDefinition, serverLibraryName);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        FileSystem fs = projectDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper helper;
                h[0] = helper = earGen.doImportProject(sDir, userModules, platformName);
            }
        });
        return h[0];
    }

    private AntProjectHelper doCreateProject() throws IOException {
        final AntProjectHelper h = this.setupProject();
        FileObject docBase = FileUtil.createFolder((FileObject)this.prjDirFO, (String)DEFAULT_DOC_BASE_FOLDER);
        FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-earproject/MANIFEST.MF"), (FileObject)docBase, (String)"MANIFEST");
        final EarProject p = (EarProject)ProjectManager.getDefault().findProject(h.getProjectDirectory());
        final ReferenceHelper refHelper = p.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties ep = h.getProperties("nbproject/project.properties");
                    ep.put("source.root", ".");
                    ep.setProperty("meta.inf", EarProjectGenerator.DEFAULT_DOC_BASE_FOLDER);
                    ep.setProperty("resource.dir", EarProjectGenerator.DEFAULT_RESOURCE_FOLDER);
                    h.putProperties("nbproject/project.properties", ep);
                    ProjectManager.getDefault().saveProject((Project)p);
                    EarProjectGenerator.copyRequiredLibraries(h, refHelper, EarProjectGenerator.this.serverInstanceID, EarProjectGenerator.this.serverLibraryName, EarProjectGenerator.this.j2eeProfile);
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex.getException());
        }
        EarProject earProject = (EarProject)p.getLookup().lookup(EarProject.class);
        assert (earProject != null);
        EarProjectGenerator.setupDD(this.j2eeProfile, docBase, earProject);
        return h;
    }

    private static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh, String serverInstanceId, String serverlibraryName, Profile j2eeProfile) throws IOException {
        if (!h.isSharableProject()) {
            return;
        }
        if (h.isSharableProject() && serverlibraryName != null && SharabilityUtility.findSharedServerLibrary((File)h.resolveFile(h.getLibrariesLocation()), (String)serverlibraryName) == null) {
            SharabilityUtility.createLibrary((File)h.resolveFile(h.getLibrariesLocation()), (String)serverlibraryName, (String)serverInstanceId);
        }
        if ((j2eeProfile.equals(Profile.JAVA_EE_6_FULL) || j2eeProfile.equals(Profile.JAVA_EE_6_WEB) || j2eeProfile.equals(Profile.JAVA_EE_7_FULL) || j2eeProfile.equals(Profile.JAVA_EE_7_WEB)) && rh.getProjectLibraryManager().getLibrary("javaee-endorsed-api-6.0") == null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("javaee-endorsed-api-6.0"));
        }
        SharabilityUtility.makeSureProjectHasCopyLibsLibrary((AntProjectHelper)h, (ReferenceHelper)rh);
    }

    private AntProjectHelper doImportProject(File srcPrjDir, Map<FileObject, ModuleType> userModules, String platformName) throws IOException {
        FileObject srcPrjDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)srcPrjDir));
        FileObject docBase = FileUtil.createFolder((FileObject)srcPrjDirFO, (String)DEFAULT_DOC_BASE_FOLDER);
        AntProjectHelper earHelper = this.setupProject();
        ReferenceHelper referenceHelper = new ReferenceHelper(earHelper, earHelper.createAuxiliaryConfiguration(), earHelper.getStandardPropertyEvaluator());
        String sourceRoot = referenceHelper.createForeignFileReference(srcPrjDir, null);
        String metaInf = this.createFileReference(referenceHelper, srcPrjDirFO, docBase);
        EditableProperties ep = earHelper.getProperties("nbproject/project.properties");
        ep.setProperty("source.root", sourceRoot);
        ep.setProperty("meta.inf", metaInf);
        earHelper.putProperties("nbproject/project.properties", ep);
        FileObject earDirFO = earHelper.getProjectDirectory();
        EarProject earProject = (EarProject)ProjectManager.getDefault().findProject(earDirFO).getLookup().lookup(EarProject.class);
        if (null != earProject) {
            Application app = null;
            try {
                FileObject appXml = earProject.getAppModule().getDeploymentDescriptor();
                FileObject fileBeingCopied = null;
                if (null != appXml) {
                    Enumeration filesToBackup = appXml.getParent().getChildren(false);
                    while (null != filesToBackup && filesToBackup.hasMoreElements()) {
                        fileBeingCopied = (FileObject)filesToBackup.nextElement();
                        if (!fileBeingCopied.isData() || !fileBeingCopied.canRead()) continue;
                        try {
                            FileUtil.copyFile((FileObject)fileBeingCopied, (FileObject)appXml.getParent(), (String)("original_" + fileBeingCopied.getName()), (String)fileBeingCopied.getExt());
                        }
                        catch (IOException ioe) {}
                    }
                    app = DDProvider.getDefault().getDDRoot(appXml);
                    Module[] m = app.getModule();
                    if (null != m && m.length > 0) {
                        earProject.getAppModule().getConfigSupport().ensureConfigurationReady();
                        for (int k = 0; k < m.length; ++k) {
                            app.removeModule(m[k]);
                        }
                        if (EarProjectUtil.isDDWritable(earProject)) {
                            app.write(earProject.getAppModule().getDeploymentDescriptor());
                        }
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(EarProjectGenerator.class, (String)"MESSAGE_CheckContextRoots"), 2));
                    }
                }
            }
            catch (IOException ioe) {
                Logger.getLogger("global").log(Level.INFO, ioe.getLocalizedMessage());
            }
            EarProjectGenerator.setupDD(this.j2eeProfile, docBase, earProject);
            if (userModules == null || userModules.isEmpty()) {
                userModules = ModuleType.detectModules(srcPrjDirFO);
            }
            this.addUserModules(earProject, userModules, platformName, earHelper, earProject);
            ProjectManager.getDefault().saveProject((Project)earProject);
            earProject.getAppModule().getConfigSupport().createInitialConfiguration();
            if (this.sourceLevel != null) {
                EarProjectGenerator.setPlatformSourceLevel(earHelper, this.sourceLevel);
            }
        }
        return earHelper;
    }

    private void addUserModules(EarProject p, Map<FileObject, ModuleType> userModules, String platformName, AntProjectHelper h, EarProject earProject) throws IOException {
        HashSet<Project> ejbs = new HashSet<Project>();
        HashSet<Project> webAndCars = new HashSet<Project>();
        block4: for (Map.Entry<FileObject, ModuleType> entry : userModules.entrySet()) {
            FileObject subprojectDir = entry.getKey();
            ModuleType type = entry.getValue();
            Project subProject = this.addModule(p, type, platformName, subprojectDir);
            assert (subProject != null) : "Directory " + subprojectDir + " does not contain valid project";
            switch (type) {
                case EJB: {
                    ejbs.add(subProject);
                    continue block4;
                }
                case WEB: 
                case CLIENT: {
                    webAndCars.add(subProject);
                    continue block4;
                }
            }
            assert (false) : "Unknown module type: " + (Object)((Object)type);
        }
        Project[] webAndCarsArray = webAndCars.toArray(new Project[webAndCars.size()]);
        for (Project ejb : ejbs) {
            EarProjectGenerator.addEJBToClassPaths(ejb, webAndCarsArray);
        }
    }

    public static void addEJBToClassPaths(Project ejbJarProject, Project ... projects) throws IOException {
        AntArtifact[] ejbArtifacts;
        assert (ejbJarProject != null);
        for (AntArtifact artifact : ejbArtifacts = AntArtifactQuery.findArtifactsByType((Project)ejbJarProject, (String)"jar")) {
            for (Project project : projects) {
                if (project == null) continue;
                CompilationOnlyClassPathModifier pcpe = (CompilationOnlyClassPathModifier)project.getLookup().lookup(CompilationOnlyClassPathModifier.class);
                URI[] locations = artifact.getArtifactLocations();
                if (pcpe == null || locations.length <= 0) continue;
                pcpe.addCompileAntArtifacts(new AntArtifact[]{artifact}, new URI[]{locations[0].normalize()});
            }
        }
    }

    private Project addModule(EarProject p, ModuleType type, String platformName, FileObject subprojectRoot) throws IllegalArgumentException, IOException {
        Project existingProject = this.getExistingJ2EEModuleProject(subprojectRoot);
        if (existingProject != null) {
            EarProjectProperties.addJ2eeSubprojects(p, new Project[]{existingProject});
            return existingProject;
        }
        FileObject javaRoot = this.getJavaRoot(subprojectRoot);
        File[] srcFolders = this.getSourceFolders(javaRoot);
        File subProjDir = FileUtil.normalizeFile((File)new File(this.prjDir, subprojectRoot.getNameExt()));
        AntProjectHelper subProjHelper = null;
        switch (type) {
            case WEB: {
                subProjHelper = this.addWebModule(subprojectRoot, srcFolders, subProjDir, platformName);
                break;
            }
            case EJB: {
                subProjHelper = this.addEJBModule(javaRoot, subprojectRoot, subProjDir, platformName);
                break;
            }
            case CLIENT: {
                subProjHelper = this.addAppClientModule(javaRoot, subprojectRoot, subProjDir, platformName);
                break;
            }
            default: {
                assert (false) : "Unknown module type: " + (Object)((Object)type);
                break;
            }
        }
        Project subProject = null;
        if (null != subProjHelper) {
            subProject = ProjectManager.getDefault().findProject(subProjHelper.getProjectDirectory());
            EarProjectProperties.addJ2eeSubprojects(p, new Project[]{subProject});
        }
        return subProject;
    }

    private Project getExistingJ2EEModuleProject(FileObject projectDirectory) throws IOException {
        Project project = ProjectManager.getDefault().findProject(projectDirectory);
        if (EarProjectUtil.isJavaEEModule(project)) {
            return project;
        }
        return null;
    }

    private AntProjectHelper addAppClientModule(FileObject javaRoot, FileObject subprojectRoot, File subProjDir, String platformName) throws IOException {
        FileObject docBaseFO = FileUtil.createFolder((FileObject)subprojectRoot, (String)DEFAULT_DOC_BASE_FOLDER);
        File docBase = FileUtil.toFile((FileObject)docBaseFO);
        AppClientProjectCreateData createData = new AppClientProjectCreateData();
        createData.setProjectDir(subProjDir);
        createData.setName(subprojectRoot.getName());
        createData.setSourceFolders(new File[]{FileUtil.toFile((FileObject)javaRoot)});
        createData.setTestFolders(new File[0]);
        createData.setConfFolder(docBase);
        createData.setJavaEEProfile(EarProjectGenerator.getAcceptableProfile(this.j2eeProfile, this.serverInstanceID, J2eeModule.Type.CAR));
        createData.setServerInstanceID(this.serverInstanceID);
        AntProjectHelper subProjHelper = AppClientProjectGenerator.importProject((AppClientProjectCreateData)createData);
        if (platformName != null || this.sourceLevel != null) {
            AppClientProjectGenerator.setPlatform((AntProjectHelper)subProjHelper, (String)platformName, (String)this.sourceLevel);
        }
        return subProjHelper;
    }

    private AntProjectHelper addEJBModule(FileObject javaRoot, FileObject subprojectRoot, File subProjDir, String platformName) throws IOException {
        FileObject docBaseFO = FileUtil.createFolder((FileObject)subprojectRoot, (String)DEFAULT_DOC_BASE_FOLDER);
        File docBase = FileUtil.toFile((FileObject)docBaseFO);
        EjbJarProjectCreateData createData = new EjbJarProjectCreateData();
        createData.setProjectDir(subProjDir);
        createData.setName(subprojectRoot.getName());
        createData.setSourceFolders(new File[]{FileUtil.toFile((FileObject)javaRoot)});
        createData.setTestFolders(new File[0]);
        createData.setConfigFilesBase(docBase);
        createData.setJavaEEProfile(EarProjectGenerator.getAcceptableProfile(this.j2eeProfile, this.serverInstanceID, J2eeModule.Type.EJB));
        createData.setServerInstanceID(this.serverInstanceID);
        AntProjectHelper subProjHelper = EjbJarProjectGenerator.importProject((EjbJarProjectCreateData)createData);
        if (platformName != null || this.sourceLevel != null) {
            EjbJarProjectGenerator.setPlatform((AntProjectHelper)subProjHelper, (String)platformName, (String)this.sourceLevel);
        }
        return subProjHelper;
    }

    private AntProjectHelper addWebModule(FileObject subprojectRoot, File[] srcFolders, File subProjDir, String platformName) throws IOException {
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(subProjDir);
        createData.setName(subprojectRoot.getName());
        createData.setWebModuleFO(subprojectRoot);
        createData.setSourceFolders(srcFolders);
        createData.setTestFolders(new File[0]);
        createData.setDocBase(FileUtil.createFolder((FileObject)subprojectRoot, (String)"web"));
        createData.setLibFolder(null);
        createData.setJavaEEProfile(EarProjectGenerator.getAcceptableProfile(this.j2eeProfile, this.serverInstanceID, J2eeModule.Type.WAR));
        createData.setServerInstanceID(this.serverInstanceID);
        createData.setBuildfile("build.xml");
        createData.setJavaPlatformName(platformName);
        createData.setSourceLevel(this.sourceLevel);
        createData.setWebInfFolder(subprojectRoot.getFileObject("web/WEB-INF"));
        return WebProjectUtilities.importProject((WebProjectCreateData)createData);
    }

    static FileObject setupDD(Profile j2eeProfile, FileObject docBase, EarProject earProject) throws IOException {
        return EarProjectGenerator.setupDD(j2eeProfile, docBase, (Project)earProject, false);
    }

    @Deprecated
    public static FileObject setupDD(String j2eeLevel, FileObject docBase, Project earProject, boolean force) throws IOException {
        return EarProjectGenerator.setupDD(Profile.fromPropertiesString((String)j2eeLevel), docBase, earProject, force);
    }

    public static FileObject setupDD(Profile j2eeProfile, FileObject docBase, Project earProject, boolean force) throws IOException {
        FileObject dd = docBase.getFileObject("application.xml");
        if (dd != null) {
            return dd;
        }
        boolean create = force || EarProjectUtil.isDDCompulsory(earProject);
        FileObject template = null;
        if (create) {
            if (Profile.J2EE_14.equals(j2eeProfile) || Profile.J2EE_13.equals(j2eeProfile)) {
                template = FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-earproject/ear-1.4.xml");
            } else if (Profile.JAVA_EE_5.equals(j2eeProfile)) {
                template = FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-earproject/ear-5.xml");
            } else if (Profile.JAVA_EE_6_FULL.equals(j2eeProfile) || Profile.JAVA_EE_6_WEB.equals(j2eeProfile) || Profile.JAVA_EE_7_FULL.equals(j2eeProfile) || Profile.JAVA_EE_7_WEB.equals(j2eeProfile)) {
                template = FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-earproject/ear-6.xml");
            } else assert (false) : "Unknown j2eeProfile: " + j2eeProfile;
        }
        if (template != null) {
            dd = FileUtil.copyFile(template, (FileObject)docBase, (String)"application");
            Application app = DDProvider.getDefault().getDDRoot(dd);
            app.setDisplayName(ProjectUtils.getInformation((Project)earProject).getDisplayName());
            EarProject defInst = (EarProject)earProject.getLookup().lookup(EarProject.class);
            if (defInst != null) {
                for (ClassPathSupport.Item vcpi : EarProjectProperties.getJarContentAdditional(defInst)) {
                    EarProjectProperties.addItemToAppDD(defInst, app, vcpi);
                }
            }
            app.write(dd);
        }
        return dd;
    }

    public static Profile getAcceptableProfile(Profile requestedProfile, String serverInstanceID, J2eeModule.Type moduleType) {
        J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
        Set profiles = platform.getSupportedProfiles(moduleType);
        if (!profiles.contains(requestedProfile) && profiles.contains(Profile.J2EE_14)) {
            return Profile.J2EE_14;
        }
        return requestedProfile;
    }

    private static String relativePath(FileObject parent, FileObject child) {
        if (child.equals(parent)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)parent, (FileObject)child)) {
            throw new IllegalArgumentException("Cannot find relative path, " + parent + " is not parent of " + child);
        }
        return child.getPath().substring(parent.getPath().length() + 1);
    }

    private AntProjectHelper setupProject() throws IOException {
        JavaPlatform defaultPlatform;
        SpecificationVersion v;
        EarProjectUtil.logUI(NbBundle.getBundle(EarProjectGenerator.class), "UI_EAR_PROJECT_CREATE_SHARABILITY", new Object[]{this.librariesDefinition != null, this.serverLibraryName != null});
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)this.prjDirFO, (String)"org.netbeans.modules.j2ee.earproject", (String)this.librariesDefinition);
        EarProject p = (EarProject)ProjectManager.getDefault().findProject(this.prjDirFO);
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "name");
        nameEl.appendChild(doc.createTextNode(this.name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "minimum-ant-version");
        minant.appendChild(doc.createTextNode("1.6.5"));
        data.appendChild(minant);
        Element wmLibs = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "web-module-libraries");
        data.appendChild(wmLibs);
        Element addLibs = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "web-module-additional-libraries");
        data.appendChild(addLibs);
        h.putPrimaryConfigurationData(data, true);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        ep.setProperty("dist.dir", "dist");
        ep.setProperty("dist.jar", "${dist.dir}/${jar.name}");
        ep.setProperty("j2ee.platform", this.j2eeProfile.toPropertiesString());
        ep.setProperty("jar.name", this.name + ".ear");
        ep.setProperty("jar.compress", "false");
        ep.setProperty("jar.content.additional", "");
        ep.setProperty("client.module.uri", "");
        ep.setProperty("client.urlPart", "");
        ep.setProperty("display.browser", "true");
        ep.setProperty("j2ee.compile.on.save", "true");
        ep.setProperty("j2ee.deploy.on.save", DeployOnSaveUtils.isDeployOnSaveSupported((String)this.serverInstanceID));
        String srcLevel = this.sourceLevel;
        if (srcLevel == null && (srcLevel = (v = (defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform()).getSpecification().getVersion()).toString()).equals("1.7")) {
            srcLevel = "1.6";
        }
        ep.setProperty("javac.source", srcLevel);
        ep.setProperty("javac.debug", "true");
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.target", srcLevel);
        ep.setProperty("build.dir", DEFAULT_BUILD_DIR);
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form,**/.nbattrs");
        ep.setProperty("no.dependencies", "false");
        ep.setProperty("platform.active", "default_platform");
        ep.setProperty("debug.classpath", "${javac.classpath}::${jar.content.additional}:${run.classpath}");
        if (this.j2eeProfile.equals(Profile.JAVA_EE_6_FULL) || this.j2eeProfile.equals(Profile.JAVA_EE_6_WEB) || this.j2eeProfile.equals(Profile.JAVA_EE_7_FULL) || this.j2eeProfile.equals(Profile.JAVA_EE_7_WEB)) {
            ep.setProperty("endorsed.classpath", new String[]{"${libs.javaee-endorsed-api-6.0.classpath}"});
        }
        EditableProperties privateEP = h.getProperties("nbproject/private/private.properties");
        J2EEProjectProperties.setServerProperties((EditableProperties)ep, (EditableProperties)privateEP, (String)this.serverLibraryName, null, null, (String)this.serverInstanceID, (Profile)this.j2eeProfile, (J2eeModule.Type)J2eeModule.Type.EAR);
        h.putProperties("nbproject/project.properties", ep);
        h.putProperties("nbproject/private/private.properties", privateEP);
        ProjectManager.getDefault().saveProject((Project)p);
        return h;
    }

    private String createFileReference(ReferenceHelper refHelper, FileObject sourceprojectFO, FileObject referencedFO) {
        if (FileUtil.isParentOf((FileObject)this.prjDirFO, (FileObject)referencedFO)) {
            return EarProjectGenerator.relativePath(this.prjDirFO, referencedFO);
        }
        if (FileUtil.isParentOf((FileObject)sourceprojectFO, (FileObject)referencedFO)) {
            String s = EarProjectGenerator.relativePath(sourceprojectFO, referencedFO);
            return s.length() > 0 ? "${source.root}/" + s : SOURCE_ROOT_REF;
        }
        return refHelper.createForeignFileReference(FileUtil.toFile((FileObject)referencedFO), null);
    }

    public static void setPlatformSourceLevel(final AntProjectHelper helper, final String sourceLevel) {
        FileObject projectDir = helper.getProjectDirectory();
        if (projectDir == null) {
            return;
        }
        try {
            projectDir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                EditableProperties ep = helper.getProperties("nbproject/project.properties");
                                String srcLevel = sourceLevel;
                                if (sourceLevel.equals("1.7")) {
                                    srcLevel = "1.6";
                                }
                                ep.setProperty("javac.source", srcLevel);
                                ep.setProperty("javac.target", srcLevel);
                                helper.putProperties("nbproject/project.properties", ep);
                                ProjectManager.getDefault().saveProject(ProjectManager.getDefault().findProject(helper.getProjectDirectory()));
                            }
                            catch (IOException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private FileObject getJavaRoot(FileObject moduleRoot) throws IOException {
        FileObject javaRoot = moduleRoot.getFileObject("src/java");
        if (null == javaRoot) {
            FileObject srcDir = moduleRoot.getFileObject("src");
            if (null == srcDir) {
                srcDir = moduleRoot.createFolder("src");
            }
            javaRoot = srcDir.createFolder("java");
        }
        return javaRoot;
    }

    private File[] getSourceFolders(FileObject javaRoot) {
        File[] fileArray;
        if (null == javaRoot) {
            fileArray = new File[]{};
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = FileUtil.toFile((FileObject)javaRoot);
        }
        return fileArray;
    }
}

