/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.terminal.action;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.terminal.api.IONotifier;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class TerminalSupportImpl {
    private static final RequestProcessor RP = new RequestProcessor("Terminal Action RP", 100);

    private TerminalSupportImpl() {
    }

    public static Component getToolbarPresenter(Action action) {
        JButton button = new JButton(action);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setText(null);
        button.putClientProperty("hideActionText", Boolean.TRUE);
        Object icon = action.getValue("SmallIcon");
        if (icon == null) {
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dlight/terminal/action/local_term.png", (boolean)false);
        }
        if (!(icon instanceof Icon)) {
            throw new IllegalStateException("No icon provided for " + action);
        }
        button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)((Icon)icon)));
        return button;
    }

    public static void openTerminalImpl(final IOContainer ioContainer, final String tabTitle, final ExecutionEnvironment env, final String dir, final boolean silentMode) {
        final IOProvider term = IOProvider.get((String)"Terminal");
        if (term != null) {
            final AtomicBoolean destroyed = new AtomicBoolean(false);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (SwingUtilities.isEventDispatchThread()) {
                        ioContainer.requestActive();
                    } else {
                        this.doWork();
                    }
                }

                private void doWork() {
                    HostInfo hostInfo;
                    if (!ConnectionManager.getInstance().isConnectedTo(env)) {
                        try {
                            ConnectionManager.getInstance().connectTo(env);
                        }
                        catch (IOException ex) {
                            if (!destroyed.get()) {
                                String error = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
                                String msg = NbBundle.getMessage(TerminalSupportImpl.class, (String)"TerminalAction.FailedToStart.text", (Object)error);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                            }
                            return;
                        }
                        catch (ConnectionManager.CancellationException ex) {
                            return;
                        }
                    }
                    try {
                        hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                        boolean isSupported = PtySupport.isSupportedFor((ExecutionEnvironment)env);
                        if (!isSupported) {
                            if (!silentMode) {
                                String message = hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS ? NbBundle.getMessage(TerminalSupportImpl.class, (String)"LocalTerminalNotSupported.error.nocygwin") : NbBundle.getMessage(TerminalSupportImpl.class, (String)"LocalTerminalNotSupported.error");
                                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 1);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                            }
                            return;
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return;
                    }
                    catch (ConnectionManager.CancellationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return;
                    }
                    final AtomicReference<InputOutput> ioRef = new AtomicReference<InputOutput>();
                    try {
                        ioRef.set(term.getIO(tabTitle, null, ioContainer));
                        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)env);
                        npb.addNativeProcessListener((ChangeListener)new NativeProcessListener((InputOutput)ioRef.get(), destroyed));
                        String shell = hostInfo.getLoginShell();
                        if (dir != null) {
                            npb.setWorkingDirectory(dir);
                        }
                        npb.setExecutable(shell);
                        NativeExecutionDescriptor descr = new NativeExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).inputOutput((InputOutput)ioRef.get());
                        descr.postExecution(new Runnable(){

                            @Override
                            public void run() {
                                ((InputOutput)ioRef.get()).closeInputOutput();
                            }
                        });
                        NativeExecutionService es = NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)"Terminal Emulator");
                        Future result = es.run();
                        SwingUtilities.invokeLater(this);
                        try {
                            result.get(1L, TimeUnit.SECONDS);
                        }
                        catch (TimeoutException ex) {
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (ExecutionException ex) {
                            if (!destroyed.get()) {
                                String error = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
                                String msg = NbBundle.getMessage(TerminalSupportImpl.class, (String)"TerminalAction.FailedToStart.text", (Object)error);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                            }
                        }
                    }
                    catch (CancellationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        this.reportInIO((InputOutput)ioRef.get(), ex);
                    }
                }

                private void reportInIO(InputOutput io, Exception ex) {
                    if (io != null && ex != null) {
                        io.getErr().print(ex.getLocalizedMessage());
                    }
                }
            };
            RP.post(runnable);
        }
    }

    private static final class NativeProcessListener
    implements ChangeListener,
    PropertyChangeListener {
        private final AtomicReference<NativeProcess> processRef;
        private final AtomicBoolean destroyed;

        public NativeProcessListener(InputOutput io, AtomicBoolean destroyed) {
            assert (destroyed != null);
            this.destroyed = destroyed;
            this.processRef = new AtomicReference();
            IONotifier.addPropertyChangeListener((InputOutput)io, (PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)io));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            NativeProcess process = this.processRef.get();
            if (process == null && e.getSource() instanceof NativeProcess) {
                this.processRef.compareAndSet(null, (NativeProcess)e.getSource());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NativeProcess proc;
            if ("IOVisibility.PROP_VISIBILITY".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue()) && this.destroyed.compareAndSet(false, true) && (proc = this.processRef.get()) != null) {
                RP.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            proc.destroy();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }
}

