/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import org.netbeans.modules.versioning.hooks.VCSHook;
import org.netbeans.modules.versioning.hooks.VCSHookContext;
import org.netbeans.modules.versioning.util.common.SectionButton;
import org.netbeans.modules.versioning.util.common.VCSCommitFilter;
import org.netbeans.modules.versioning.util.common.VCSCommitPanel;
import org.netbeans.modules.versioning.util.common.VCSCommitPanelModifier;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

abstract class CollapsiblePanel
extends JPanel {
    protected final SectionButton sectionButton;
    protected final JPanel sectionPanel;
    protected final VCSCommitPanel master;

    public CollapsiblePanel(VCSCommitPanel master, boolean defaultSectionDisplayed) {
        this.master = master;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CollapsiblePanel.this.sectionPanel.isVisible()) {
                    CollapsiblePanel.this.hideSection();
                } else {
                    CollapsiblePanel.this.displaySection();
                }
            }
        };
        this.sectionButton = new SectionButton(al);
        this.sectionPanel = new JPanel();
        this.sectionButton.setSelected(defaultSectionDisplayed);
        this.setLayout(new BoxLayout(this, 1));
        this.sectionButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.sectionButton.getMaximumSize().height));
        this.add(this.sectionButton);
        this.add(VCSCommitPanel.makeVerticalStrut(this.sectionButton, this.sectionPanel, LayoutStyle.ComponentPlacement.RELATED, master));
        this.add(this.sectionPanel);
        this.setAlignmentX(0.0f);
        this.sectionPanel.setLayout(new BoxLayout(this.sectionPanel, 1));
        this.sectionPanel.setAlignmentX(0.0f);
        this.sectionButton.setAlignmentX(0.0f);
        Icon i = this.sectionButton.getIcon();
        Border b = this.sectionButton.getBorder();
        int left = (b != null ? b.getBorderInsets((Component)this.sectionButton).left : 0) + (i != null ? i.getIconWidth() : 16) + this.sectionButton.getIconTextGap();
        int bottom = master.getContainerGap(5);
        this.sectionPanel.setBorder(BorderFactory.createEmptyBorder(0, left, bottom, 0));
        if (defaultSectionDisplayed) {
            this.displaySection();
        } else {
            this.hideSection();
        }
    }

    protected final void displaySection() {
        this.sectionPanel.setVisible(true);
        this.master.enlargeVerticallyAsNecessary();
    }

    protected final void hideSection() {
        this.sectionPanel.setVisible(false);
    }

    private static String getMessage(String msgKey) {
        return NbBundle.getMessage(VCSCommitPanel.class, (String)msgKey);
    }

    static class HookPanel
    extends CollapsiblePanel {
        private Collection<? extends VCSHook> hooks = Collections.emptyList();
        private VCSHookContext hookContext;
        private static final boolean DEFAULT_DISPLAY_HOOKS = false;

        public HookPanel(VCSCommitPanel master, Collection<? extends VCSHook> hooks, VCSHookContext hookContext) {
            super(master, false);
            this.hooks = hooks;
            this.hookContext = hookContext;
            Mnemonics.setLocalizedText((AbstractButton)this.sectionButton, (String)(hooks.size() == 1 ? hooks.iterator().next().getDisplayName() : CollapsiblePanel.getMessage("LBL_Advanced")));
            if (hooks.size() == 1) {
                JPanel p = hooks.iterator().next().createComponent(hookContext);
                if (Boolean.TRUE.equals(p.getClientProperty("prop.requestOpened"))) {
                    super.displaySection();
                }
                this.sectionPanel.add(p);
            } else {
                JTabbedPane hooksTabbedPane = new JTabbedPane();
                for (VCSHook vCSHook : hooks) {
                    hooksTabbedPane.add((Component)vCSHook.createComponent(hookContext), vCSHook.getDisplayName().replaceAll("\\&", ""));
                }
                this.sectionPanel.add(hooksTabbedPane);
            }
        }

        int getPreferedWidth() {
            return this.sectionPanel.getPreferredSize().width;
        }
    }

    static class FilesPanel
    extends CollapsiblePanel
    implements ActionListener {
        public static final String TOOLBAR_FILTER = "toolbar.filter";
        final JLabel filesLabel = new JLabel();
        private static final boolean DEFAULT_DISPLAY_FILES = true;
        private final JToolBar toolbar;
        private final Map<String, VCSCommitFilter> filters;

        public FilesPanel(VCSCommitPanel master, Map<String, VCSCommitFilter> filters, int preferedHeight) {
            super(master, true);
            this.filters = filters;
            Mnemonics.setLocalizedText((AbstractButton)this.sectionButton, (String)master.getModifier().getMessage(VCSCommitPanelModifier.BundleMessage.FILE_PANEL_TITLE));
            master.getCommitTable().labelFor(this.filesLabel);
            JComponent table = master.getCommitTable().getComponent();
            this.filesLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.filesLabel.getMaximumSize().height));
            Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)CollapsiblePanel.getMessage("CTL_CommitForm_FilesToCommit"));
            table.setPreferredSize(new Dimension(0, preferedHeight));
            ButtonGroup bg = new ButtonGroup();
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            for (VCSCommitFilter filter : filters.values()) {
                JToggleButton tgb = new JToggleButton();
                tgb.setIcon(filter.getIcon());
                tgb.setToolTipText(filter.getTooltip());
                tgb.setFocusable(false);
                tgb.setSelected(filter.isSelected());
                tgb.addActionListener(this);
                tgb.putClientProperty(TOOLBAR_FILTER, filter);
                bg.add(tgb);
                this.toolbar.add(tgb);
            }
            this.toolbar.setAlignmentX(0.0f);
            this.sectionPanel.add(this.toolbar);
            this.sectionPanel.add(table);
            this.sectionPanel.add(VCSCommitPanel.makeVerticalStrut(this.filesLabel, table, LayoutStyle.ComponentPlacement.RELATED, this.sectionPanel));
            this.sectionPanel.add(this.filesLabel);
            this.sectionPanel.setAlignmentX(0.0f);
            this.filesLabel.setAlignmentX(0.0f);
            table.setAlignmentX(0.0f);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object s = e.getSource();
            if (s instanceof JToggleButton) {
                JToggleButton tgb = (JToggleButton)s;
                Object o = tgb.getClientProperty(TOOLBAR_FILTER);
                assert (o != null);
                if (o != null) {
                    VCSCommitFilter f = (VCSCommitFilter)o;
                    boolean selected = tgb.isSelected();
                    if (selected != f.isSelected()) {
                        f.setSelected(selected);
                        String id = f.getID();
                        for (VCSCommitFilter filter : this.filters.values()) {
                            if (filter.getID().equals(id)) continue;
                            filter.setSelected(!selected);
                        }
                        this.master.computeNodes();
                    } else {
                        return;
                    }
                }
            }
        }
    }
}

