/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.versioning.spi.VCSHistoryProvider;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public abstract class HistoryAction
extends NodeAction {
    private Lookup context;
    private final String name;
    private final boolean multipleHistory;

    public HistoryAction() {
        this.name = null;
        this.multipleHistory = true;
    }

    public HistoryAction(String name) {
        this.name = name;
        this.multipleHistory = true;
    }

    public HistoryAction(String name, boolean multipleHistory) {
        this.name = name;
        this.multipleHistory = multipleHistory;
    }

    protected abstract void perform(VCSHistoryProvider.HistoryEntry var1, Set<File> var2);

    protected boolean isMultipleHistory() {
        return this.multipleHistory;
    }

    public String getName() {
        assert (this.name != null);
        return this.name;
    }

    protected String getRevisionShort() {
        Node node;
        Lookup ctx = this.getContext();
        if (ctx == null) {
            return null;
        }
        Collection nodes = ctx.lookupAll(Node.class);
        VCSHistoryProvider.HistoryEntry he = null;
        Iterator i$ = nodes.iterator();
        while (i$.hasNext() && (he = (VCSHistoryProvider.HistoryEntry)(node = (Node)i$.next()).getLookup().lookup(VCSHistoryProvider.HistoryEntry.class)) == null) {
        }
        assert (he != null);
        return he.getRevisionShort();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        this.context = actionContext;
        return super.createContextAwareInstance(actionContext);
    }

    protected Lookup getContext() {
        return this.context;
    }

    protected void performAction(Node[] activatedNodes) {
        HashMap m = new HashMap(activatedNodes.length);
        for (Node node : activatedNodes) {
            VCSHistoryProvider.HistoryEntry he = (VCSHistoryProvider.HistoryEntry)node.getLookup().lookup(VCSHistoryProvider.HistoryEntry.class);
            if (he == null) continue;
            Collection fos = node.getLookup().lookupAll(File.class);
            assert (fos != null);
            HashSet<File> files = (HashSet<File>)m.get(he);
            if (files == null) {
                files = new HashSet<File>();
                m.put(he, files);
            }
            for (File f : fos) {
                if (f == null) continue;
                files.add(f);
            }
        }
        for (Map.Entry e : m.entrySet()) {
            Set files = (Set)e.getValue();
            if (files == null || files.isEmpty()) continue;
            this.perform((VCSHistoryProvider.HistoryEntry)e.getKey(), (Set)e.getValue());
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return this.hasEntryAndFiles(activatedNodes);
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    private boolean hasEntryAndFiles(Node[] nodes) {
        boolean multipleHistory = this.isMultipleHistory();
        File file = null;
        VCSHistoryProvider.HistoryEntry historyEntry = null;
        for (Node node : nodes) {
            VCSHistoryProvider.HistoryEntry he = (VCSHistoryProvider.HistoryEntry)node.getLookup().lookup(VCSHistoryProvider.HistoryEntry.class);
            if (he == null) continue;
            if (historyEntry == null) {
                historyEntry = he;
            } else if (!(multipleHistory || he.getDateTime().equals(historyEntry.getDateTime()) && he.getRevision().equals(historyEntry.getRevision()))) {
                return false;
            }
            Collection fos = node.getLookup().lookupAll(File.class);
            if (fos == null) continue;
            for (File f : fos) {
                if (f == null) continue;
                file = f;
                break;
            }
            if (!multipleHistory || historyEntry == null || file == null) continue;
            return true;
        }
        return historyEntry != null && file != null;
    }
}

