/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.swing.text.Document;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class DiffUtils {
    private DiffUtils() {
    }

    public static String getHtmlDisplayName(Node node, boolean fileModified, boolean selected) {
        boolean colored;
        boolean bold = fileModified;
        boolean bl = colored = !selected;
        if (!bold && !colored) {
            return null;
        }
        String normal = colored ? node.getHtmlDisplayName() : node.getName();
        return bold ? DiffUtils.makeBold(normal) : normal;
    }

    private static String makeBold(String text) {
        return new StringBuilder(text.length() + 7).append("<b>").append(text).append("</b>").toString();
    }

    public static DataObject[] setupsToDataObjects(AbstractDiffSetup[] setups) {
        return DiffUtils.setupsToDataObjects(setups, false);
    }

    public static DataObject[] setupsToDataObjects(AbstractDiffSetup[] setups, boolean exactPositions) {
        if (setups == null) {
            throw new IllegalArgumentException("null");
        }
        DataObject[] dataObjects = new DataObject[setups.length];
        int count = 0;
        for (int i = 0; i < setups.length; ++i) {
            DataObject dataObj;
            AbstractDiffSetup setup = setups[i];
            if (setup == null || (dataObj = DiffUtils.getDataObject(setup)) == null) continue;
            int resultIndex = exactPositions ? i : count++;
            dataObjects[resultIndex] = dataObj;
        }
        return exactPositions ? dataObjects : CollectionUtils.shortenArray(dataObjects, count);
    }

    public static DataObject getDataObject(AbstractDiffSetup setup) {
        return DiffUtils.getDataObject(setup.getSecondSource());
    }

    public static DataObject getDataObject(StreamSource source) {
        Object o;
        Document streamDoc;
        if (!source.isEditable()) {
            return null;
        }
        Lookup lookup = source.getLookup();
        FileObject fileObj = (FileObject)lookup.lookup(FileObject.class);
        if (fileObj != null) {
            try {
                return DataObject.find((FileObject)fileObj);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((streamDoc = (Document)lookup.lookup(Document.class)) != null && (o = streamDoc.getProperty("stream")) instanceof DataObject) {
            return (DataObject)o;
        }
        return null;
    }

    public static EditorCookie[] setupsToEditorCookies(AbstractDiffSetup[] setups) {
        if (setups == null) {
            throw new IllegalArgumentException("null");
        }
        EditorCookie[] editorCookies = new EditorCookie[setups.length];
        for (int i = 0; i < setups.length; ++i) {
            editorCookies[i] = DiffUtils.getEditorCookie(setups[i]);
        }
        return editorCookies;
    }

    public static EditorCookie getEditorCookie(AbstractDiffSetup setup) {
        return DiffUtils.getEditorCookie(setup.getSecondSource());
    }

    public static EditorCookie getEditorCookie(StreamSource source) {
        Document streamDoc;
        if (!source.isEditable()) {
            return null;
        }
        Lookup lookup = source.getLookup();
        EditorCookie plain = null;
        FileObject fileObj = (FileObject)lookup.lookup(FileObject.class);
        if (fileObj != null) {
            try {
                EditorCookie editorCookie = DiffUtils.getEditorCookie(DataObject.find((FileObject)fileObj), true);
                if (editorCookie instanceof EditorCookie.Observable) {
                    return (EditorCookie.Observable)editorCookie;
                }
                plain = editorCookie;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((streamDoc = (Document)lookup.lookup(Document.class)) != null) {
            return DiffUtils.chooseBetterEditorCookie(DiffUtils.getEditorCookie(streamDoc), plain);
        }
        return plain;
    }

    private static EditorCookie getEditorCookie(DataObject dataObj, boolean tryDocument) {
        if (dataObj == null) {
            return null;
        }
        EditorCookie plain = null;
        EditorCookie editorCookie = (EditorCookie)dataObj.getCookie(EditorCookie.class);
        if (editorCookie instanceof EditorCookie.Observable) {
            return (EditorCookie.Observable)editorCookie;
        }
        plain = editorCookie;
        if (tryDocument && editorCookie != null) {
            try {
                return DiffUtils.chooseBetterEditorCookie(DiffUtils.getEditorCookie(editorCookie.openDocument()), plain);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return plain;
    }

    public static EditorCookie getEditorCookie(Document doc) {
        if (doc == null) {
            return null;
        }
        DataObject dataObj = (DataObject)doc.getProperty("stream");
        if (dataObj == null) {
            return null;
        }
        EditorCookie plain = null;
        if (dataObj instanceof MultiDataObject) {
            MultiDataObject multiDataObj = (MultiDataObject)dataObj;
            for (MultiDataObject.Entry entry : multiDataObj.secondaryEntries()) {
                CookieSet.Factory factory;
                EditorCookie ec;
                if (!(entry instanceof CookieSet.Factory) || (ec = (EditorCookie)(factory = (CookieSet.Factory)entry).createCookie(EditorCookie.class)).getDocument() != doc) continue;
                if (ec instanceof EditorCookie.Observable) {
                    return (EditorCookie.Observable)ec;
                }
                if (plain != null) continue;
                plain = ec;
            }
        }
        return DiffUtils.chooseBetterEditorCookie(DiffUtils.getEditorCookie(dataObj, false), plain);
    }

    private static EditorCookie chooseBetterEditorCookie(EditorCookie unchecked, EditorCookie firstPlain) {
        assert (!(firstPlain instanceof EditorCookie.Observable));
        Object result = unchecked instanceof EditorCookie.Observable ? (EditorCookie.Observable)unchecked : (firstPlain != null ? firstPlain : unchecked);
        return result;
    }

    public static void cleanThoseUnmodified(EditorCookie[] editorCookies) {
        for (int i = 0; i < editorCookies.length; ++i) {
            EditorCookie editorCookie = editorCookies[i];
            if (editorCookie == null || editorCookie.isModified()) continue;
            editorCookies[i] = null;
        }
    }

    public static void cleanThoseWithEditorPaneOpen(EditorCookie[] editorCookies) {
        for (int i = 0; i < editorCookies.length; ++i) {
            EditorCookie editorCookie = editorCookies[i];
            if (editorCookie == null || editorCookie.getOpenedPanes() == null) continue;
            editorCookies[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMatchingLine(File currentFile, File previousFile, int originalLineNumber) throws IOException {
        Difference[] differences;
        DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diffProvider == null) {
            return -1;
        }
        Reader r1 = null;
        Reader r2 = null;
        try {
            r1 = Utils.createReader(currentFile);
            r2 = Utils.createReader(previousFile);
            differences = diffProvider.computeDiff(r1, r2);
        }
        finally {
            if (r1 != null) {
                try {
                    r1.close();
                }
                catch (IOException ex) {}
            }
            if (r2 != null) {
                try {
                    r2.close();
                }
                catch (IOException ex) {}
            }
        }
        return DiffUtils.getMatchingLine(differences, originalLineNumber);
    }

    private static int getMatchingLine(Difference[] differences, int originalLineNumber) {
        int line = ++originalLineNumber;
        for (Difference diff : differences) {
            boolean end = false;
            switch (diff.getType()) {
                case 1: {
                    if (diff.getFirstStart() >= originalLineNumber) {
                        end = true;
                        break;
                    }
                    line += diff.getSecondEnd() - diff.getSecondStart() + 1;
                    break;
                }
                case 0: {
                    if (diff.getFirstStart() <= originalLineNumber && diff.getFirstEnd() >= originalLineNumber) {
                        line = diff.getSecondStart();
                        end = true;
                        break;
                    }
                    if (diff.getFirstEnd() >= originalLineNumber) {
                        end = true;
                        break;
                    }
                    line -= diff.getFirstEnd() - diff.getFirstStart() + 1;
                    break;
                }
                case 2: {
                    if (diff.getFirstStart() <= originalLineNumber && diff.getFirstEnd() >= originalLineNumber) {
                        line = diff.getSecondStart();
                        end = true;
                        break;
                    }
                    if (diff.getFirstEnd() >= originalLineNumber) {
                        end = true;
                        break;
                    }
                    line -= diff.getFirstEnd() - diff.getFirstStart();
                    line += diff.getSecondEnd() - diff.getSecondStart();
                }
            }
            if (end) break;
        }
        return line - 1;
    }
}

