/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.loader;

import java.io.IOException;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.netbeans.modules.websvc.design.javamodel.Utils;
import org.netbeans.modules.websvc.design.multiview.MultiViewSupport;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.windows.CloneableOpenSupport;

public final class JaxWsDataObject
extends MultiDataObject {
    private static final long serialVersionUID = -2635172073868722799L;
    public static final String CLASS_GIF = "org/netbeans/modules/websvc/design/resources/class.gif";
    private transient JaxWsJavaEditorSupport jes;
    private transient MultiViewSupport mvc;
    private transient ProjectService service;

    public JaxWsDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                JaxWsDataObject.this.createEditorSupport().saveAs(folder, fileName);
            }
        }});
        this.getCookieSet().add(JaxWsJavaEditorSupport.class, new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> klass) {
                return (T)((Node.Cookie)klass.cast((Object)JaxWsDataObject.this.createEditorSupport()));
            }
        });
        this.getCookieSet().add(MultiViewSupport.class, new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> klass) {
                MultiViewSupport cake = JaxWsDataObject.this.createMultiViewCookie();
                if (cake != null) {
                    return (T)((Node.Cookie)klass.cast(cake));
                }
                return null;
            }
        });
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    private void lazyInitialize() {
        if (this.service == null) {
            this.service = Utils.getProjectService((DataObject)this);
        }
    }

    public Node createNodeDelegate() {
        this.lazyInitialize();
        return new JaxWsDataNode((DataObject)this);
    }

    protected void handleDelete() throws IOException {
        super.handleDelete();
        if (this.service != null) {
            this.service.cleanup();
        }
    }

    protected DataObject handleCopyRename(DataFolder df, String name, String ext) throws IOException {
        FileObject fo = this.getPrimaryEntry().copyRename(df.getPrimaryFile(), name, ext);
        DataObject dob = DataObject.find((FileObject)fo);
        return dob;
    }

    public boolean isRenameAllowed() {
        return false;
    }

    private synchronized JaxWsJavaEditorSupport createEditorSupport() {
        if (this.jes == null) {
            this.jes = new JaxWsJavaEditorSupport(this);
        }
        return this.jes;
    }

    private synchronized MultiViewSupport createMultiViewCookie() {
        this.lazyInitialize();
        if (this.mvc == null) {
            this.createEditorSupport();
            if (this.getPrimaryFile().getAttribute("jax-ws-service-provider") == null) {
                this.mvc = new MultiViewSupport(this.service, (DataObject)this);
            }
        }
        return this.mvc;
    }

    public static final class JaxWsJavaEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditCookie,
    EditorCookie,
    PrintCookie,
    EditorCookie.Observable {
        public JaxWsJavaEditorSupport(JaxWsDataObject dataObject) {
            super((DataObject)dataObject, (CloneableEditorSupport.Env)new Environment(dataObject));
            this.setMIMEType("text/x-java");
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            ((Environment)this.env).addSaveCookie();
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            ((Environment)this.env).removeSaveCookie();
        }

        protected CloneableEditorSupport.Pane createPane() {
            MultiViewSupport mvs = (MultiViewSupport)((JaxWsDataObject)this.getDataObject()).getCookie(MultiViewSupport.class);
            if (mvs == null) {
                return super.createPane();
            }
            return (CloneableEditorSupport.Pane)mvs.createMultiView();
        }

        public boolean close(boolean ask) {
            return super.close(ask);
        }

        protected boolean asynchronousOpen() {
            return true;
        }

        private static final class Environment
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = -1L;
            private transient SaveSupport saveCookie = null;

            public Environment(JaxWsDataObject obj) {
                super((DataObject)obj);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableEditorSupport)((JaxWsDataObject)this.getDataObject()).getCookie(EditorCookie.class);
            }

            public void addSaveCookie() {
                JaxWsDataObject javaData = (JaxWsDataObject)this.getDataObject();
                if (javaData.getCookie(SaveCookie.class) == null) {
                    if (this.saveCookie == null) {
                        this.saveCookie = new SaveSupport();
                    }
                    javaData.getCookieSet().add((Node.Cookie)this.saveCookie);
                    javaData.setModified(true);
                }
            }

            public void removeSaveCookie() {
                JaxWsDataObject javaData = (JaxWsDataObject)this.getDataObject();
                if (javaData.getCookie(SaveCookie.class) != null) {
                    javaData.getCookieSet().remove((Node.Cookie)this.saveCookie);
                    javaData.setModified(false);
                }
            }

            private final class SaveSupport
            implements SaveCookie {
                private SaveSupport() {
                }

                public void save() throws IOException {
                    ((JaxWsJavaEditorSupport)Environment.this.findCloneableOpenSupport()).saveDocument();
                    Environment.this.getDataObject().setModified(false);
                }
            }
        }
    }

    static class JaxWsDataNode
    extends DataNode {
        public JaxWsDataNode(DataObject dobj) {
            super(dobj, Children.LEAF);
            this.setIconBaseWithExtension(JaxWsDataObject.CLASS_GIF);
        }

        public <T extends Node.Cookie> T getCookie(Class<T> type) {
            if (type.isAssignableFrom(OpenCookie.class)) {
                return (T)((Node.Cookie)type.cast((Object)((JaxWsDataObject)this.getDataObject()).createEditorSupport()));
            }
            return (T)super.getCookie(type);
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }
    }
}

