/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelui.parsing.ParsingProblemResolver;
import org.netbeans.modules.cnd.spi.model.services.CodeModelProblemResolver;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.NbBundle;

public class ParsingProblemDetectorImpl
implements CodeModelProblemResolver.ParsingProblemDetector {
    private static final Logger LOG = Logger.getLogger("cnd.parsing.problem.detector");
    public static final boolean TIMING = Boolean.getBoolean("cnd.modelimpl.timing");
    private static final int Mb = 0x100000;
    private static final int timeThreshold = 60000;
    private final Runtime runtime = Runtime.getRuntime();
    public final int maxMemory = (int)(this.runtime.maxMemory() / 0x100000L);
    private final int startMemory;
    private int lineCount;
    private long startTime;
    private final List<Measure> measures;
    private final int memoryThreshold = Math.max(this.maxMemory / 10, 10);
    private final CsmProject project;
    private long remainingTime = 0L;
    private static boolean isDialogShown = false;

    public ParsingProblemDetectorImpl(CsmProject project) {
        this.startMemory = (int)((this.runtime.totalMemory() - this.runtime.freeMemory()) / 0x100000L);
        this.measures = new ArrayList<Measure>();
        this.project = project;
    }

    public void start() {
    }

    public void finish() {
        int parsingTime;
        int lines;
        if (this.measures.size() > 1 && (lines = this.measures.get((int)(this.measures.size() - 1)).lines) > 0 && (parsingTime = this.measures.get((int)(this.measures.size() - 1)).time) > 0) {
            int parsingMemory = 0;
            for (Measure m : this.measures) {
                parsingMemory = Math.max(parsingMemory, m.memory);
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Parsing statistic of ").append(this.project.getDisplayName()).append(":\n");
            buf.append("Parsed ").append(lines / 1000).append(" KLines, Time ").append(parsingTime / 1000).append(" seconds, Speed ").append(lines / parsingTime).append(" KLines/second, Max Memory ").append(parsingMemory).append(" Mb\n");
            int currentPercent = 1;
            int curentTime = 0;
            int curentLines = 0;
            buf.append("Work, %\t\tSpeed, KLines/second\tMemory, Mb\n");
            for (Measure m : this.measures) {
                int p = m.lines * 100 / lines;
                if (p - currentPercent * 5 < 0) continue;
                int l = m.lines - curentLines;
                curentLines = m.lines;
                int t = m.time - curentTime;
                curentTime = m.time;
                ++currentPercent;
                if (t == 0) continue;
                buf.append("\t").append(p).append("\t\t").append(l / t).append("\t\t").append(m.memory).append("\n");
            }
            LOG.log(Level.INFO, buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Measure> getData() {
        ArrayList<Measure> res = new ArrayList<Measure>();
        List<Measure> list = this.measures;
        synchronized (list) {
            res.addAll(this.measures);
        }
        return res;
    }

    private void showWarning() {
        if (isDialogShown) {
            return;
        }
        if (CndUtils.isStandalone() || CndUtils.isUnitTestMode()) {
            return;
        }
        if (this.remainingTime < 60000L) {
            return;
        }
        int usedMemory = (int)((this.runtime.totalMemory() - this.runtime.freeMemory()) / 0x100000L);
        if (this.maxMemory - usedMemory < this.memoryThreshold) {
            isDialogShown = true;
            LOG.log(Level.INFO, "Lack of Memory, Heap Size={0}Mb, Used Memory={1}Mb", new Object[]{this.maxMemory, usedMemory});
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParsingProblemResolver.showParsingProblemResolver(ParsingProblemDetectorImpl.this);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextCsmFile(CsmFile file, int current, int allWork) {
        String msg = "";
        int usedMemory = (int)((this.runtime.totalMemory() - this.runtime.freeMemory()) / 0x100000L);
        long delta = System.currentTimeMillis() - this.startTime;
        if (TIMING) {
            int lines = 0;
            if (file instanceof FileImpl) {
                int[] lineColumnByOffset = null;
                try {
                    lineColumnByOffset = ((FileImpl)file).getBuffer().getLineColumnByOffset(Integer.MAX_VALUE);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (lineColumnByOffset != null && lineColumnByOffset[0] > 0) {
                    lines = lineColumnByOffset[0];
                }
            }
            this.lineCount += lines;
            List<Measure> list = this.measures;
            synchronized (list) {
                this.measures.add(new Measure(this.lineCount, (int)delta, usedMemory));
            }
        }
        this.remainingTime = current < 10 ? 0L : delta * (long)(allWork - current) / (long)current;
        if (this.maxMemory - usedMemory < this.memoryThreshold) {
            msg = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"MSG_LowMemory");
        }
        this.showWarning();
        return msg;
    }

    public String getRemainingTime() {
        String esimation;
        if (this.remainingTime == 0L) {
            return "";
        }
        if (this.remainingTime < 1000L) {
            esimation = "";
        } else if (this.remainingTime < 60000L) {
            int s = (int)(this.remainingTime / 1000L);
            esimation = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Remaining_seconds", (Object)("" + s));
        } else if (this.remainingTime < 3600000L) {
            int s = (int)(this.remainingTime / 1000L / 60L);
            esimation = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Remaining_minutes", (Object)("" + s));
        } else {
            int s = (int)(this.remainingTime / 1000L / 60L / 60L);
            esimation = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Remaining_hours", (Object)("" + s));
        }
        return esimation;
    }

    public void switchToDeterminate(int maxWorkUnits) {
        this.startTime = System.currentTimeMillis();
    }

    public static final class Measure {
        public final int lines;
        public final int time;
        public final int memory;

        Measure(int lines, int time, int memory) {
            this.lines = lines;
            this.time = time;
            this.memory = memory;
        }
    }
}

