/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.actions;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public abstract class ProjectActionBase
extends NodeAction {
    private final boolean enabledAction;
    private boolean running;
    private JMenuItem presenter;
    private boolean inited = false;

    public ProjectActionBase(boolean enabledAction) {
        this.enabledAction = enabledAction;
    }

    protected abstract void performAction(Collection<CsmProject> var1);

    public JMenuItem getMenuPresenter() {
        return this.getPresenter();
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter();
    }

    private JMenuItem getPresenter() {
        if (!this.inited) {
            this.presenter = new JMenuItem();
            Actions.connect((JMenuItem)this.presenter, (Action)((Object)this), (boolean)true);
            this.inited = true;
        }
        Collection<CsmProject> projects = this.getCsmProjects(this.getActivatedNodes());
        if (this.enabledAction) {
            if (projects == null || projects.isEmpty()) {
                this.setEnabled(!this.running);
                this.presenter.setVisible(false);
            } else {
                try {
                    this.presenter.setVisible(true);
                    this.setEnabled(!this.running);
                }
                catch (Throwable thr) {
                    thr.printStackTrace(System.err);
                    this.setEnabled(false);
                }
            }
        } else {
            this.presenter.setVisible(false);
        }
        return this.presenter;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (!this.enabledAction) {
            return false;
        }
        if (this.running) {
            return false;
        }
        Collection<CsmProject> projects = this.getCsmProjects(activatedNodes);
        return this.isEnabledEx(activatedNodes, projects);
    }

    protected boolean isEnabledEx(Node[] activatedNodes, Collection<CsmProject> projects) {
        State state = this.getState(projects);
        return state != State.Indeterminate;
    }

    public void performAction(final Node[] activatedNodes) {
        this.running = true;
        CsmModelAccessor.getModel().enqueue(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ProjectActionBase.this.performAction(ProjectActionBase.this.getCsmProjects(activatedNodes));
                }
                finally {
                    ProjectActionBase.this.running = false;
                }
            }
        }, (CharSequence)("csmproject action " + this.getName()));
    }

    protected boolean asynchronous() {
        return false;
    }

    protected Collection<CsmProject> getCsmProjects(Node[] nodes) {
        HashSet<CsmProject> csmProjects = new HashSet<CsmProject>();
        for (int i = 0; i < nodes.length; ++i) {
            CsmProject csm = (CsmProject)nodes[i].getLookup().lookup(CsmProject.class);
            if (csm == null) {
                Object o;
                NativeProject nativeProject = (NativeProject)nodes[i].getLookup().lookup(NativeProject.class);
                if (nativeProject == null && (o = nodes[i].getValue("Project")) instanceof Project) {
                    nativeProject = (NativeProject)((Project)o).getLookup().lookup(NativeProject.class);
                }
                if (nativeProject != null) {
                    CsmModel model = CsmModelAccessor.getModel();
                    Object object = csm = model instanceof ModelImpl ? ((ModelImpl)model).getProject((Object)nativeProject) : model.getProject((Object)nativeProject);
                }
            }
            if (csm == null) continue;
            csmProjects.add(csm);
        }
        return csmProjects;
    }

    protected State getState(Collection<CsmProject> projects) {
        CsmModel model = CsmModelAccessor.getModel();
        if (model == null || model.getState() != CsmModelState.ON) {
            return State.Indeterminate;
        }
        State state = State.NoProjects;
        for (CsmProject p : projects) {
            State curr = this.getState(p);
            if (state == State.NoProjects) {
                state = curr;
                continue;
            }
            if (state == curr) continue;
            return State.Indeterminate;
        }
        return state;
    }

    private State getState(CsmProject csmPrj) {
        return csmPrj != null && csmPrj.isStable(null) ? State.Enabled : State.Disabled;
    }

    protected static enum State {
        NoProjects,
        Enabled,
        Disabled,
        Indeterminate;

    }
}

