/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitPushResult;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.jgit.DelegatingProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.TransportCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class PushCommand
extends TransportCommand {
    private final ProgressMonitor monitor;
    private final List<String> pushRefSpecs;
    private final String remote;
    private GitPushResult result;
    private final List<String> fetchRefSpecs;

    public PushCommand(Repository repository, GitClassFactory gitFactory, String remote, List<String> pushRefSpecifications, List<String> fetchRefSpecifications, ProgressMonitor monitor) {
        super(repository, gitFactory, remote, monitor);
        this.monitor = monitor;
        this.remote = remote;
        this.pushRefSpecs = pushRefSpecifications;
        this.fetchRefSpecs = fetchRefSpecifications;
    }

    @Override
    protected void runTransportCommand() throws GitException.AuthorizationException, GitException {
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>(this.pushRefSpecs.size());
        for (String refSpec : this.pushRefSpecs) {
            RefSpec sp = new RefSpec(refSpec).setForceUpdate(false);
            specs.add(sp);
        }
        ArrayList<RefSpec> fetchSpecs = new ArrayList<RefSpec>(this.fetchRefSpecs == null ? 0 : this.fetchRefSpecs.size());
        for (String refSpec : this.fetchRefSpecs) {
            RefSpec sp = new RefSpec(refSpec);
            fetchSpecs.add(sp);
        }
        Transport transport = null;
        try {
            transport = this.openTransport(true);
            transport.setDryRun(false);
            transport.setPushThin(true);
            transport.setRemoveDeletedRefs(true);
            transport.setTagOpt(TagOpt.AUTO_FOLLOW);
            PushResult pushResult = transport.push((org.eclipse.jgit.lib.ProgressMonitor)new DelegatingProgressMonitor(this.monitor), fetchSpecs.isEmpty() ? transport.findRemoteRefUpdatesFor(specs) : Transport.findRemoteRefUpdatesFor((Repository)this.getRepository(), specs, fetchSpecs));
            Map<String, GitBranch> remoteBranches = Utils.refsToBranches(pushResult.getAdvertisedRefs(), "refs/heads/", this.getClassFactory());
            for (String msg : pushResult.getMessages().split("\n")) {
                if (msg.isEmpty()) continue;
            }
            HashMap<String, GitTransportUpdate> remoteRepositoryUpdates = new HashMap<String, GitTransportUpdate>(pushResult.getRemoteUpdates().size());
            for (RemoteRefUpdate update : pushResult.getRemoteUpdates()) {
                GitTransportUpdate upd = this.getClassFactory().createTransportUpdate(transport.getURI(), update, remoteBranches);
                remoteRepositoryUpdates.put(upd.getRemoteName(), upd);
            }
            HashMap<String, GitTransportUpdate> localRepositoryUpdates = new HashMap<String, GitTransportUpdate>(pushResult.getTrackingRefUpdates().size());
            for (TrackingRefUpdate update : pushResult.getTrackingRefUpdates()) {
                GitTransportUpdate upd = this.getClassFactory().createTransportUpdate(transport.getURI(), update);
                localRepositoryUpdates.put(upd.getRemoteName(), upd);
            }
            this.result = this.getClassFactory().createPushResult(remoteRepositoryUpdates, localRepositoryUpdates);
        }
        catch (NotSupportedException e) {
            throw new GitException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new GitException(e.getMessage(), e);
        }
        catch (TransportException e) {
            URIish uriish = null;
            try {
                uriish = this.getUriWithUsername(true);
            }
            catch (URISyntaxException ex) {
                throw new GitException(e.getMessage(), e);
            }
            this.handleException(e, uriish);
        }
        catch (IOException e) {
            throw new GitException(e.getMessage(), e);
        }
        finally {
            if (transport != null) {
                transport.close();
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git push ").append(this.remote);
        for (String refSpec : this.pushRefSpecs) {
            sb.append(' ').append(refSpec);
        }
        return sb.toString();
    }

    public GitPushResult getResult() {
        return this.result;
    }
}

