/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class InitRepositoryCommand
extends GitCommand {
    private final File workDir;
    private final ProgressMonitor monitor;

    public InitRepositoryCommand(Repository repository, GitClassFactory gitFactory, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.workDir = this.getRepository().getWorkTree();
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean repositoryExists = this.getRepository().getDirectory().exists();
        if (repositoryExists) {
            String message = MessageFormat.format(Utils.getBundle(InitRepositoryCommand.class).getString("MSG_Error_RepositoryExists"), this.getRepository().getWorkTree());
            this.monitor.preparationsFailed(message);
            throw new GitException(message);
        }
        return true;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            if (!this.workDir.exists() && !this.workDir.mkdirs()) {
                throw new GitException(MessageFormat.format(Utils.getBundle(InitRepositoryCommand.class).getString("MSG_Exception_CannotCreateFolder"), this.workDir.getAbsolutePath()));
            }
            repository.create();
            StoredConfig cfg = repository.getConfig();
            cfg.setBoolean("core", null, "bare", false);
            cfg.unset("core", null, "autocrlf");
            cfg.save();
        }
        catch (IllegalStateException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git init " + this.workDir.getAbsolutePath();
    }
}

