/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GetRemotesCommand
extends GitCommand {
    private Map<String, GitRemoteConfig> remotes;

    public GetRemotesCommand(Repository repository, GitClassFactory gitFactory, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            List configs = RemoteConfig.getAllRemoteConfigs((Config)repository.getConfig());
            this.remotes = new HashMap<String, GitRemoteConfig>(configs.size());
            for (RemoteConfig remote : configs) {
                this.remotes.put(remote.getName(), this.getClassFactory().createRemoteConfig(remote));
            }
        }
        catch (URISyntaxException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git remote -v";
    }

    public Map<String, GitRemoteConfig> getRemotes() {
        return this.remotes;
    }
}

