/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GetCommonAncestorCommand
extends GitCommand {
    private final String[] revisions;
    private GitRevisionInfo revision;

    public GetCommonAncestorCommand(Repository repository, GitClassFactory gitFactory, String[] revisions, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.revisions = revisions;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        RevWalk walk = new RevWalk(repository);
        try {
            for (String rev : this.revisions) {
                walk.markStart(walk.lookupCommit((AnyObjectId)Utils.findCommit(repository, rev)));
            }
            walk.setRevFilter(RevFilter.MERGE_BASE);
            Iterator it = walk.iterator();
            if (it.hasNext()) {
                this.revision = this.getClassFactory().createRevisionInfo((RevCommit)it.next(), repository);
            }
        }
        catch (MissingObjectException ex) {
            throw new GitException.MissingObjectException(ex.getObjectId().toString(), GitObjectType.COMMIT);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            walk.release();
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git merge-base ");
        for (String s : this.revisions) {
            sb.append(s).append(' ');
        }
        return sb.toString();
    }

    public GitRevisionInfo getRevision() {
        return this.revision;
    }
}

