/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CannotDeleteCurrentBranchException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class DeleteBranchCommand
extends GitCommand {
    private final String branchName;
    private final boolean forceDeleteUnmerged;

    public DeleteBranchCommand(Repository repository, GitClassFactory gitFactory, String branchName, boolean forceDeleteUnmerged, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.branchName = branchName;
        this.forceDeleteUnmerged = forceDeleteUnmerged;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        org.eclipse.jgit.api.DeleteBranchCommand cmd = new Git(repository).branchDelete();
        cmd.setForce(this.forceDeleteUnmerged || Utils.parseObjectId(repository, "HEAD") == null);
        cmd.setBranchNames(new String[]{this.branchName});
        try {
            cmd.call();
        }
        catch (JGitInternalException ex) {
            throw new GitException(ex);
        }
        catch (NotMergedException ex) {
            throw new GitException.NotMergedException(this.branchName);
        }
        catch (CannotDeleteCurrentBranchException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git branch ");
        sb.append(this.forceDeleteUnmerged ? "-D " : "-d ");
        sb.append(this.branchName);
        return sb.toString();
    }
}

