/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.util.Map;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.DelegatingGitProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.ListBranchCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CreateBranchCommand
extends GitCommand {
    private final String revision;
    private final String branchName;
    private GitBranch branch;
    private final ProgressMonitor monitor;

    public CreateBranchCommand(Repository repository, GitClassFactory gitFactory, String branchName, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.branchName = branchName;
        this.revision = revision;
        this.monitor = monitor;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        org.eclipse.jgit.api.CreateBranchCommand cmd = new Git(repository).branchCreate();
        cmd.setName(this.branchName);
        if (this.revision.startsWith("refs/heads/") || this.revision.startsWith("refs/remotes/")) {
            cmd.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK);
        } else {
            Utils.findCommit(repository, this.revision);
        }
        cmd.setStartPoint(this.revision);
        try {
            cmd.call();
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
        ListBranchCommand branchCmd = new ListBranchCommand(repository, this.getClassFactory(), false, new DelegatingGitProgressMonitor(this.monitor));
        branchCmd.run();
        Map<String, GitBranch> branches = branchCmd.getBranches();
        this.branch = branches.get(this.branchName);
    }

    @Override
    protected String getCommandDescription() {
        return "git branch --track " + this.branchName + ' ' + this.revision;
    }

    public GitBranch getBranch() {
        return this.branch;
    }
}

