/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CheckoutRevisionCommand
extends GitCommand {
    private final FileListener listener;
    private final ProgressMonitor monitor;
    private final String revision;
    private final boolean failOnConflict;
    private DirCache cache;

    public CheckoutRevisionCommand(Repository repository, GitClassFactory gitFactory, String revision, boolean failOnConflict, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.revision = revision;
        this.listener = listener;
        this.monitor = monitor;
        this.failOnConflict = failOnConflict;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            RevCommit commit;
            String fromName;
            Ref headRef = repository.getRef("HEAD");
            RevTree headTree = null;
            try {
                headTree = Utils.findCommit(repository, "HEAD").getTree();
            }
            catch (GitException.MissingObjectException ex) {
                // empty catch block
            }
            Ref ref = repository.getRef(this.revision);
            if (ref != null && !ref.getName().startsWith("refs/heads/") && !ref.getName().startsWith("refs/remotes/")) {
                ref = null;
            }
            if ((fromName = headRef.getTarget().getName()).startsWith("refs/heads/")) {
                fromName = fromName.substring("refs/heads/".length());
            }
            String refLogMessage = "checkout: moving from " + fromName;
            this.cache = repository.lockDirCache();
            DirCacheCheckout dco = null;
            try {
                commit = Utils.findCommit(repository, this.revision);
                dco = headTree == null ? new DirCacheCheckout(repository, this.cache, (ObjectId)commit.getTree()) : new DirCacheCheckout(repository, (ObjectId)headTree, this.cache, (ObjectId)commit.getTree());
                dco.setFailOnConflict(this.failOnConflict);
                dco.checkout();
                File workDir = repository.getWorkTree();
                for (String path : dco.getUpdated().keySet()) {
                    DirCacheEntry e = this.cache.getEntry(path);
                    if (!FileMode.GITLINK.equals(e.getRawMode())) continue;
                    new File(workDir, path).mkdirs();
                }
                this.notify(workDir, dco.getRemoved());
                this.notify(workDir, dco.getConflicts());
                this.notify(workDir, dco.getUpdated().keySet());
            }
            catch (CheckoutConflictException ex) {
                List conflicts = dco.getConflicts();
                throw new GitException.CheckoutConflictException(conflicts.toArray(new String[conflicts.size()]));
            }
            finally {
                this.cache.unlock();
            }
            if (!this.monitor.isCanceled()) {
                RefUpdate.Result updateResult;
                String toName;
                boolean detach = true;
                if (ref == null) {
                    toName = commit.getName();
                } else {
                    toName = ref.getName();
                    if (toName.startsWith("refs/heads/")) {
                        detach = false;
                        toName = toName.substring("refs/heads/".length());
                    } else if (toName.startsWith("refs/remotes/")) {
                        toName = toName.substring("refs/remotes/".length());
                    }
                }
                RefUpdate refUpdate = repository.updateRef("HEAD", detach);
                refUpdate.setForceUpdate(false);
                refUpdate.setRefLogMessage(refLogMessage + " to " + toName, false);
                if (!detach) {
                    updateResult = refUpdate.link(ref.getName());
                } else {
                    refUpdate.setNewObjectId((AnyObjectId)commit);
                    updateResult = refUpdate.forceUpdate();
                }
                boolean ok = false;
                switch (updateResult) {
                    case NEW: {
                        ok = true;
                        break;
                    }
                    case NO_CHANGE: 
                    case FAST_FORWARD: 
                    case FORCED: {
                        ok = true;
                        break;
                    }
                }
                if (!ok) {
                    throw new GitException("Unexpected result: " + updateResult.name());
                }
            }
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git checkout ").append(this.revision);
        return sb.toString();
    }

    private void notify(File workDir, Collection<String> paths) {
        for (String path : paths) {
            File f = new File(workDir, path);
            this.listener.notifyFile(f, path);
        }
    }
}

