/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.netbeans.libs.git.GitBlameResult;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.utils.AutoCRLFComparator;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class BlameCommand
extends GitCommand {
    private final String revision;
    private final File file;
    private final ProgressMonitor monitor;
    private GitBlameResult result;

    public BlameCommand(Repository repository, GitClassFactory gitFactory, File file, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.file = file;
        this.revision = revision;
        this.monitor = monitor;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        org.eclipse.jgit.api.BlameCommand cmd = new Git(repository).blame();
        cmd.setFilePath(Utils.getRelativePath(this.getRepository().getWorkTree(), this.file));
        if (this.revision != null) {
            cmd.setStartCommit((AnyObjectId)Utils.findCommit(repository, this.revision));
        } else if (((WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY)).getAutoCRLF() != CoreConfig.AutoCRLF.FALSE) {
            cmd.setTextComparator((RawTextComparator)new AutoCRLFComparator());
        }
        cmd.setFollowFileRenames(true);
        BlameResult cmdResult = cmd.call();
        if (cmdResult != null) {
            this.result = this.getClassFactory().createBlameResult(cmdResult, repository);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git blame -l -f ");
        if (this.revision != null) {
            sb.append(this.revision).append(" ");
        }
        sb.append(this.file);
        return sb.toString();
    }

    public GitBlameResult getResult() {
        return this.result;
    }
}

