/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.Utils;

public final class JGitRepository {
    private Repository repository;
    private final File location;

    public JGitRepository(File location) {
        this.location = location;
    }

    public synchronized void increaseClientUsage() throws GitException {
        if (this.repository == null) {
            this.repository = this.getRepository(this.location);
        } else {
            this.repository.incrementOpen();
        }
    }

    public synchronized void decreaseClientUsage() {
        this.repository.close();
    }

    private Repository getRepository(File workDir) throws GitException {
        try {
            return Utils.getRepositoryForWorkingDir(workDir);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        catch (IllegalArgumentException ex) {
            if (ex.getMessage().matches(JGitText.get().repositoryConfigFileInvalid.replaceAll("\\{[0-9]?}", "\\(\\.\\*)"))) {
                throw new GitException("It seems the config file for the repository at [" + workDir.getAbsolutePath() + "] is corrupted.\nEnsure it ends with empty line.", ex);
            }
            throw new GitException(ex);
        }
    }

    public Repository getRepository() {
        assert (this.repository != null);
        return this.repository;
    }
}

