/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.lib.ObjectId;

public final class GitMergeResult {
    private final MergeStatus mergeStatus;
    private final File workDir;
    private final List<File> conflicts;
    private final List<File> failures;
    private final String newHead;
    private final String base;
    private final String[] mergedCommits;

    GitMergeResult(MergeResult result, File workDir) {
        this.mergeStatus = MergeStatus.valueOf(result.getMergeStatus().name());
        this.workDir = workDir;
        this.newHead = result.getNewHead() == null ? null : result.getNewHead().getName();
        this.base = result.getBase() == null ? null : result.getBase().getName();
        this.mergedCommits = this.getMergedCommits(result);
        this.conflicts = this.getConflicts(result);
        this.failures = this.getFailures(result);
    }

    public MergeStatus getMergeStatus() {
        return this.mergeStatus;
    }

    public String getBase() {
        return this.base;
    }

    public String[] getMergedCommits() {
        return this.mergedCommits;
    }

    public String getNewHead() {
        return this.newHead;
    }

    public Collection<File> getConflicts() {
        return this.conflicts;
    }

    public Collection<File> getFailures() {
        return this.failures;
    }

    private String[] getMergedCommits(MergeResult result) {
        ObjectId[] mergedObjectIds = result.getMergedCommits();
        String[] commits = new String[mergedObjectIds.length];
        for (int i = 0; i < mergedObjectIds.length; ++i) {
            commits[i] = ObjectId.toString((ObjectId)mergedObjectIds[i]);
        }
        return commits;
    }

    private List<File> getConflicts(MergeResult result) {
        LinkedList<File> files = new LinkedList<File>();
        Map mergeConflicts = result.getConflicts();
        if (mergeConflicts != null) {
            for (Map.Entry conflict : mergeConflicts.entrySet()) {
                files.add(new File(this.workDir, (String)conflict.getKey()));
            }
        }
        return Collections.unmodifiableList(files);
    }

    private List<File> getFailures(MergeResult result) {
        LinkedList<File> files = new LinkedList<File>();
        Map obstructions = result.getFailingPaths();
        if (obstructions != null) {
            for (Map.Entry failure : obstructions.entrySet()) {
                files.add(new File(this.workDir, (String)failure.getKey()));
            }
        }
        return Collections.unmodifiableList(files);
    }

    public static enum MergeStatus {
        FAST_FORWARD{

            public String toString() {
                return "Fast-forward";
            }
        }
        ,
        ALREADY_UP_TO_DATE{

            public String toString() {
                return "Already up-to-date";
            }
        }
        ,
        FAILED{

            public String toString() {
                return "Failed";
            }
        }
        ,
        MERGED{

            public String toString() {
                return "Merged";
            }
        }
        ,
        CONFLICTING{

            public String toString() {
                return "Conflicting";
            }
        }
        ,
        NOT_SUPPORTED{

            public String toString() {
                return "Not-yet-supported";
            }
        };

    }
}

