/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.javascript.jstestdriver.wizard.InstallJasmineWizardDescriptorPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class NewConfigFileWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    private WizardDescriptor descriptor;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private InstallJasmineWizardDescriptorPanel jasmineWizardPanel;
    private int index;
    private static final String SOURCES_TYPE_HTML5_CONFIG = "HTML5-Config";
    private static final String SOURCES_TYPE_HTML5_TEST = "HTML5-Tests";

    public void initialize(WizardDescriptor wizard) {
        this.descriptor = wizard;
        Templates.setTargetName((WizardDescriptor)wizard, (String)"jsTestDriver");
        this.panels = this.getPanels();
        String[] beforeSteps = (String[])wizard.getProperty("WizardPanel_contentData");
        int beforeStepLength = beforeSteps.length - 1;
        String[] steps = this.createSteps(beforeSteps);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i + beforeStepLength - 1);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public Set<FileObject> instantiate() throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.descriptor);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.descriptor);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)dir);
        DataObject dataTemplate = DataObject.find((FileObject)template);
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.jasmineWizardPanel.installJasmine()) {
            map.put("jasmine", "true");
        }
        DataObject createdFile = dataTemplate.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.descriptor), map);
        Project project = Templates.getProject((WizardDescriptor)this.descriptor);
        SourceGroup[] groups = ProjectUtils.getSources((Project)project).getSourceGroups(SOURCES_TYPE_HTML5_TEST);
        FileObject libs = null;
        if (groups != null && groups.length > 0) {
            FileUtil.createFolder((FileObject)groups[0].getRootFolder(), (String)"unit");
            libs = FileUtil.createFolder((FileObject)groups[0].getRootFolder(), (String)"lib");
        }
        if (this.jasmineWizardPanel.installJasmine() && libs != null) {
            this.jasmineWizardPanel.downloadJasmine(libs);
        }
        return Collections.singleton(createdFile.getPrimaryFile());
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        Project project = Templates.getProject((WizardDescriptor)this.descriptor);
        SourceGroup[] groups = ProjectUtils.getSources((Project)project).getSourceGroups(SOURCES_TYPE_HTML5_CONFIG);
        this.jasmineWizardPanel = new InstallJasmineWizardDescriptorPanel();
        WizardDescriptor.Panel simpleTargetChooserPanel = Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])groups).bottomPanel((WizardDescriptor.Panel)this.jasmineWizardPanel).create();
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{simpleTargetChooserPanel};
        return panels;
    }

    private String[] createSteps(String[] beforeSteps) {
        int beforeStepLength = beforeSteps.length - 1;
        String[] res = new String[beforeStepLength + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeStepLength ? beforeSteps[i] : this.panels[i - beforeStepLength].getComponent().getName();
        }
        return res;
    }
}

