/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver.wizard;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javascript.jstestdriver.wizard.Bundle;
import org.netbeans.modules.javascript.jstestdriver.wizard.InstallJasminePanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

public class InstallJasmineWizardDescriptorPanel
implements WizardDescriptor.Panel<WizardDescriptor> {
    private InstallJasminePanel panel;
    private static final Logger LOGGER = Logger.getLogger(InstallJasmineWizardDescriptorPanel.class.getName());

    public Component getComponent() {
        if (this.panel == null) {
            this.panel = new InstallJasminePanel();
        }
        return this.panel;
    }

    public boolean installJasmine() {
        return this.panel != null ? this.panel.installJasmine() : false;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor settings) {
    }

    public void storeSettings(WizardDescriptor settings) {
    }

    public boolean isValid() {
        return true;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void downloadJasmine(FileObject libs) {
        try {
            File jasmine = File.createTempFile("jasmine", "zip");
            File jasmineJSTD = File.createTempFile("jasmine-jstd", "zip");
            InstallJasmineWizardDescriptorPanel.download("https://github.com/pivotal/jasmine/zipball/v1.2.0", jasmine);
            InstallJasmineWizardDescriptorPanel.download("https://github.com/ibolmo/jasmine-jstd-adapter/zipball/1.1.2", jasmineJSTD);
            InstallJasmineWizardDescriptorPanel.unzip(new FileInputStream(jasmine), libs.createFolder("jasmine"), "1.2.0");
            InstallJasmineWizardDescriptorPanel.unzip(new FileInputStream(jasmineJSTD), libs.createFolder("jasmine-jstd-adapter"), "1.1.2");
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "download of remote jasmine files failed", ex);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.DownloadFailure()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(String url, File target) throws IOException {
        try {
            InputStream is = new URL(url).openStream();
            try {
                InstallJasmineWizardDescriptorPanel.copyToFile(is, target);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            target.delete();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream source, FileObject root, String version) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                String nameToCreate;
                String entryName = entry.getName();
                if (entryName.endsWith("lib/jasmine-core/jasmine.css")) {
                    nameToCreate = "jasmine.css";
                } else if (entryName.endsWith("lib/jasmine-core/jasmine.js")) {
                    nameToCreate = "jasmine.js";
                } else if (entryName.endsWith("lib/jasmine-core/jasmine-html.js")) {
                    nameToCreate = "jasmine-html.js";
                } else if (entryName.endsWith("lib/jasmine-core/json2.js")) {
                    nameToCreate = "json2.js";
                } else if (entryName.endsWith("MIT.LICENSE")) {
                    nameToCreate = "MIT.LICENSE";
                } else {
                    if (!entryName.endsWith("src/JasmineAdapter.js")) continue;
                    nameToCreate = "JasmineAdapter.js";
                }
                FileObject fo = FileUtil.createData((FileObject)root, (String)nameToCreate);
                InstallJasmineWizardDescriptorPanel.writeFile(str, fo);
            }
            FileObject fo = FileUtil.createData((FileObject)root, (String)"version.txt");
            ByteArrayInputStream is2 = new ByteArrayInputStream(version.getBytes());
            InstallJasmineWizardDescriptorPanel.writeFile(is2, fo);
        }
        finally {
            source.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyToFile(InputStream is, File target) throws IOException {
        FileOutputStream os = new FileOutputStream(target);
        try {
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            ((OutputStream)os).close();
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(InputStream str, FileObject fo) throws IOException {
        OutputStream out = fo.getOutputStream();
        try {
            FileUtil.copy((InputStream)str, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }
}

