/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.modules.javascript.jstestdriver.JSTestDriverCustomizerPanel;
import org.netbeans.modules.javascript.jstestdriver.JSTestDriverSupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

public class TestDriverServiceNode
extends AbstractNode {
    private static final String TESTDRIVER_ICON = "org/netbeans/modules/javascript/jstestdriver/resources/JsTestDriver.png";
    private static final String RUNNING_BADGE = "org/netbeans/modules/javascript/jstestdriver/resources/running.png";
    private static final String WAITING_BADGE = "org/netbeans/modules/javascript/jstestdriver/resources/waiting.png";
    private static TestDriverServiceNode node;

    private TestDriverServiceNode() {
        super(Children.LEAF);
        this.setName("testdriver");
        this.setDisplayName(NbBundle.getMessage(TestDriverServiceNode.class, (String)"Test_Driver_Node_Name"));
        this.setShortDescription(NbBundle.getMessage(TestDriverServiceNode.class, (String)"Test_Driver_Node_Short_Description"));
        this.setIconBaseWithExtension(TESTDRIVER_ICON);
    }

    public static synchronized TestDriverServiceNode getInstance() {
        if (node == null) {
            node = new TestDriverServiceNode();
        }
        return node;
    }

    void refresh() {
        this.setShortDescription(this.getShortDescription());
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public Image getIcon(int type) {
        return this.badgeIcon(super.getIcon(type));
    }

    public Image getOpenedIcon(int type) {
        return this.badgeIcon(super.getOpenedIcon(type));
    }

    private Image badgeIcon(Image origImg) {
        Image badge = null;
        if (JSTestDriverSupport.getDefault().isStarting()) {
            badge = ImageUtilities.loadImage((String)WAITING_BADGE);
        }
        if (JSTestDriverSupport.getDefault().isRunning()) {
            badge = ImageUtilities.loadImage((String)RUNNING_BADGE);
        }
        return badge != null ? ImageUtilities.mergeImages((Image)origImg, (Image)badge, (int)15, (int)8) : origImg;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(StartJSTestDriver.class), SystemAction.get(StopJSTestDriver.class), SystemAction.get(ConfigureJSTestDriver.class)};
    }

    public String getShortDescription() {
        return JSTestDriverSupport.getDefault().getUserDescription();
    }

    public static class ConfigureJSTestDriver
    extends NodeAction {
        protected void performAction(Node[] activatedNodes) {
            JSTestDriverSupport.getDefault().configure();
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(TestDriverServiceNode.class, (String)"ACTION_CONFIGURE");
        }

        protected boolean asynchronous() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }

    public static class StopJSTestDriver
    extends NodeAction {
        protected void performAction(Node[] activatedNodes) {
            JSTestDriverSupport.getDefault().stop();
        }

        protected boolean enable(Node[] activatedNodes) {
            return JSTestDriverSupport.getDefault().isRunning() && !JSTestDriverSupport.getDefault().wasStartedExternally();
        }

        public String getName() {
            return NbBundle.getMessage(TestDriverServiceNode.class, (String)"ACTION_STOP");
        }

        protected boolean asynchronous() {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }

    public static class StartJSTestDriver
    extends NodeAction {
        protected void performAction(Node[] activatedNodes) {
            JSTestDriverSupport.getDefault().start(null);
        }

        protected boolean enable(Node[] activatedNodes) {
            return !JSTestDriverSupport.getDefault().isRunning() && JSTestDriverCustomizerPanel.getPort() != -1;
        }

        public String getName() {
            return NbBundle.getMessage(TestDriverServiceNode.class, (String)"ACTION_START");
        }

        protected boolean asynchronous() {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }
}

