/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.libs.jstestdriver.api.JsTestDriver;
import org.netbeans.libs.jstestdriver.api.ServerListener;
import org.netbeans.libs.jstestdriver.api.TestListener;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.javascript.jstestdriver.JSTestDriverCustomizerPanel;
import org.netbeans.modules.javascript.jstestdriver.TestDriverServiceNode;
import org.netbeans.modules.web.browser.api.WebBrowserPane;
import org.netbeans.modules.web.common.api.RemoteFileCache;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class JSTestDriverSupport {
    private static JSTestDriverSupport def;
    private static final Logger LOGGER;
    private static final Logger USG_LOGGER;
    private RequestProcessor RP = new RequestProcessor("js-test-driver server", 5);
    private AbstractLookup projectContext;
    private InstanceContent lookupContent = new InstanceContent();
    private List<WebBrowserPane> integratedBrowserPanes;
    private JsTestDriver testDriver;
    private volatile boolean starting = false;

    public static synchronized JSTestDriverSupport getDefault() {
        if (def == null) {
            def = new JSTestDriverSupport();
        }
        return def;
    }

    private JSTestDriverSupport() {
        this.projectContext = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
    }

    private synchronized JsTestDriver getJsTestDriver() {
        if (this.testDriver == null) {
            if (!this.isConfiguredProperly()) {
                return null;
            }
            String jsTestDriverJar = JSTestDriverCustomizerPanel.getJSTestDriverJar();
            File f = new File(jsTestDriverJar);
            try {
                this.testDriver = new JsTestDriver(f);
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.INFO, "cannot access js-test-driver wrapper", ex);
                return null;
            }
        }
        return this.testDriver;
    }

    public String getUserDescription() {
        if (JSTestDriverCustomizerPanel.getPort() == -1) {
            return NbBundle.getMessage(JSTestDriverSupport.class, (String)"SERVER_EXTERNAL", (Object)JSTestDriverCustomizerPanel.getServerURL());
        }
        if (this.wasStartedExternally()) {
            return NbBundle.getMessage(JSTestDriverSupport.class, (String)"SERVER_EXTERNAL2", (Object)JSTestDriverCustomizerPanel.getPort());
        }
        if (this.isRunning()) {
            return NbBundle.getMessage(JSTestDriverSupport.class, (String)"SERVER_RUNNING", (Object)JSTestDriverCustomizerPanel.getServerURL());
        }
        return NbBundle.getMessage(JSTestDriverSupport.class, (String)"SERVER_NOT_RUNNING");
    }

    boolean isRunning() {
        return this.testDriver != null && this.testDriver.isRunning();
    }

    void forgetCurrentServer() {
        this.testDriver = null;
    }

    public boolean wasStartedExternally() {
        return this.testDriver != null && this.testDriver.wasStartedExternally();
    }

    public boolean isStarting() {
        return this.starting;
    }

    public void stop() {
        assert (this.isRunning());
        assert (this.testDriver != null);
        this.testDriver.stopServer();
        TestDriverServiceNode.getInstance().refresh();
        if (this.integratedBrowserPanes != null) {
            for (WebBrowserPane wbp : this.integratedBrowserPanes) {
                wbp.close(true);
            }
        }
    }

    public void start(final ServerListener l) {
        assert (!this.isRunning());
        JsTestDriver td = this.getJsTestDriver();
        if (td == null && this.configure()) {
            td = this.getJsTestDriver();
        }
        if (td == null) {
            return;
        }
        final JsTestDriver td2 = td;
        this.starting = true;
        TestDriverServiceNode.getInstance().refresh();
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    td2.startServer(JSTestDriverCustomizerPanel.getPort(), JSTestDriverCustomizerPanel.isStricModel(), new ServerListener(){

                        public void serverStarted() {
                            JSTestDriverSupport.this.RP.post(new Runnable(){

                                @Override
                                public void run() {
                                    JSTestDriverSupport.this.captureBrowsers();
                                    if (l != null) {
                                        l.serverStarted();
                                    }
                                    JSTestDriverSupport.this.starting = false;
                                    TestDriverServiceNode.getInstance().refresh();
                                    JSTestDriverSupport.logUsage(JSTestDriverSupport.class, "USG_JSTESTDRIVER_STARTED", null);
                                }
                            });
                        }
                    });
                    if (td2.wasStartedExternally()) {
                        JSTestDriverSupport.this.starting = false;
                        TestDriverServiceNode.getInstance().refresh();
                        if (l != null) {
                            l.serverStarted();
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "cannot start server", t);
                }
            }
        });
    }

    public boolean configure() {
        final boolean[] res = new boolean[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean b = JSTestDriverCustomizerPanel.showCustomizer();
                TestDriverServiceNode.getInstance().refresh();
                res[0] = b;
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return res[0];
    }

    public boolean isConfiguredProperly() {
        return JSTestDriverCustomizerPanel.isConfiguredProperly();
    }

    public void runAllTests(Project project, File baseFolder, File configFile, String testsToRun) {
        JsTestDriver td = this.getJsTestDriver();
        if (td == null && this.configure()) {
            td = this.getJsTestDriver();
        }
        if (td == null) {
            return;
        }
        String serverURL = JSTestDriverCustomizerPanel.getServerURL();
        int port = JSTestDriverCustomizerPanel.getPort();
        boolean strictMode = JSTestDriverCustomizerPanel.isStricModel();
        if (!this.isRunning() && port != -1) {
            final Semaphore s = new Semaphore(0);
            this.start(new ServerListener(){

                public void serverStarted() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    s.release();
                }
            });
            try {
                s.acquire();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (!this.isRunning()) {
                return;
            }
        }
        this.updateJsDebuggerProjectContext(project);
        Listener listener = new Listener(project);
        LineConvertorImpl convertor = new LineConvertorImpl(project);
        td.runTests(serverURL, strictMode, baseFolder, configFile, testsToRun, (TestListener)listener, (LineConvertor)convertor);
    }

    private void updateJsDebuggerProjectContext(Project p) {
        this.lookupContent.set(Collections.singletonList(p), null);
    }

    private void captureBrowsers() {
        this.integratedBrowserPanes = new ArrayList<WebBrowserPane>();
        for (JSTestDriverCustomizerPanel.WebBrowserDesc bd : JSTestDriverCustomizerPanel.getBrowsers()) {
            String s = JSTestDriverCustomizerPanel.getServerURL() + "/capture";
            if (bd.nbIntegration) {
                s = s + "/timeout/-1/";
            }
            if (JSTestDriverCustomizerPanel.isStricModel()) {
                s = s + "?strict";
            }
            try {
                URL u = new URL(s);
                WebBrowserPane pane = bd.browser.createNewBrowserPane(true, !bd.nbIntegration);
                pane.disablePageInspector();
                pane.setProjectContext((Lookup)this.projectContext);
                pane.showURL(u);
                if (!bd.nbIntegration) continue;
                this.integratedBrowserPanes.add(pane);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static void logUsage(Class srcClass, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        USG_LOGGER.log(logRecord);
    }

    static {
        LOGGER = Logger.getLogger(JSTestDriverSupport.class.getName());
        USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.jstestdriver");
    }

    private static class Listener
    implements TestListener {
        private TestSession testSession;
        private Manager manager = Manager.getInstance();
        private Report report;

        public Listener(Project project) {
            this.testSession = new TestSession(NbBundle.getMessage(JSTestDriverSupport.class, (String)"TESTING", (Object)ProjectUtils.getInformation((Project)project).getDisplayName()), project, TestSession.SessionType.TEST);
            this.manager.testStarted(this.testSession);
        }

        public void onTestComplete(TestListener.TestResult testResult) {
            TestSuite currentSuite = this.testSession.getCurrentSuite();
            if (currentSuite == null || !currentSuite.getName().equals(testResult.getBrowserInfo().getDisplayName())) {
                if (this.report != null) {
                    this.manager.displayReport(this.testSession, this.report, true);
                }
                TestSuite ts = new TestSuite(testResult.getBrowserInfo().getDisplayName());
                this.testSession.addSuite(ts);
                this.report = this.testSession.getReport(0L);
                this.manager.displaySuiteRunning(this.testSession, ts.getName());
            }
            Testcase testCase = new Testcase(testResult.getTestCaseName(), null, this.testSession);
            testCase.setStatus(this.convert(testResult.getResult()));
            testCase.setTimeMillis(testResult.getDuration());
            if (testResult.getResult() == TestListener.TestResult.Result.failed || testResult.getResult() == TestListener.TestResult.Result.error) {
                Trouble t = new Trouble(true);
                if (testResult.getStack().length() > 0) {
                    t.setStackTrace(this.trimArray(testResult.getStack().split("\\u000d")));
                    testCase.addOutputLines(Arrays.asList(testResult.getStack().split("\\u000d")));
                }
                if (testResult.getMessage().length() > 0) {
                    // empty if block
                }
                if (testResult.getLog().length() > 0) {
                    // empty if block
                }
                testCase.setTrouble(t);
            }
            this.testSession.addTestCase(testCase);
            this.report.update(this.testSession.getReport(0L));
            this.manager.displayReport(this.testSession, this.report, false);
        }

        private Status convert(TestListener.TestResult.Result res) {
            switch (res) {
                case passed: {
                    return Status.PASSED;
                }
                case failed: {
                    return Status.FAILED;
                }
                case error: {
                    return Status.ERROR;
                }
                case started: {
                    return Status.PENDING;
                }
            }
            throw new AssertionError((Object)res.name());
        }

        public void onTestingFinished() {
            this.manager.sessionFinished(this.testSession);
            if (this.report == null) {
                this.testSession.addSuite(TestSuite.ANONYMOUS_TEST_SUITE);
                this.report = this.testSession.getReport(0L);
            }
            this.manager.displayReport(this.testSession, this.report, true);
        }

        private String[] trimArray(String[] split) {
            if (split == null) {
                return null;
            }
            ArrayList<String> r = new ArrayList<String>();
            for (int i = 0; i < split.length; ++i) {
                String s = split[i].trim();
                if (s.length() <= 0) continue;
                r.add(s);
            }
            return r.toArray(new String[r.size()]);
        }
    }

    private static class ListenerImpl
    implements OutputListener {
        private FileObject fo;
        private int line;
        private int column;

        public ListenerImpl(FileObject fo, int line, int column) {
            this.fo = fo;
            this.line = line;
            this.column = column;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            Line l = this.getLine();
            if (l != null) {
                l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.column != -1 ? this.column - 1 : -1);
            }
        }

        private Line getLine() {
            LineCookie result = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)this.fo);
                if (dataObject != null) {
                    result = (LineCookie)dataObject.getCookie(LineCookie.class);
                }
            }
            catch (DataObjectNotFoundException e) {
                e.printStackTrace();
            }
            if (result != null) {
                return result.getLineSet().getCurrent(this.line - 1);
            }
            return null;
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public boolean isValidHyperlink() {
            return this.getLine() != null;
        }
    }

    private static class LineConvertorImpl
    implements LineConvertor {
        private Project p;

        public LineConvertorImpl(Project p) {
            this.p = p;
        }

        public List<ConvertedLine> convert(String line) {
            if (!line.endsWith(")")) {
                return this.convertLineURL(line);
            }
            int start = line.lastIndexOf(40);
            if (start == -1) {
                return null;
            }
            int lineNumberEnd = line.lastIndexOf(58);
            if (lineNumberEnd == -1) {
                return null;
            }
            int fileEnd = line.lastIndexOf(58, lineNumberEnd - 1);
            if (fileEnd == -1) {
                return null;
            }
            if (start >= fileEnd) {
                return null;
            }
            int lineNumber = -1;
            int columnNumber = -1;
            try {
                lineNumber = Integer.parseInt(line.substring(fileEnd + 1, lineNumberEnd));
                columnNumber = Integer.parseInt(line.substring(lineNumberEnd + 1, line.length() - 1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (columnNumber != -1 && lineNumber == -1) {
                lineNumber = columnNumber;
            }
            if (lineNumber == -1) {
                return null;
            }
            String file = line.substring(start + 1, fileEnd);
            if (file.length() == 0) {
                return null;
            }
            FileObject fo = this.p.getProjectDirectory().getFileObject(file);
            if (fo == null) {
                return null;
            }
            ArrayList<ConvertedLine> res = new ArrayList<ConvertedLine>();
            ListenerImpl l = new ListenerImpl(fo, lineNumber, columnNumber);
            res.add(ConvertedLine.forText((String)line, (OutputListener)(l.isValidHyperlink() ? l : null)));
            return res;
        }

        private List<ConvertedLine> convertLineURL(String line) {
            int col2;
            int u1 = line.indexOf("http://");
            if (u1 < 0) {
                u1 = line.indexOf("https://");
            }
            if (u1 < 0) {
                return null;
            }
            int ue = line.indexOf(32, u1);
            if (ue < 0) {
                ue = line.length();
            }
            if ((col2 = line.lastIndexOf(58, ue)) < 0) {
                return null;
            }
            int col1 = line.lastIndexOf(58, col2 - 1);
            if (col1 < 0) {
                return null;
            }
            int lineNumber = -1;
            int columnNumber = -1;
            try {
                lineNumber = Integer.parseInt(line.substring(col1 + 1, col2));
                columnNumber = Integer.parseInt(line.substring(col2 + 1, ue));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (columnNumber != -1 && lineNumber == -1) {
                lineNumber = columnNumber;
            }
            if (lineNumber == -1) {
                return null;
            }
            String file = line.substring(u1, col1);
            if (file.length() == 0) {
                return null;
            }
            FileObject fo = null;
            try {
                URL url = URI.create(file).toURL();
                fo = ServerURLMapping.fromServer((Project)this.p, (URL)url);
                if (fo == null) {
                    fo = RemoteFileCache.getRemoteFile((URL)url);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (fo == null) {
                return null;
            }
            ArrayList<ConvertedLine> res = new ArrayList<ConvertedLine>();
            ListenerImpl l = new ListenerImpl(fo, lineNumber, columnNumber);
            res.add(ConvertedLine.forText((String)line, (OutputListener)(l.isValidHyperlink() ? l : null)));
            return res;
        }
    }
}

