/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.SourceVersion;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintRegistry;
import org.netbeans.modules.java.hints.declarative.test.TestParser;
import org.netbeans.modules.java.hints.jackpot.spi.HintsRunner;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class TestPerformer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static Map<TestParser.TestCase, Collection<String>> performTest(FileObject ruleFile, FileObject test, TestParser.TestCase[] tests, AtomicBoolean cancel) throws Exception {
        try {
            Map<TestParser.TestCase, Collection<String>> map = TestPerformer.performTestImpl(ruleFile, test, tests, cancel);
            return map;
        }
        finally {
            TestPerformer.setData(null, null, null);
        }
    }

    public static String normalize(String text) {
        return text.replaceAll("[ \t\n]+", " ");
    }

    private static File createScratchpadDir() throws IOException {
        String userdir = System.getProperty("netbeans.user");
        assert (userdir != null);
        File varTmp = new File(new File(new File(userdir), "var"), "tmp");
        varTmp.mkdirs();
        assert (varTmp.isDirectory());
        File sp = File.createTempFile("jackpot", "", varTmp);
        sp.delete();
        sp.mkdir();
        assert (sp.isDirectory());
        return sp;
    }

    private static Map<TestParser.TestCase, Collection<String>> performTestImpl(FileObject ruleFile, FileObject test, TestParser.TestCase[] tests, final AtomicBoolean cancel) throws Exception {
        final LinkedList<? extends HintDescription> hints = new LinkedList<HintDescription>();
        for (Collection<? extends HintDescription> descs : DeclarativeHintRegistry.parseHintFile(ruleFile).values()) {
            hints.addAll(descs);
        }
        FileObject scratchPad = FileUtil.toFileObject((File)TestPerformer.createScratchpadDir());
        HashMap<TestParser.TestCase, Collection<String>> result = new HashMap<TestParser.TestCase, Collection<String>>();
        for (int cntr = 0; cntr < tests.length; ++cntr) {
            FileObject srcRoot = scratchPad.createFolder("src" + cntr);
            FileObject src = FileUtil.createData((FileObject)srcRoot, (String)"test/Test.java");
            TestPerformer.setData(test, srcRoot, tests[cntr].getSourceLevel());
            TestPerformer.copyStringToFile(src, tests[cntr].getCode());
            final LinkedList errors = new LinkedList();
            JavaSource.forFileObject((FileObject)src).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    TreeMap sortedByHintDescription = new TreeMap(new Comparator<HintDescription>(){

                        @Override
                        public int compare(HintDescription o1, HintDescription o2) {
                            return hints.indexOf(o1) - hints.indexOf(o2);
                        }
                    });
                    Map computedHints = HintsRunner.computeErrors((CompilationInfo)parameter, (Iterable)hints, (AtomicBoolean)cancel);
                    if (computedHints == null || cancel.get()) {
                        return;
                    }
                    sortedByHintDescription.putAll(computedHints);
                    for (Map.Entry e : sortedByHintDescription.entrySet()) {
                        errors.addAll((Collection)e.getValue());
                    }
                }
            }, true);
            if (cancel.get()) {
                return null;
            }
            LinkedList<String> currentResults = new LinkedList<String>();
            result.put(tests[cntr], currentResults);
            for (ErrorDescription ed : errors) {
                if (!ed.getFixes().isComputed()) {
                    throw new UnsupportedOperationException();
                }
                for (Fix f : ed.getFixes().getFixes()) {
                    if (f.getClass().getName().equals("org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory$TopLevelConfigureFix") || f.getClass().getName().equals("org.netbeans.spi.java.hints.ErrorDescriptionFactory$TopLevelConfigureFix")) continue;
                    currentResults.add(TestPerformer.getFixResult(src, f));
                }
                if (!currentResults.isEmpty()) continue;
                currentResults.add(ed.getDescription() + ":" + ed.getRange().getText() + "\n");
            }
        }
        scratchPad.delete();
        return result;
    }

    private static final FileObject copyStringToFile(FileObject f, String content) throws Exception {
        OutputStream os = f.getOutputStream();
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes("UTF-8"));
        FileUtil.copy((InputStream)is, (OutputStream)os);
        os.close();
        ((InputStream)is).close();
        return f;
    }

    private static void setData(FileObject from, FileObject sourceRoot, SourceVersion sourceLevel) {
        for (ClassPathProvider cpp : Lookup.getDefault().lookupAll(ClassPathProvider.class)) {
            if (!(cpp instanceof TestClassPathProvider)) continue;
            ((TestClassPathProvider)cpp).setData(from, sourceRoot, sourceLevel);
        }
    }

    private static String getFixResult(FileObject src, Fix fix) throws Exception {
        String original = TestPerformer.getText(src);
        fix.implement();
        String nue = TestPerformer.getText(src);
        TestPerformer.copyStringToFile(src, original);
        return nue;
    }

    private static String getText(FileObject file) throws IOException {
        Charset encoding = FileEncodingQuery.getEncoding((FileObject)file);
        return new String(file.asBytes(), encoding);
    }

    public static final class TestClassPathProvider
    implements ClassPathProvider,
    SourceLevelQueryImplementation {
        private FileObject from;
        private FileObject sourceRoot;
        private String sourceLevel;

        public synchronized ClassPath findClassPath(FileObject file, String type) {
            if (this.from == null) {
                return null;
            }
            if (this.sourceRoot.equals(file) || FileUtil.isParentOf((FileObject)this.sourceRoot, (FileObject)file)) {
                return ClassPath.getClassPath((FileObject)this.from, (String)type);
            }
            return null;
        }

        synchronized void setData(FileObject from, FileObject sourceRoot, SourceVersion sourceLevel) {
            this.from = from;
            this.sourceRoot = sourceRoot;
            this.sourceLevel = sourceLevel != null ? "1." + sourceLevel.name().substring("RELEASE_".length()) : null;
        }

        public String getSourceLevel(FileObject file) {
            if (this.from == null) {
                return null;
            }
            if (this.sourceRoot.equals(file) || FileUtil.isParentOf((FileObject)this.sourceRoot, (FileObject)file)) {
                return this.sourceLevel;
            }
            return null;
        }
    }
}

