/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.versioning.Accessor;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSAnnotator;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.netbeans.modules.versioning.core.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.core.util.Utils;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.netbeans.spi.queries.CollocationQueryImplementation2;
import org.openide.util.ContextAwareAction;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class DelegatingVCS
extends org.netbeans.modules.versioning.core.spi.VersioningSystem
implements VCSSystemProvider.VersioningSystem<VersioningSystem> {
    private final Map<?, ?> map;
    private VersioningSystem delegate;
    private Set<String> metadataFolderNames;
    private final Object DELEGATE_LOCK = new Object();
    private final String displayName;
    private final String menuLabel;
    private static final Logger LOG = Logger.getLogger(DelegatingVCS.class.getName());
    private final PropertyChangeSupport support = new PropertyChangeSupport((Object)this);
    private final Set<VCSFileProxy> unversionedParents = Collections.synchronizedSet(new HashSet(20));
    private VCSAnnotator annotator;
    private VCSVisibilityQuery visibilityQuery;
    private VCSInterceptor interceptor;
    private CollocationQueryImplementation2 collocationQuery;
    private VCSHistoryProvider historyProvider;

    public static DelegatingVCS create(Map<?, ?> map) {
        return new DelegatingVCS(map);
    }

    private DelegatingVCS(Map<?, ?> map) {
        this.map = map;
        this.displayName = (String)map.get("displayName");
        this.menuLabel = (String)map.get("menuLabel");
        LOG.log(Level.FINE, "Created DelegatingVCS for : {0}", map.get("displayName"));
    }

    public DelegatingVCS(VersioningSystem vs) {
        this.map = null;
        this.displayName = (String)vs.getProperty("String VCS.DisplayName");
        this.menuLabel = (String)vs.getProperty("String VCS.MenuLabel");
        this.delegate = vs;
        LOG.log(Level.FINE, "Created DelegatingVCS for : {0}", this.displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersioningSystem getDelegate() {
        Object object = this.DELEGATE_LOCK;
        synchronized (object) {
            if (this.delegate == null) {
                Utils.flushNullOwners();
                this.delegate = (VersioningSystem)this.map.get("delegate");
                if (this.delegate != null) {
                    PropertyChangeListener[] listeners;
                    for (PropertyChangeListener l : listeners = this.support.getPropertyChangeListeners()) {
                        this.delegate.addPropertyChangeListener(l);
                        this.support.removePropertyChangeListener(l);
                    }
                } else {
                    LOG.log(Level.WARNING, "Couldn't create delegate for : {0}", this.map.get("displayName"));
                }
                this.unversionedParents.clear();
            }
            return this.delegate;
        }
    }

    public void getOriginalFile(VCSFileProxy workingCopy, VCSFileProxy originalFile) {
        this.getDelegate().getOriginalFile(workingCopy.toFile(), originalFile.toFile());
    }

    public CollocationQueryImplementation2 getCollocationQueryImplementation() {
        if (this.collocationQuery == null) {
            this.collocationQuery = new CollocationQueryImplementation2(){
                private CollocationQueryImplementation cqi;
                {
                    this.cqi = DelegatingVCS.this.getDelegate().getCollocationQueryImplementation();
                }

                public boolean areCollocated(URI uri1, URI uri2) {
                    return this.cqi != null && this.cqi.areCollocated(Utilities.toFile((URI)uri1), Utilities.toFile((URI)uri2));
                }

                public URI findRoot(URI uri) {
                    File file = this.cqi != null ? this.cqi.findRoot(Utilities.toFile((URI)uri)) : null;
                    return file != null ? Utilities.toURI((File)file) : null;
                }
            };
        }
        return this.collocationQuery;
    }

    public VCSFileProxy getTopmostManagedAncestor(VCSFileProxy proxy) {
        if (!this.isAlive()) {
            if (this.getMetadataFolderNames().contains(proxy.getName()) && proxy.isDirectory()) {
                LOG.log(Level.FINE, "will awake VCS {0} because of metadata folder {1}", new Object[]{this.displayName, proxy});
                return this.getTopmostManagedAncestorImpl(proxy);
            }
            if (this.hasMetadata(proxy)) {
                LOG.log(Level.FINE, "will awake VCS {0} because {1} contains matadata", new Object[]{this.displayName, proxy});
                return this.getTopmostManagedAncestorImpl(proxy);
            }
        } else {
            return this.getTopmostManagedAncestorImpl(proxy);
        }
        return null;
    }

    public boolean isLocalHistory() {
        if (!this.isAlive()) {
            return false;
        }
        return this.getDelegate().getProperty("Boolean VCS.LocalHistory") != null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMenuLabel() {
        return this.menuLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyCL(PropertyChangeListener listener) {
        Object object = this.DELEGATE_LOCK;
        synchronized (object) {
            if (this.delegate == null) {
                this.support.addPropertyChangeListener(listener);
            } else {
                this.delegate.addPropertyChangeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyCL(PropertyChangeListener listener) {
        Object object = this.DELEGATE_LOCK;
        synchronized (object) {
            if (this.delegate == null) {
                this.support.removePropertyChangeListener(listener);
            } else {
                this.delegate.removePropertyChangeListener(listener);
            }
        }
    }

    public boolean isExcluded(VCSFileProxy file) {
        return VersioningSupport.isExcluded(file.toFile());
    }

    public VCSAnnotator getVCSAnnotator() {
        if (this.annotator == null && this.getDelegate().getVCSAnnotator() != null) {
            this.annotator = new VCSAnnotator(){

                public String annotateName(String name, VCSContext context) {
                    assert (DelegatingVCS.this.accept(context));
                    return DelegatingVCS.this.getDelegate().getVCSAnnotator().annotateName(name, Accessor.IMPL.createVCSContext(context));
                }

                public Image annotateIcon(Image icon, VCSContext context) {
                    assert (DelegatingVCS.this.accept(context));
                    return DelegatingVCS.this.getDelegate().getVCSAnnotator().annotateIcon(icon, Accessor.IMPL.createVCSContext(context));
                }

                public Action[] getActions(VCSContext context, VCSAnnotator.ActionDestination destination) {
                    VCSAnnotator.ActionDestination ad;
                    if (!DelegatingVCS.this.accept(context)) {
                        return new Action[0];
                    }
                    switch (destination) {
                        case MainMenu: {
                            ad = VCSAnnotator.ActionDestination.MainMenu;
                            break;
                        }
                        case PopupMenu: {
                            ad = VCSAnnotator.ActionDestination.PopupMenu;
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    return DelegatingVCS.this.getDelegate().getVCSAnnotator().getActions(Accessor.IMPL.createVCSContext(context), ad);
                }
            };
        }
        return this.annotator;
    }

    public VCSVisibilityQuery getVisibilityQuery() {
        if (this.visibilityQuery == null && this.getDelegate().getVisibilityQuery() != null) {
            this.visibilityQuery = new VCSVisibilityQuery(){

                public boolean isVisible(VCSFileProxy proxy) {
                    return DelegatingVCS.this.getDelegate().getVisibilityQuery().isVisible(proxy.toFile());
                }
            };
        }
        return this.visibilityQuery;
    }

    public VCSInterceptor getVCSInterceptor() {
        if (this.interceptor == null && this.getDelegate().getVCSInterceptor() != null) {
            this.interceptor = new VCSInterceptor(){

                public boolean isMutable(VCSFileProxy file) {
                    return DelegatingVCS.this.getDelegate().getVCSInterceptor().isMutable(file.toFile());
                }

                public Object getAttribute(VCSFileProxy file, String attrName) {
                    return DelegatingVCS.this.getDelegate().getVCSInterceptor().getAttribute(file.toFile(), attrName);
                }

                public boolean beforeDelete(VCSFileProxy file) {
                    return DelegatingVCS.this.getDelegate().getVCSInterceptor().beforeDelete(file.toFile());
                }

                public void doDelete(VCSFileProxy file) throws IOException {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().doDelete(file.toFile());
                }

                public void afterDelete(VCSFileProxy file) {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().afterDelete(file.toFile());
                }

                public boolean beforeMove(VCSFileProxy from, VCSFileProxy to) {
                    return DelegatingVCS.this.getDelegate().getVCSInterceptor().beforeMove(from.toFile(), to.toFile());
                }

                public void doMove(VCSFileProxy from, VCSFileProxy to) throws IOException {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().doMove(from.toFile(), to.toFile());
                }

                public void afterMove(VCSFileProxy from, VCSFileProxy to) {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().afterMove(from.toFile(), to.toFile());
                }

                public boolean beforeCopy(VCSFileProxy from, VCSFileProxy to) {
                    return DelegatingVCS.this.getDelegate().getVCSInterceptor().beforeCopy(from.toFile(), to.toFile());
                }

                public void doCopy(VCSFileProxy from, VCSFileProxy to) throws IOException {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().doCopy(from.toFile(), to.toFile());
                }

                public void afterCopy(VCSFileProxy from, VCSFileProxy to) {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().afterCopy(from.toFile(), to.toFile());
                }

                public boolean beforeCreate(VCSFileProxy file, boolean isDirectory) {
                    return DelegatingVCS.this.getDelegate().getVCSInterceptor().beforeCreate(file.toFile(), isDirectory);
                }

                public void doCreate(VCSFileProxy file, boolean isDirectory) throws IOException {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().doCreate(file.toFile(), isDirectory);
                }

                public void afterCreate(VCSFileProxy file) {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().afterCreate(file.toFile());
                }

                public void afterChange(VCSFileProxy file) {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().afterChange(file.toFile());
                }

                public void beforeChange(VCSFileProxy file) {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().beforeChange(file.toFile());
                }

                public void beforeEdit(VCSFileProxy file) {
                    DelegatingVCS.this.getDelegate().getVCSInterceptor().beforeEdit(file.toFile());
                }

                public long refreshRecursively(VCSFileProxy dir, long lastTimeStamp, List<? super VCSFileProxy> children) {
                    ArrayList<File> files = new ArrayList<File>(children.size());
                    for (VCSFileProxy vCSFileProxy : children) {
                        files.add(vCSFileProxy.toFile());
                    }
                    return DelegatingVCS.this.getDelegate().getVCSInterceptor().refreshRecursively(dir.toFile(), lastTimeStamp, files);
                }
            };
        }
        return this.interceptor;
    }

    public VCSHistoryProvider getVCSHistoryProvider() {
        if (this.historyProvider == null && this.getDelegate().getVCSHistoryProvider() != null) {
            this.historyProvider = new DelegatingHistoryProvider();
        }
        return this.historyProvider;
    }

    public boolean accept(VCSContext ctx) {
        Set roots = ctx.getRootFiles();
        for (VCSFileProxy root : roots) {
            if (this.accept(root)) continue;
            return false;
        }
        return true;
    }

    private boolean accept(VCSFileProxy root) {
        return root.toFile() != null;
    }

    public boolean isMetadataFile(VCSFileProxy file) {
        if (this.map == null) {
            return false;
        }
        return this.getMetadataFolderNames().contains(file.getName());
    }

    private Collection<String> getMetadataFolderNames() {
        if (this.metadataFolderNames == null) {
            String name;
            this.metadataFolderNames = new HashSet<String>();
            int i = 0;
            while ((name = (String)this.map.get("metadataFolderName" + i++)) != null) {
                if ((name = this.parseName(name)) == null) continue;
                this.metadataFolderNames.add(name);
            }
        }
        return this.metadataFolderNames;
    }

    private Action[] getActions(VCSContext ctx, VCSAnnotator.ActionDestination actionDestination) {
        if (this.map == null || this.isAlive()) {
            VCSAnnotator tmp = this.getVCSAnnotator();
            return tmp != null ? tmp.getActions(ctx, actionDestination) : new Action[]{};
        }
        Action[] ia = this.getInitActions(ctx);
        Action[] ga = this.getGlobalActions(ctx);
        ArrayList<Action> l = new ArrayList<Action>(ia.length + ga.length + 1);
        l.addAll(Arrays.asList(ia));
        if (ga.length > 0 && ia.length > 0 && l.get(l.size() - 1) != null) {
            l.add(null);
        }
        l.addAll(Arrays.asList(ga));
        return l.toArray(new Action[l.size()]);
    }

    Action[] getGlobalActions(VCSContext ctx) {
        assert (!this.isAlive());
        String category = (String)this.map.get("actionsCategory");
        List l = Utilities.actionsForPath((String)("Versioning/" + category + "/Actions/Global"));
        ArrayList<Action> ret = new ArrayList<Action>(l.size());
        for (Action action : l) {
            if (action instanceof ContextAwareAction) {
                ret.add(((ContextAwareAction)action).createContextAwareInstance(Lookups.singleton((Object)ctx)));
                continue;
            }
            ret.add(action);
        }
        return ret != null ? ret.toArray(new Action[ret.size()]) : new Action[]{};
    }

    Action[] getInitActions(VCSContext ctx) {
        String category = (String)this.map.get("actionsCategory");
        List l = Utilities.actionsForPath((String)("Versioning/" + category + "/Actions/Unversioned"));
        ArrayList<Action> ret = new ArrayList<Action>(l.size());
        for (Action action : l) {
            if (action instanceof ContextAwareAction) {
                ret.add(((ContextAwareAction)action).createContextAwareInstance(Lookups.singleton((Object)ctx)));
                continue;
            }
            ret.add(action);
        }
        return ret.toArray(new Action[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlive() {
        Object object = this.DELEGATE_LOCK;
        synchronized (object) {
            return this.delegate != null;
        }
    }

    private boolean hasMetadata(VCSFileProxy file) {
        if (file == null) {
            return false;
        }
        LOG.log(Level.FINE, "looking up metadata for {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            LOG.fine(" cached as unversioned");
            return false;
        }
        boolean ret = false;
        HashSet<VCSFileProxy> done = new HashSet<VCSFileProxy>();
        block0: for (String folderName : this.getMetadataFolderNames()) {
            for (VCSFileProxy parent = file.isDirectory() ? file : file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                if (this.unversionedParents.contains(parent)) {
                    LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                    continue block0;
                }
                boolean metadataFolder = VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)folderName).exists();
                if (metadataFolder) {
                    LOG.log(Level.FINER, "found metadata folder {0} for file {1}", new Object[]{metadataFolder, file});
                    ret = true;
                    continue;
                }
                done.add(parent);
            }
        }
        if (!ret) {
            LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        if (this.map != null) {
            Object object = this.DELEGATE_LOCK;
            synchronized (object) {
                this.delegate = null;
            }
        }
    }

    private String parseName(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.indexOf(":");
        if (idx < 0) {
            return name;
        }
        String[] cmd = name.split(":");
        if (cmd.length != 4 || !cmd[1].contains("getenv")) {
            return name;
        }
        assert (cmd[3].equals("notnull") || cmd[3].equals("null"));
        boolean notnull = cmd[3].trim().equals("notnull");
        if (notnull) {
            return System.getenv(cmd[2]) != null ? cmd[0] : null;
        }
        return System.getenv(cmd[2]) == null ? cmd[0] : null;
    }

    private VCSFileProxy getTopmostManagedAncestorImpl(VCSFileProxy proxy) {
        File file = proxy.toFile();
        if (file == null) {
            return null;
        }
        File f = this.getDelegate().getTopmostManagedAncestor(file);
        if (f != null) {
            return VCSFileProxy.createFileProxy((File)f);
        }
        return null;
    }

    private File[] toFiles(VCSFileProxy[] proxies) {
        File[] files = new File[proxies.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = proxies[i].toFile();
            assert (files[i] != null);
        }
        return files;
    }

    private VCSFileProxy[] toProxies(File[] files) {
        VCSFileProxy[] proxies = new VCSFileProxy[files.length];
        for (int i = 0; i < files.length; ++i) {
            assert (files[i] != null);
            if (files[i] == null) continue;
            proxies[i] = VCSFileProxy.createFileProxy((File)files[i]);
        }
        return proxies;
    }

    private class DelegatingHistoryProvider
    implements VCSHistoryProvider {
        private DelegatingHistoryProvider() {
        }

        public void addHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
            DelegatingVCS.this.getDelegate().getVCSHistoryProvider().addHistoryChangeListener(new DelegateChangeListener(l));
        }

        public void removeHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
            DelegatingVCS.this.getDelegate().getVCSHistoryProvider().removeHistoryChangeListener(new DelegateChangeListener(l));
        }

        public VCSHistoryProvider.HistoryEntry[] getHistory(VCSFileProxy[] proxies, Date fromDate) {
            File[] files = DelegatingVCS.this.toFiles(proxies);
            VCSHistoryProvider.HistoryEntry[] history = DelegatingVCS.this.getDelegate().getVCSHistoryProvider().getHistory(files, fromDate);
            if (history == null) {
                return new VCSHistoryProvider.HistoryEntry[0];
            }
            VCSHistoryProvider.HistoryEntry[] proxyHistory = new VCSHistoryProvider.HistoryEntry[history.length];
            for (int i = 0; i < proxyHistory.length; ++i) {
                VCSHistoryProvider.HistoryEntry he = history[i];
                proxyHistory[i] = this.delegateHistoryEntry(proxies, he);
            }
            return proxyHistory;
        }

        public Action createShowHistoryAction(VCSFileProxy[] proxies) {
            File[] files = DelegatingVCS.this.toFiles(proxies);
            return DelegatingVCS.this.getDelegate().getVCSHistoryProvider().createShowHistoryAction(files);
        }

        private VCSHistoryProvider.MessageEditProvider delegateMessageEditProvider(final VCSHistoryProvider.HistoryEntry he) {
            if (he.canEdit()) {
                return new VCSHistoryProvider.MessageEditProvider(){

                    public void setMessage(String message) throws IOException {
                        VCSHistoryProvider.MessageEditProvider provider = Accessor.IMPL.getMessageEditProvider(he);
                        if (provider != null) {
                            provider.setMessage(message);
                        }
                    }
                };
            }
            return null;
        }

        private VCSHistoryProvider.RevisionProvider delegateRevisionProvider(final VCSHistoryProvider.HistoryEntry he) {
            return new VCSHistoryProvider.RevisionProvider(){

                public void getRevisionFile(VCSFileProxy originalFile, VCSFileProxy revisionFile) {
                    VCSHistoryProvider.RevisionProvider provider = Accessor.IMPL.getRevisionProvider(he);
                    if (provider != null) {
                        File of = originalFile.toFile();
                        File rf = revisionFile.toFile();
                        if (of != null && rf != null) {
                            provider.getRevisionFile(of, rf);
                        }
                    }
                }
            };
        }

        private VCSHistoryProvider.ParentProvider delegateParentProvider(final VCSHistoryProvider.HistoryEntry he) {
            return new VCSHistoryProvider.ParentProvider(){

                public VCSHistoryProvider.HistoryEntry getParentEntry(VCSFileProxy file) {
                    VCSHistoryProvider.HistoryEntry he2;
                    VCSHistoryProvider.ParentProvider provider = Accessor.IMPL.getParentProvider(he);
                    if (provider != null && (he2 = provider.getParentEntry(file.toFile())) != null) {
                        return DelegatingHistoryProvider.this.delegateHistoryEntry(DelegatingVCS.this.toProxies(he2.getFiles()), he2);
                    }
                    return null;
                }
            };
        }

        private VCSHistoryProvider.HistoryEntry delegateHistoryEntry(VCSFileProxy[] proxies, VCSHistoryProvider.HistoryEntry he) {
            return Utils.createHistoryEntry((VCSFileProxy[])proxies, (Date)he.getDateTime(), (String)he.getMessage(), (String)he.getUsername(), (String)he.getUsernameShort(), (String)he.getRevision(), (String)he.getRevisionShort(), (Action[])he.getActions(), (VCSHistoryProvider.RevisionProvider)this.delegateRevisionProvider(he), (VCSHistoryProvider.MessageEditProvider)this.delegateMessageEditProvider(he), (VCSHistoryProvider.ParentProvider)this.delegateParentProvider(he), (Object[])new Object[]{he});
        }

        private class DelegateChangeListener
        implements VCSHistoryProvider.HistoryChangeListener {
            private final VCSHistoryProvider.HistoryChangeListener delegate;

            public DelegateChangeListener(VCSHistoryProvider.HistoryChangeListener delegate) {
                this.delegate = delegate;
            }

            @Override
            public void fireHistoryChanged(VCSHistoryProvider.HistoryEvent evt) {
                this.delegate.fireHistoryChanged(new VCSHistoryProvider.HistoryEvent((VCSHistoryProvider)DelegatingHistoryProvider.this, DelegatingVCS.this.toProxies(evt.getFiles())));
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof DelegateChangeListener)) {
                    return false;
                }
                DelegateChangeListener d = (DelegateChangeListener)obj;
                return d.delegate.equals(this.delegate);
            }

            public int hashCode() {
                int hash = 3;
                hash = 89 * hash + (this.delegate != null ? this.delegate.hashCode() : 0);
                return hash;
            }
        }
    }
}

