/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import javax.swing.SwingUtilities;

public class PriorityMutex {
    private Thread lockThread;
    private int lockDepth;
    private Thread waitingPriorityThread;

    public synchronized void lock() {
        Thread thread = Thread.currentThread();
        try {
            if (thread != this.lockThread) {
                while (this.lockThread != null || this.waitingPriorityThread != null && this.waitingPriorityThread != thread) {
                    if (this.waitingPriorityThread == null && this.isPriorityThread()) {
                        this.waitingPriorityThread = thread;
                    }
                    this.wait();
                }
                this.lockThread = thread;
                assert (this.lockDepth == 0);
                if (thread == this.waitingPriorityThread) {
                    this.waitingPriorityThread = null;
                }
            }
            ++this.lockDepth;
        }
        catch (InterruptedException e) {
            this.waitingPriorityThread = null;
            throw new Error("Interrupted mutex acquiring");
        }
    }

    public synchronized void unlock() {
        if (Thread.currentThread() != this.lockThread) {
            throw new IllegalStateException("Not locker. lockThread=" + this.lockThread);
        }
        if (--this.lockDepth == 0) {
            this.lockThread = null;
            this.notifyAll();
        }
    }

    public boolean isPriorityThreadWaiting() {
        return this.waitingPriorityThread != null;
    }

    public final synchronized Thread getLockThread() {
        return this.lockThread;
    }

    protected boolean isPriorityThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public String toString() {
        return "lockThread=" + this.lockThread + ", lockDepth=" + this.lockDepth;
    }
}

