/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mobility.end2end.classdata.AbstractService;
import org.netbeans.modules.mobility.end2end.classdata.ClassService;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class WebApplicationPanel
extends JPanel
implements ChangeListener,
ActionListener,
DocumentListener {
    private Project enterpriseProject;
    WebProjectsActionListener webProjectsActionListener = new WebProjectsActionListener();
    private final ArrayList<ChangeListener> listeners = new ArrayList();
    private static final String CLIENT_NAME = "WebToMobileServlet";
    private Project project;
    private ModelItem[] groupItems;
    private String expectedExtension;
    private boolean isPackage;
    private SourceGroup[] folders;
    private String clientTypeSelection;
    private static String openProject = NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Open_WebProject");
    private static String noProject = NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_No_WebProject");
    private static final String DEFAULT_NEW_PACKAGE_NAME = NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_JavaTargetChooserPanelGUI_DefaultNewPackageName");
    private static final ListCellRenderer CELL_RENDERER = new NodeCellRenderer();
    private JRadioButton clientToWebAppRadio;
    private JRadioButton clientToWebServiceRadio;
    private ButtonGroup clientTypeButtonGroup;
    private JTextField documentNameTextField;
    private JComboBox enterpriseProjectsComboBox;
    private JTextField fileTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JComboBox packageComboBox;
    private JComboBox rootComboBox;
    private JComboBox serviceCombo;

    public static WebApplicationPanelWizard create() {
        return new WebApplicationPanelWizard();
    }

    public WebApplicationPanel() {
        this.initComponents();
        this.setName(NbBundle.getMessage(WebApplicationPanel.class, (String)"TITLE_clientTypeStep"));
        this.setValues();
        this.clientTypeButtonGroup.add(this.clientToWebAppRadio);
        this.clientTypeButtonGroup.add(this.clientToWebServiceRadio);
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSN_Web_Application_Panel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Web_Application_Panel"));
        this.enterpriseProjectsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Web_Application_Panel"));
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Servlet_Name"));
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Location"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Server_Package"));
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Server_Created_File"));
        this.clientToWebAppRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_LBL_ClassClientType"));
        this.clientToWebServiceRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_WebServiceClientType"));
    }

    private void setValues() {
        Sources sources = null;
        DefaultComboBoxModel<Project> projectsModel = new DefaultComboBoxModel<Project>(this.getEnterpriseProjects());
        this.enterpriseProjectsComboBox.setModel(projectsModel);
        this.enterpriseProjectsComboBox.setRenderer(new ProjectCellRenderer());
        this.serviceCombo.setRenderer(new ServiceCellRenderer());
        if (projectsModel.getSize() == 0) {
            projectsModel.addElement((Project)noProject);
            this.setServletPanelEnabled(false);
            this.updateWebServices(null);
        } else {
            if (this.enterpriseProject == null) {
                this.enterpriseProject = projectsModel.getElementAt(0);
            }
            this.updateWebServices(this.enterpriseProject);
            this.enterpriseProjectsComboBox.setSelectedItem(this.enterpriseProject);
            sources = ProjectUtils.getSources((Project)this.enterpriseProject);
            sources.getSourceGroups("java");
            this.rootComboBox.setRenderer(CELL_RENDERER);
            this.packageComboBox.setRenderer(CELL_RENDERER);
            this.rootComboBox.addActionListener(this);
            this.initValues(CLIENT_NAME, this.enterpriseProject);
        }
        projectsModel.addElement((Project)openProject);
        Component packageEditor = this.packageComboBox.getEditor().getEditorComponent();
        ((JTextField)packageEditor).getDocument().addDocumentListener(this);
        this.packageComboBox.addActionListener(this);
        this.enterpriseProjectsComboBox.addActionListener(this.webProjectsActionListener);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.clientToWebServiceRadio.addActionListener(this);
        this.clientToWebAppRadio.addActionListener(this);
        this.clientToWebServiceRadio.addChangeListener(this);
        this.clientToWebAppRadio.addChangeListener(this);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(e);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateText();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.rootComboBox == e.getSource()) {
            this.updatePackages();
            this.updateText();
        } else if (this.packageComboBox == e.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox.getEditor() == e.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.clientToWebAppRadio == e.getSource() || this.clientToWebServiceRadio == e.getSource()) {
            this.clientTypeSelection = e.getActionCommand();
        }
    }

    private void initComponents() {
        this.clientTypeButtonGroup = new ButtonGroup();
        this.jLabel7 = new JLabel();
        this.jLabel1 = new JLabel();
        this.enterpriseProjectsComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.rootComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.packageComboBox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.fileTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.clientToWebAppRadio = new JRadioButton();
        this.clientToWebServiceRadio = new JRadioButton();
        this.serviceCombo = new JComboBox();
        this.jPanel2 = new JPanel();
        this.setPreferredSize(new Dimension(560, 350));
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/mobility/end2end/ui/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)bundle.getString("LBL_Title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel1.setLabelFor(this.enterpriseProjectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Web_Application"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 1, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.enterpriseProjectsComboBox, gridBagConstraints);
        this.jLabel2.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Servlet_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.documentNameTextField, gridBagConstraints);
        this.jLabel3.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.jLabel4.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Server_Package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        this.jLabel5.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Server_Created_File"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 189;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 1, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_ServiceTypeSelection"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.clientTypeButtonGroup.add(this.clientToWebAppRadio);
        this.clientToWebAppRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.clientToWebAppRadio, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_ClassClientType"));
        this.clientToWebAppRadio.setActionCommand("class");
        this.clientToWebAppRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientToWebAppRadio.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.jPanel1.add((Component)this.clientToWebAppRadio, gridBagConstraints);
        this.clientTypeButtonGroup.add(this.clientToWebServiceRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.clientToWebServiceRadio, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_WebServiceClientType"));
        this.clientToWebServiceRadio.setActionCommand("wsdlClient");
        this.clientToWebServiceRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientToWebServiceRadio.setMargin(new Insets(0, 0, 0, 0));
        this.clientToWebServiceRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WebApplicationPanel.this.clientToWebServiceRadioStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 11, 5, 6);
        this.jPanel1.add((Component)this.clientToWebServiceRadio, gridBagConstraints);
        this.serviceCombo.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.serviceCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void clientToWebServiceRadioStateChanged(ChangeEvent evt) {
        this.serviceCombo.setEnabled(this.clientToWebServiceRadio.isSelected());
    }

    protected void enterpriseProjectsListValueChanged(ActionEvent evt) {
        this.enterpriseProjectsComboBox.removeActionListener(this.webProjectsActionListener);
        JComboBox cb = (JComboBox)evt.getSource();
        Object cbItem = cb.getSelectedItem();
        DefaultComboBoxModel projectsModel = (DefaultComboBoxModel)cb.getModel();
        if (cbItem instanceof String) {
            String cbItemString = (String)cbItem;
            if (cbItemString.equals(openProject)) {
                Project oldEntepriseProject = this.enterpriseProject;
                this.enterpriseProject = Util.openProject();
                if (this.enterpriseProject != null) {
                    if (projectsModel.getIndexOf(noProject) >= 0) {
                        projectsModel.removeElement(noProject);
                    }
                    if (projectsModel.getIndexOf(this.enterpriseProject) < 0) {
                        projectsModel.insertElementAt(this.enterpriseProject, projectsModel.getSize() - 1);
                    }
                    this.updateWebServices(this.enterpriseProject);
                    cb.setSelectedItem(this.enterpriseProject);
                } else if (oldEntepriseProject != null) {
                    this.enterpriseProject = oldEntepriseProject;
                    cb.setSelectedItem(this.enterpriseProject);
                }
            }
        } else {
            this.enterpriseProject = (Project)cbItem;
            this.updateWebServices(this.enterpriseProject);
        }
        if (this.enterpriseProject != null) {
            Sources sources = ProjectUtils.getSources((Project)this.enterpriseProject);
            sources.getSourceGroups("java");
            this.setServletPanelEnabled(true);
        }
        if (this.enterpriseProject != null) {
            this.initValues(CLIENT_NAME, this.enterpriseProject);
        }
        this.enterpriseProjectsComboBox.addActionListener(this.webProjectsActionListener);
    }

    public void initValues(String displayName, Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        this.project = project;
        this.folders = sourceGroups;
        this.initValues(displayName, project.getProjectDirectory());
    }

    public void initValues(String displayName, FileObject preselectedFolder) {
        assert (this.project != null) : "Project must be specified.";
        this.groupItems = new ModelItem[this.folders.length];
        for (int i = 0; i < this.folders.length; ++i) {
            this.groupItems[i] = new ModelItem(this.folders[i]);
        }
        assert (displayName != null);
        this.putClientProperty("NewFileWizard_Title", "Servlet");
        this.rootComboBox.setModel(new DefaultComboBoxModel<ModelItem>(this.groupItems));
        ModelItem preselectedGroup = this.getPreselectedGroup(preselectedFolder);
        if (this.rootComboBox.getItemCount() > 0) {
            if (preselectedGroup != null) {
                this.rootComboBox.setSelectedItem(preselectedGroup);
            } else {
                this.rootComboBox.setSelectedIndex(0);
            }
        }
        this.updatePackages();
        ModelItem preselectedPackage = this.getPreselectedPackage(preselectedGroup, preselectedFolder);
        if (preselectedPackage != null) {
            if (this.isPackage) {
                String docName = preselectedPackage.toString().length() == 0 ? DEFAULT_NEW_PACKAGE_NAME : preselectedPackage.toString() + "." + DEFAULT_NEW_PACKAGE_NAME;
                this.documentNameTextField.setText(docName);
                int docNameLen = docName.length();
                int defPackageNameLen = DEFAULT_NEW_PACKAGE_NAME.length();
                this.documentNameTextField.setSelectionEnd(docNameLen - 1);
                this.documentNameTextField.setSelectionStart(docNameLen - defPackageNameLen);
            } else {
                this.packageComboBox.setSelectedItem(preselectedPackage);
            }
        }
        this.documentNameTextField.setText(displayName);
        this.documentNameTextField.selectAll();
        String ext = "java";
        this.expectedExtension = ".java";
        this.updateText();
        this.fireChange();
    }

    private Project[] getEnterpriseProjects() {
        ArrayList<Project> enterpriseProjects = new ArrayList<Project>();
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!Util.isWebProject(projects[i])) continue;
            enterpriseProjects.add(projects[i]);
        }
        Project[] ps = new Project[enterpriseProjects.size()];
        ps = enterpriseProjects.toArray(ps);
        Arrays.sort(ps, new ProjectByDisplayNameComparator());
        return ps;
    }

    private void setServletPanelEnabled(boolean enabled) {
        this.rootComboBox.setEnabled(enabled);
        this.packageComboBox.setEnabled(enabled);
        this.documentNameTextField.setEnabled(enabled);
    }

    private ModelItem getPreselectedGroup(FileObject folder) {
        for (int i = 0; folder != null && i < this.groupItems.length; ++i) {
            if (!this.groupItems[i].group.getRootFolder().equals(folder) && !FileUtil.isParentOf((FileObject)this.groupItems[i].group.getRootFolder(), (FileObject)folder)) continue;
            return this.groupItems[i];
        }
        return null;
    }

    private ModelItem getPreselectedPackage(ModelItem groupItem, FileObject folder) {
        if (folder == null || groupItem == null) {
            return null;
        }
        ModelItem[] ch = groupItem.getChildren();
        FileObject root = groupItem.group.getRootFolder();
        String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
        if (relPath == null) {
            return null;
        }
        relPath = relPath.replace('/', '.');
        for (int i = 0; i < ch.length; ++i) {
            if (!ch[i].toString().equals(relPath)) continue;
            return ch[i];
        }
        return null;
    }

    private void updatePackages() {
        if (this.rootComboBox.getItemCount() > 0) {
            this.packageComboBox.setModel(new DefaultComboBoxModel<ModelItem>(((ModelItem)this.rootComboBox.getSelectedItem()).getChildren()));
        }
    }

    private void updateText() {
        if (this.rootComboBox.getItemCount() > 0) {
            ModelItem modelItem = (ModelItem)this.rootComboBox.getSelectedItem();
            FileObject rootFolder = modelItem.group.getRootFolder();
            String packageName = this.getPackageFileName();
            String documentName = this.documentNameTextField.getText().trim();
            if (this.isPackage) {
                documentName = documentName.replace('.', '/');
            } else if (documentName.length() > 0) {
                documentName = documentName + this.expectedExtension;
            }
            String createdFileName = FileUtil.getFileDisplayName((FileObject)rootFolder) + (packageName.startsWith("/") || packageName.startsWith(File.separator) ? "" : "/") + packageName + (packageName.endsWith("/") || packageName.endsWith(File.separator) || packageName.length() == 0 ? "" : "/") + documentName;
            this.fileTextField.setText(createdFileName.replace('/', File.separatorChar));
        }
    }

    public String getPackageFileName() {
        if (this.isPackage) {
            return "";
        }
        String packageName = this.packageComboBox.getEditor().getItem().toString();
        return packageName.replace('.', '/');
    }

    public boolean isSelectedClientType() {
        return this.clientTypeButtonGroup.getSelection() != null;
    }

    public String getSelectedClientType() {
        return this.clientTypeSelection;
    }

    public String isValidWebProject() {
        String message = null;
        if (this.enterpriseProject == null) {
            message = NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_NoProject");
        } else if (!Util.isWebProject(this.enterpriseProject)) {
            message = NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_NoWebProject");
        }
        return message;
    }

    boolean isValidWsdl() {
        return this.getSelectedService() != null;
    }

    boolean isWsdlCompiled() {
        return true;
    }

    public String isValidServletLocation() {
        if ("".equals(this.getTargetName())) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_File_NoTargetName");
        }
        if (!WebApplicationPanel.isValidTypeIdentifier(this.getTargetName())) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_JavaTargetChooser_InvalidClass");
        }
        if (!WebApplicationPanel.isValidPackageName(this.getPackageName())) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_JavaTargetChooser_InvalidPackage");
        }
        try {
            FileObject rootFolder = this.getRootFolder();
            String errorMessage = WebApplicationPanel.canUseFileName(rootFolder, this.getPackageFileName(), this.getTargetName(), "java");
            return errorMessage;
        }
        catch (NullPointerException e) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_Project_Missing_Source_Folders");
        }
    }

    static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidTypeIdentifier(String ident) {
        return ident != null && !"".equals(ident) && Utilities.isJavaIdentifier((String)ident);
    }

    public FileObject getRootFolder() {
        return ((ModelItem)this.rootComboBox.getSelectedItem()).group.getRootFolder();
    }

    public SourceGroup getSourceGroup() {
        if (this.rootComboBox.getSelectedItem() == null) {
            return null;
        }
        return ((ModelItem)this.rootComboBox.getSelectedItem()).group;
    }

    public String getProjectName() {
        if (this.enterpriseProjectsComboBox.getSelectedItem() instanceof String) {
            return this.enterpriseProjectsComboBox.getSelectedItem().toString();
        }
        ProjectInformation pi = (ProjectInformation)((Project)this.enterpriseProjectsComboBox.getSelectedItem()).getLookup().lookup(ProjectInformation.class);
        return pi.getName();
    }

    public Project getEnterpriseProject() {
        if (this.enterpriseProjectsComboBox.getSelectedItem() instanceof String) {
            return null;
        }
        return (Project)this.enterpriseProjectsComboBox.getSelectedItem();
    }

    public String getPackageName() {
        if (this.isPackage) {
            return "";
        }
        return this.packageComboBox.getEditor().getItem().toString();
    }

    public String getTargetName() {
        return this.documentNameTextField.getText().trim();
    }

    public static String canUseFileName(FileObject targetFolder, String folderName, String newObjectName, String extension) {
        if (extension != null && extension.length() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(newObjectName);
            sb.append('.');
            sb.append(extension);
            newObjectName = sb.toString();
        }
        String relFileName = folderName + "/" + newObjectName;
        if (targetFolder == null) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!targetFolder.canWrite()) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (WebApplicationPanel.existFileName(targetFolder, relFileName)) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"MSG_file_already_exist", (Object)newObjectName);
        }
        return null;
    }

    private static boolean existFileName(FileObject targetFolder, String relFileName) {
        boolean result = false;
        File fileForTargetFolder = FileUtil.toFile((FileObject)targetFolder);
        result = fileForTargetFolder.exists() ? new File(fileForTargetFolder, relFileName).exists() : targetFolder.getFileObject(relFileName) != null;
        return result;
    }

    protected void updateWebServices(final Project p) {
        DefaultComboBoxModel<String> servicesModel = null;
        if (p == null) {
            servicesModel = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_NoWebServiceCombo")});
        } else {
            List wsclients;
            JAXWSClientSupport jaxws = JAXWSClientSupport.getJaxWsClientSupport((FileObject)p.getProjectDirectory());
            List list = wsclients = jaxws != null ? jaxws.getServiceClients() : null;
            if (wsclients == null || wsclients.size() > 0) {
                JAXWSClientSupport jaxwsClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)p.getProjectDirectory());
                JAXWSClientView jaxwsClientView = JAXWSClientView.getJAXWSClientView();
                Node jaxwsClientRoot = jaxwsClientView.createJAXWSClientView(p);
                Node[] nodes = jaxwsClientRoot.getChildren().getNodes();
                if (nodes.length == 0) {
                    servicesModel = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(WebApplicationPanel.class, (String)"MSG_ComputingWebServices")});
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            WebApplicationPanel.this.updateWebServices(p);
                        }
                    }, 500);
                } else {
                    ArrayList<Client> services = new ArrayList<Client>();
                    for (int i = 0; i < nodes.length; ++i) {
                        Client client = (Client)nodes[i].getLookup().lookup(Client.class);
                        services.add(client);
                    }
                    servicesModel = new DefaultComboBoxModel<Client>(services.toArray(new Client[services.size()]));
                    this.fireChange();
                }
            } else {
                servicesModel = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_NoWebServiceInProject")});
            }
        }
        this.serviceCombo.setModel(servicesModel);
    }

    Client getSelectedService() {
        Object o = this.serviceCombo.getSelectedItem();
        if (o instanceof Client) {
            return (Client)o;
        }
        return null;
    }

    boolean isWsdl() {
        return this.clientToWebServiceRadio.isSelected();
    }

    public static class WebApplicationPanelWizard
    implements WizardDescriptor.Panel,
    ChangeListener {
        public static final HelpCtx HELP_CTX = new HelpCtx("me.wcb_webappselection");
        WebApplicationPanel gui;
        private final ArrayList<ChangeListener> listeners = new ArrayList();
        private final SpecificationVersion JDK_14 = new SpecificationVersion("1.4");
        private TemplateWizard templateWizard;

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        private void fireChange() {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener cl : this.listeners) {
                cl.stateChanged(e);
            }
        }

        public boolean isValid() {
            String guiMessage = this.gui.isValidWebProject();
            if (guiMessage != null) {
                this.setLocalizedErrorMessage(guiMessage);
                return false;
            }
            guiMessage = this.gui.isValidServletLocation();
            if (guiMessage != null) {
                this.setLocalizedErrorMessage(guiMessage);
                return false;
            }
            boolean isPackage = false;
            if (!WebApplicationPanel.isValidTypeIdentifier(this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidClass");
                return false;
            }
            if (!WebApplicationPanel.isValidPackageName(this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
            boolean returnValue = true;
            FileObject rootFolder = this.gui.getRootFolder();
            String errorMessage = WebApplicationPanel.canUseFileName(rootFolder, this.gui.getPackageFileName(), this.gui.getTargetName(), "java");
            if (this.gui.isShowing()) {
                this.setLocalizedErrorMessage(errorMessage);
            }
            if (errorMessage != null) {
                returnValue = false;
            }
            String sl = SourceLevelQuery.getSourceLevel((FileObject)rootFolder);
            if (returnValue && this.gui.getPackageName().length() == 0 && sl != null && this.JDK_14.compareTo((Object)new SpecificationVersion(sl)) <= 0) {
                this.setErrorMessage("ERR_JavaTargetChooser_DefaultPackage");
            } else if (returnValue) {
                this.setErrorMessage(null);
            }
            if (!this.gui.isSelectedClientType() && returnValue) {
                this.setErrorMessage("ERR_Unselected_Client_Type");
                returnValue = false;
            }
            if (this.gui.isWsdl() && !this.gui.isValidWsdl()) {
                this.setErrorMessage("ERR_NoWebService");
                returnValue = false;
            }
            if (this.gui.isWsdl() && !this.gui.isWsdlCompiled()) {
                this.setErrorMessage("ERR_WebServiceNotCompiled");
                returnValue = false;
            }
            return returnValue;
        }

        private void setErrorMessage(String key) {
            if (key == null) {
                this.setLocalizedErrorMessage(" ");
            } else {
                this.setLocalizedErrorMessage(NbBundle.getMessage(WebApplicationPanel.class, (String)key));
            }
        }

        private void setLocalizedErrorMessage(String message) {
            if (this.templateWizard != null) {
                this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)message);
            }
        }

        public void readSettings(Object settings) {
            this.templateWizard = (TemplateWizard)settings;
            this.getComponent();
            this.isValid();
            this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_WebServiceClient"));
        }

        public void storeSettings(Object settings) {
            this.templateWizard = (TemplateWizard)settings;
            this.getComponent();
            Configuration configuration = (Configuration)this.templateWizard.getProperty("e2e-configuration");
            configuration.setServiceType(this.gui.getSelectedClientType());
            ServerConfiguration sc = new ServerConfiguration();
            String className = this.gui.getPackageName();
            className = !"".equals(className) ? className + "." + this.gui.getTargetName() : this.gui.getTargetName();
            Project project = this.gui.getEnterpriseProject();
            this.templateWizard.putProperty("server-project", (Object)project);
            if (this.gui.getSourceGroup() == null) {
                return;
            }
            String path = this.gui.getSourceGroup().getName();
            ClassDescriptor cd = new ClassDescriptor(className, path);
            sc.setClassDescriptor(cd);
            sc.setProjectName(this.gui.getProjectName());
            sc.setProperties(new Properties());
            configuration.setServerConfiguration(sc);
            List<AbstractService> l = configuration.getServices();
            AbstractService os = null;
            if (l != null && l.size() > 0) {
                os = l.get(0);
            }
            if (this.gui.isWsdl()) {
                configuration.setServiceType("wsdlClass");
                WSDLService wsdlService = null;
                if (os instanceof WSDLService) {
                    wsdlService = (WSDLService)os;
                }
                if (this.gui.getSelectedService() != null) {
                    Client client = this.gui.getSelectedService();
                    if (wsdlService == null || !this.gui.getSelectedService().getName().equals(wsdlService.getName())) {
                        wsdlService = new WSDLService();
                        wsdlService.setName(client.getName());
                        wsdlService.setFile(client.getLocalWsdlFile());
                        wsdlService.setUrl(client.getWsdlUrl());
                        ArrayList<AbstractService> services = new ArrayList<AbstractService>();
                        services.add(wsdlService);
                        configuration.setServices(services);
                    }
                }
            } else {
                configuration.setServiceType("class");
                ArrayList<AbstractService> services = new ArrayList<AbstractService>();
                ClassService classService = null;
                if (!(os instanceof ClassService)) {
                    classService = new ClassService();
                    services.add(classService);
                    configuration.setServices(services);
                }
            }
        }

        public HelpCtx getHelp() {
            return HELP_CTX;
        }

        public Component getComponent() {
            if (this.gui == null) {
                this.gui = new WebApplicationPanel();
                this.gui.addChangeListener(this);
            }
            return this.gui;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.templateWizard != null) {
                this.templateWizard.setValid(this.isValid());
                this.fireChange();
            }
        }
    }

    public static class NodeCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public NodeCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ModelItem) {
                ModelItem item = (ModelItem)value;
                this.setText(item.getDisplayName());
                this.setIcon(item.getIcon());
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static class ModelItem {
        private static final String DEFAULT_PACKAGE_DISPLAY_NAME = NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_JavaTargetChooserPanelGUI_DefaultPackage");
        private Node node;
        SourceGroup group;
        private final Icon icon;
        private ModelItem[] children;

        public ModelItem(SourceGroup group) {
            this.group = group;
            this.icon = group.getIcon(false);
        }

        public ModelItem(Node node) {
            this.node = node;
            this.icon = new ImageIcon(node.getIcon(1));
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            String nodeName = this.node.getName();
            return nodeName.length() == 0 ? DEFAULT_PACKAGE_DISPLAY_NAME : nodeName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            if (this.group != null) {
                return this.getDisplayName();
            }
            return this.node.getName();
        }

        public ModelItem[] getChildren() {
            if (this.group == null) {
                return null;
            }
            if (this.children == null) {
                Node n = PackageView.createPackageView((SourceGroup)this.group);
                Node[] nodes = n.getChildren().getNodes(true);
                this.children = new ModelItem[nodes.length];
                for (int i = 0; i < nodes.length; ++i) {
                    this.children[i] = new ModelItem(nodes[i]);
                }
            }
            return this.children;
        }
    }

    private static class ServiceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ServiceCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Client) {
                Client client = (Client)value;
                this.setText(client.getName());
                this.setIcon(null);
            } else if (value instanceof DataObject) {
                DataObject doj = (DataObject)value;
                this.setText(doj.getNodeDelegate().getDisplayName());
                this.setIcon(new ImageIcon(doj.getNodeDelegate().getIcon(1)));
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static class ProjectCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ProjectCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Project) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)value));
                this.setText(pi.getDisplayName());
                this.setIcon(pi.getIcon());
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private class WebProjectsActionListener
    implements ActionListener {
        WebProjectsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            WebApplicationPanel.this.enterpriseProjectsListValueChanged(evt);
        }
    }

    public static class ProjectByDisplayNameComparator
    implements Comparator<Project> {
        private static Collator COLLATOR = Collator.getInstance();

        @Override
        public int compare(Project p1, Project p2) {
            return COLLATOR.compare(ProjectUtils.getInformation((Project)p1).getDisplayName(), ProjectUtils.getInformation((Project)p2).getDisplayName());
        }
    }
}

