/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.ui.BrokenDatasourceSupport;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class MissingDatabaseConnectionWarning
extends JPanel {
    private final Border scrollPaneBorder;
    private Project project;
    private RequestProcessor.Task task = null;
    private DataSourceListListener dsListListener;
    private JList datasourceList;
    private JButton jButtonAddConnection;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;

    private MissingDatabaseConnectionWarning(Project project) {
        this.initComponents();
        this.project = project;
        this.datasourceList.setModel(new DatasourceListModel());
        this.scrollPaneBorder = this.jScrollPane2.getBorder();
        this.initDatasourceList();
    }

    private void initDatasourceList() {
        this.datasourceList.setCellRenderer(new DatasourceRenderer());
        this.datasourceList.setSelectionMode(0);
        if (this.datasourceList.isSelectionEmpty() && this.datasourceList.getModel().getSize() > 0) {
            this.datasourceList.setSelectedIndex(0);
        }
        this.dsListListener = new DataSourceListListener();
        this.datasourceList.getModel().addListDataListener(this.dsListListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void selectDatasources(String title, String description, Project project) {
        MissingDatabaseConnectionWarning panel = new MissingDatabaseConnectionWarning(project);
        Object[] options = new Object[]{DialogDescriptor.CLOSED_OPTION};
        DialogDescriptor desc = new DialogDescriptor((Object)panel, title, true, options, DialogDescriptor.CLOSED_OPTION, 0, new HelpCtx(MissingDatabaseConnectionWarning.class), null);
        desc.setMessageType(2);
        Dialog dlg = null;
        try {
            dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.getAccessibleContext().setAccessibleDescription(description);
            desc.setValid(panel.getSelectedDatasource() != null);
            panel.setSize(panel.getPreferredSize());
            dlg.pack();
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
    }

    public String getSelectedDatasource() {
        if (this.datasourceList.getSelectedIndex() == -1 || this.datasourceList.getFirstVisibleIndex() == -1) {
            return null;
        }
        return ((Datasource)this.datasourceList.getSelectedValue()).getJndiName();
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.datasourceList = new JList();
        this.jTextArea1 = new JTextArea();
        this.jTextArea2 = new JTextArea();
        this.jButtonAddConnection = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane2.setMinimumSize(new Dimension(200, 100));
        this.datasourceList.setSelectionMode(0);
        this.datasourceList.setPreferredSize(null);
        this.datasourceList.setVerifyInputWhenFocusTarget(false);
        this.datasourceList.setVisibleRowCount(4);
        this.jScrollPane2.setViewportView(this.datasourceList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jTextArea1.setColumns(25);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage(MissingDatabaseConnectionWarning.class, (String)"LBL_SelectDatasource"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName("Resolve Datasource");
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setText(NbBundle.getMessage(MissingDatabaseConnectionWarning.class, (String)"LBL_MissingDatabaseConnectionWarning"));
        this.jTextArea2.setWrapStyleWord(true);
        this.jTextArea2.setFocusable(false);
        this.jTextArea2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.jTextArea2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddConnection, (String)NbBundle.getMessage(MissingDatabaseConnectionWarning.class, (String)"LBL_AddDatabaseConnection"));
        this.jButtonAddConnection.setEnabled(false);
        this.jButtonAddConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MissingDatabaseConnectionWarning.this.jButtonAddConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jButtonAddConnection, gridBagConstraints);
        this.jButtonAddConnection.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MissingDatabaseConnectionWarning.class, (String)"ACSN_AddDatabaseConnection"));
        this.jButtonAddConnection.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MissingDatabaseConnectionWarning.class, (String)"ACSD_AddDatabaseConnection"));
    }

    private void jButtonAddConnectionActionPerformed(ActionEvent evt) {
        Datasource brokenDatasource = (Datasource)this.datasourceList.getSelectedValue();
        MissingDatabaseConnectionWarning.addDatabaseConnection(brokenDatasource);
        if (this.datasourceList.getModel().getSize() > 0) {
            this.jScrollPane2.setBorder(this.scrollPaneBorder);
            this.jTextArea2.setText(NbBundle.getMessage(MissingDatabaseConnectionWarning.class, (String)"LBL_MissingDatabaseConnectionWarning"));
        }
        this.datasourceList.setCellRenderer(new DatasourceRenderer());
    }

    private static void addDatabaseConnection(Datasource brokenDatasource) {
        JDBCDriver selectedDriver;
        String driverName = brokenDatasource.getDriverClassName();
        JDBCDriver matchingDriver = MissingDatabaseConnectionWarning.findMatchingDriver(driverName);
        final Datasource edtDS = brokenDatasource;
        JDBCDriver jDBCDriver = selectedDriver = matchingDriver == null ? MissingDatabaseConnectionWarning.tryRegisterMissingDriver(driverName) : matchingDriver;
        if (selectedDriver == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnectionManager.getDefault().showAddConnectionDialogFromEventThread(selectedDriver, edtDS.getUrl(), edtDS.getUsername(), edtDS.getPassword());
            }
        });
    }

    private static JDBCDriver tryRegisterMissingDriver(String driverName) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MissingDatabaseConnectionWarning.class, (String)"MSG_Broken_Datasources_Register_Driver", (Object)driverName), 1));
        JDBCDriverManager.getDefault().showAddDriverDialog();
        JDBCDriver driver = MissingDatabaseConnectionWarning.findMatchingDriver(driverName);
        if (driver == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MissingDatabaseConnectionWarning.class, (String)"MSG_Broken_Datasources_Missing_Driver", (Object)driverName), 0));
            return null;
        }
        return driver;
    }

    private static JDBCDriver findMatchingDriver(String driverClass) {
        int i = 0;
        JDBCDriver[] newDrivers = JDBCDriverManager.getDefault().getDrivers();
        for (i = 0; i < newDrivers.length; ++i) {
            if (!newDrivers[i].getClassName().equals(driverClass)) continue;
            return newDrivers[i];
        }
        return null;
    }

    private static class DataSourceListListener
    implements ListDataListener {
        private DataSourceListListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            DatasourceListModel dsListModel = (DatasourceListModel)e.getSource();
            if (dsListModel.getSize() == 0) {
                dsListModel.removeConnectionListener();
                dsListModel.disableAddConnectionButton();
                dsListModel.removeListDataListener();
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }

    private static final class DatasourceRenderer
    extends JLabel
    implements ListCellRenderer {
        DatasourceRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Datasource) {
                this.setText(((Datasource)value).getJndiName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private final class DatasourceListModel
    extends AbstractListModel
    implements Runnable,
    ConnectionListener {
        private final RequestProcessor BROKEN_DATASOURCE_RP = new RequestProcessor("WebLogicalViewProvider.BROKEN_DATASOURCE_RP");
        private Set<Datasource> datasources;

        public DatasourceListModel() {
            this.datasources = BrokenDatasourceSupport.getBrokenDatasources(MissingDatabaseConnectionWarning.this.project);
            this.addConnectionListener();
        }

        @Override
        public synchronized int getSize() {
            return this.datasources.size();
        }

        @Override
        public synchronized Object getElementAt(int index) {
            if (!MissingDatabaseConnectionWarning.this.datasourceList.isSelectionEmpty() && this.datasources.size() > 0) {
                if (!MissingDatabaseConnectionWarning.this.jButtonAddConnection.isEnabled()) {
                    MissingDatabaseConnectionWarning.this.jButtonAddConnection.setEnabled(true);
                }
                Iterator<Datasource> it = this.datasources.iterator();
                int i = 0;
                while (it.hasNext()) {
                    if (index < 0 || index > this.datasources.size()) continue;
                    if (i == index) {
                        return it.next();
                    }
                    it.next();
                    ++i;
                }
            } else {
                MissingDatabaseConnectionWarning.this.jButtonAddConnection.setEnabled(false);
            }
            return null;
        }

        public synchronized void refreshModel() {
            if (MissingDatabaseConnectionWarning.this.task == null) {
                MissingDatabaseConnectionWarning.this.task = this.BROKEN_DATASOURCE_RP.create((Runnable)this);
            }
            MissingDatabaseConnectionWarning.this.task.schedule(50);
        }

        @Override
        public synchronized void run() {
            this.datasources = BrokenDatasourceSupport.getBrokenDatasources(MissingDatabaseConnectionWarning.this.project);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DatasourceListModel.this.fireContentsChanged(MissingDatabaseConnectionWarning.this.datasourceList.getModel(), 0, DatasourceListModel.this.datasources.size());
                }
            });
        }

        public void connectionsChanged() {
            MissingDatabaseConnectionWarning.this.initDatasourceList();
            this.refreshModel();
        }

        private void addConnectionListener() {
            ConnectionManager.getDefault().addConnectionListener((ConnectionListener)this);
        }

        private void removeConnectionListener() {
            ConnectionManager.getDefault().removeConnectionListener((ConnectionListener)this);
        }

        private void disableAddConnectionButton() {
            MissingDatabaseConnectionWarning.this.jButtonAddConnection.setEnabled(false);
        }

        private void removeListDataListener() {
            this.removeListDataListener(MissingDatabaseConnectionWarning.this.dsListListener);
        }
    }
}

