/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.j2ee.common.project.ui.ProjectImportLocationPanel;
import org.netbeans.modules.j2ee.common.project.ui.ProjectLocationWizardPanel;
import org.netbeans.modules.j2ee.common.project.ui.UserProjectSettings;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ProjectLocationPanel
extends JPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    public static final String PROP_PROJECT_LOCATION = "projectLocation";
    static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private String generatedProjectName = "";
    private int generatedProjectNameIndex = 0;
    private String currentLibrariesLocation;
    private ProjectLocationWizardPanel wizard;
    private Object j2eeModuleType;
    private String nameFormatter;
    private JButton browseButton;
    private JButton browseLibraries;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JLabel lblHint;
    private JLabel librariesLabel;
    private JTextField librariesLocation;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    protected JTextField projectNameTextField;
    private JCheckBox sharableProject;

    public ProjectLocationPanel(Object j2eeModuleType, String name, String title, ProjectLocationWizardPanel wizard, String defaultNameFormatter) {
        this.initComponents();
        this.wizard = wizard;
        this.j2eeModuleType = j2eeModuleType;
        this.nameFormatter = defaultNameFormatter;
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.librariesLocation.setText(this.currentLibrariesLocation);
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.setName(name);
        this.putClientProperty("NewProjectWizard_Title", title);
        this.sharableProjectActionPerformed(null);
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.librariesLabel = new JLabel();
        this.librariesLocation = new JTextField();
        this.browseLibraries = new JButton();
        this.sharableProject = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.lblHint = new JLabel();
        this.projectNameLabel.setDisplayedMnemonic(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_ProjectName_LabelMnemonic").charAt(0));
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        this.projectNameLabel.setText(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_ProjectName_Label"));
        this.projectLocationLabel.setDisplayedMnemonic(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_ProjectLocation_LabelMnemonic").charAt(0));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        this.projectLocationLabel.setText(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        this.browseButton.setMnemonic(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_Browse_LabelMnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectLocationPanel.this.browseLocationAction(evt);
            }
        });
        this.createdFolderLabel.setDisplayedMnemonic(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_CreatedProjectFolder_LabelMnemonic").charAt(0));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        this.createdFolderLabel.setText(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_CreatedProjectFolder_Label"));
        this.createdFolderTextField.setEditable(false);
        this.librariesLabel.setLabelFor(this.librariesLocation);
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(ProjectLocationPanel.class, (String)"ProjectLocationPanel.librariesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseLibraries, (String)NbBundle.getMessage(ProjectLocationPanel.class, (String)"PanelSharabilityVisual.browseLibraries.text"));
        this.browseLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectLocationPanel.this.browseLibrariesActionPerformed(evt);
            }
        });
        this.sharableProject.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        Mnemonics.setLocalizedText((AbstractButton)this.sharableProject, (String)NbBundle.getMessage(ProjectLocationPanel.class, (String)"ProjectLocationPanel.sharableProject.text"));
        this.sharableProject.setMargin(new Insets(2, 0, 2, 2));
        this.sharableProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectLocationPanel.this.sharableProjectActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(ProjectLocationPanel.class, (String)"HINT_LibrariesFolder"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 501, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.librariesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblHint, -1, 288, Short.MAX_VALUE).addComponent(this.librariesLocation, -1, 288, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseLibraries)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectLocationLabel).addComponent(this.projectNameLabel).addComponent(this.createdFolderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.projectNameTextField, GroupLayout.Alignment.LEADING, -1, 288, Short.MAX_VALUE).addComponent(this.projectLocationTextField, GroupLayout.Alignment.LEADING, -1, 288, Short.MAX_VALUE).addComponent(this.createdFolderTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.sharableProject, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameLabel).addComponent(this.projectNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLocationLabel).addComponent(this.browseButton).addComponent(this.projectLocationTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFolderLabel).addComponent(this.createdFolderTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sharableProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.librariesLabel).addComponent(this.browseLibraries).addComponent(this.librariesLocation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint, -2, -1, -2).addGap(27, 27, 27).addComponent(this.jPanel1, -2, 14, -2)));
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSN_projectNameLabel"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSD_projectNameLabel"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSN_projectLocationLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSN_createdFolderLabel"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.jSeparator1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.jSeparator1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.librariesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.librariesLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.browseLibraries.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.sharableProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.jPanel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.lblHint.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSN_PanelProjectLocationVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocationPanel_NA"));
    }

    private void browseLocationAction(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
            chooser.setDialogTitle(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_SelectProjectLocation"));
            chooser.setFileSelectionMode(1);
            String path = this.projectLocationTextField.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.projectLocationTextField.setText(projectDir.getAbsolutePath());
            }
            this.wizard.fireChangeEvent();
        }
    }

    private void browseLibrariesActionPerformed(ActionEvent evt) {
        File f = new File(this.createdFolderTextField.getText());
        String curr = SharableLibrariesUtils.browseForLibraryLocation((String)this.librariesLocation.getText().trim(), (Component)this, (File)f);
        if (curr != null) {
            this.currentLibrariesLocation = curr;
            if (this.sharableProject.isSelected()) {
                this.librariesLocation.setText(this.currentLibrariesLocation);
            }
        }
    }

    private void sharableProjectActionPerformed(ActionEvent evt) {
        this.librariesLocation.setEnabled(this.sharableProject.isSelected());
        this.browseLibraries.setEnabled(this.sharableProject.isSelected());
        this.librariesLabel.setEnabled(this.sharableProject.isSelected());
        this.lblHint.setEnabled(this.sharableProject.isSelected());
        if (this.sharableProject.isSelected()) {
            this.librariesLocation.setText(this.currentLibrariesLocation);
        } else {
            this.librariesLocation.setText("");
        }
        this.wizard.fireChangeEvent();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File projLoc;
        if (ProjectLocationPanel.isIllegalName(this.projectNameTextField.getText())) {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        File f = new File(this.projectLocationTextField.getText()).getAbsoluteFile();
        if (ProjectLocationPanel.getCanonicalFile(f) == null) {
            String message = NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)message);
            return false;
        }
        File destFolder = ProjectLocationPanel.getCanonicalFile(new File(this.createdFolderTextField.getText()).getAbsoluteFile());
        if (destFolder == null) {
            String message = NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_IllegalProjectName");
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)message);
            return false;
        }
        for (projLoc = destFolder; projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_ProjectFolderReadOnly"));
            return false;
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            String message = NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)message);
            return false;
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_ProjectFolderExists"));
            return false;
        }
        wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)"");
        if (this.sharableProject.isSelected()) {
            String location = this.librariesLocation.getText();
            if (new File(location).isAbsolute()) {
                wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)ProjectLocationPanel.decorateMessage(NbBundle.getMessage(ProjectLocationPanel.class, (String)"PanelSharability.absolutePathWarning.text")));
            } else {
                File libLoc;
                File projectLoc = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()));
                if (!CollocationQuery.areCollocated((File)projectLoc, (File)(libLoc = PropertyUtils.resolveFile((File)projectLoc, (String)location)))) {
                    wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)ProjectLocationPanel.decorateMessage(NbBundle.getMessage(ProjectLocationPanel.class, (String)"PanelSharability.relativePathWarning.text")));
                }
            }
        }
        return true;
    }

    void store(WizardDescriptor d) {
        String name = this.projectNameTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        d.putProperty("projdir", (Object)new File(folder));
        d.putProperty("name", (Object)name);
        d.putProperty("sharedLibraries", this.sharableProject.isSelected() ? this.librariesLocation.getText() : null);
    }

    void read(WizardDescriptor settings) {
        File projectLocation = (File)settings.getProperty("projdir");
        if (projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory()) {
            File existingSourcesFile;
            File currentDirectory = null;
            FileObject existingSourcesFO = Templates.getExistingSourcesFolder((WizardDescriptor)settings);
            if (existingSourcesFO != null && (existingSourcesFile = FileUtil.toFile((FileObject)existingSourcesFO)) != null && existingSourcesFile.isDirectory()) {
                currentDirectory = existingSourcesFile;
            }
            projectLocation = currentDirectory != null ? currentDirectory : ProjectChooser.getProjectsFolder();
        } else {
            projectLocation = projectLocation.getParentFile();
        }
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = (String)settings.getProperty("name");
        if (projectName == null) {
            int baseCount = 1;
            while ((projectName = this.validFreeProjectName(projectLocation, this.nameFormatter, baseCount)) == null) {
                ++baseCount;
            }
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String name = MessageFormat.format(formater, index);
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectFolder;
            String projFolderPath;
            String projectName = this.projectNameTextField.getText();
            if (doc == this.projectLocationTextField.getDocument()) {
                if (projectName.equals(this.generatedProjectName)) {
                    File f = new File(this.projectLocationTextField.getText().trim());
                    this.generatedProjectNameIndex = ProjectLocationPanel.getValidProjectNameIndex(this.nameFormatter, this.generatedProjectNameIndex, f);
                } else {
                    this.generatedProjectNameIndex = 0;
                }
                String string = this.generatedProjectName = this.generatedProjectNameIndex > 0 ? ProjectLocationPanel.getProjectName(this.nameFormatter, this.generatedProjectNameIndex) : null;
                if (this.generatedProjectNameIndex > 0) {
                    projectName = this.generatedProjectName;
                    this.projectNameTextField.setText(this.generatedProjectName);
                    this.projectNameTextField.selectAll();
                }
            }
            if ((projFolderPath = FileUtil.normalizeFile((File)new File(projectFolder = this.projectLocationTextField.getText())).getAbsolutePath()).endsWith(File.separator)) {
                this.createdFolderTextField.setText(projFolderPath + projectName);
            } else {
                this.createdFolderTextField.setText(projFolderPath + File.separator + projectName);
            }
        }
        this.wizard.fireChangeEvent();
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getProjectName(String formatter, int index) {
        return MessageFormat.format(formatter, String.valueOf(index));
    }

    private static int getValidProjectNameIndex(String formatter, int currentIndex, File projectLocation) {
        int index;
        int n = index = currentIndex > 0 ? currentIndex : UserProjectSettings.getDefault().getNewProjectCount() + 1;
        if (projectLocation != null) {
            while (new File(projectLocation, ProjectLocationPanel.getProjectName(formatter, index)).exists()) {
                ++index;
            }
        }
        return index;
    }

    public static String decorateMessage(String message) {
        if (message != null) {
            return "<html>" + message.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</html>";
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectImportLocationPanel.generateHelpID(ProjectLocationPanel.class, this.j2eeModuleType));
    }

    static boolean isIllegalName(String name) {
        return name.length() == 0 || name.indexOf(47) >= 0 || name.indexOf(92) >= 0 || name.indexOf(58) >= 0 || name.indexOf("\"") >= 0 || name.indexOf(60) >= 0 || name.indexOf(62) >= 0;
    }
}

