/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.common.project.ui.UserProjectSettings;
import org.netbeans.spi.java.project.support.PreferredProjectPlatform;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

final class J2eeVersionWarningPanel
extends JPanel {
    public static final String WARN_SET_JDK_14 = "warnSetJdk14";
    public static final String WARN_SET_JDK_15 = "warnSetJdk15";
    public static final String WARN_SET_JDK_6 = "warnSetJdk6";
    public static final String WARN_SET_JDK_7 = "warnSetJdk7";
    public static final String WARN_SET_SOURCE_LEVEL_14 = "warnSetSourceLevel14";
    public static final String WARN_SET_SOURCE_LEVEL_15 = "warnSetSourceLevel15";
    public static final String WARN_SET_SOURCE_LEVEL_6 = "warnSetSourceLevel6";
    public static final String WARN_SET_SOURCE_LEVEL_7 = "warnSetSourceLevel7";
    private String warningType;
    private JCheckBox jCheckBox;
    private JLabel jLabel;

    public J2eeVersionWarningPanel(String warningType) {
        this.initComponents();
        this.setWarningType(warningType);
    }

    public String getWarningType() {
        return this.warningType;
    }

    public void setWarningType(String warningType) {
        boolean select = false;
        String labelText = "";
        String checkboxText = "";
        this.warningType = warningType;
        if (WARN_SET_JDK_14.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetJdk14");
            checkboxText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetJdk14");
            select = UserProjectSettings.getDefault().isAgreedSetJdk14();
        } else if (WARN_SET_SOURCE_LEVEL_14.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetSourceLevel14");
            checkboxText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetSourceLevel14");
            select = UserProjectSettings.getDefault().isAgreedSetSourceLevel14();
        } else if (WARN_SET_JDK_15.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetJdk15");
            checkboxText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetJdk15");
            select = UserProjectSettings.getDefault().isAgreedSetJdk15();
        } else if (WARN_SET_SOURCE_LEVEL_15.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetSourceLevel15");
            checkboxText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetSourceLevel15");
            select = UserProjectSettings.getDefault().isAgreedSetSourceLevel15();
        } else if (WARN_SET_JDK_6.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetJdk6");
            checkboxText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetJdk6");
            select = true;
        } else if (WARN_SET_JDK_7.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetJdk7");
            checkboxText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetJdk7");
            select = true;
        } else if (WARN_SET_SOURCE_LEVEL_6.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetSourceLevel6");
            checkboxText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetSourceLevel6");
            select = true;
        } else if (WARN_SET_SOURCE_LEVEL_7.equals(warningType)) {
            labelText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetSourceLevel7");
            checkboxText = NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetSourceLevel7");
            select = true;
        }
        this.jLabel.setText(labelText);
        this.jCheckBox.setSelected(select);
        this.jCheckBox.setText(checkboxText);
    }

    public boolean getDowngradeAllowed() {
        return this.jCheckBox.isSelected();
    }

    public String getSuggestedJavaPlatformName() {
        if (WARN_SET_JDK_14.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.4");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getDisplayName();
        }
        if (WARN_SET_JDK_15.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.5");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getDisplayName();
        }
        if (WARN_SET_JDK_6.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.6");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getDisplayName();
        }
        if (WARN_SET_JDK_7.equals(this.warningType)) {
            JavaPlatform[] javaPlatforms = J2eeVersionWarningPanel.getJavaPlatforms("1.7");
            return J2eeVersionWarningPanel.getPreferredPlatform(javaPlatforms).getDisplayName();
        }
        return J2eeVersionWarningPanel.getPreferredPlatform(null).getDisplayName();
    }

    private static JavaPlatform getPreferredPlatform(@NullAllowed JavaPlatform[] platforms) {
        JavaPlatform pp = PreferredProjectPlatform.getPreferredPlatform((String)JavaPlatform.getDefault().getSpecification().getName());
        if (platforms == null) {
            return pp;
        }
        for (JavaPlatform jp : platforms) {
            if (!jp.equals(pp)) continue;
            return jp;
        }
        return platforms[0];
    }

    public static String findWarningType(Profile j2eeProfile) {
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion version = defaultPlatform.getSpecification().getVersion();
        String sourceLevel = version.toString();
        if ("1.4".equals(sourceLevel) && j2eeProfile == Profile.J2EE_14) {
            return null;
        }
        if ("1.5".equals(sourceLevel) && j2eeProfile == Profile.JAVA_EE_5) {
            return null;
        }
        if ("1.6".equals(sourceLevel) && (j2eeProfile == Profile.JAVA_EE_6_FULL || j2eeProfile == Profile.JAVA_EE_6_WEB)) {
            return null;
        }
        if ("1.7".equals(sourceLevel) && (j2eeProfile == Profile.JAVA_EE_7_FULL || j2eeProfile == Profile.JAVA_EE_7_WEB)) {
            return null;
        }
        if (j2eeProfile == Profile.J2EE_14) {
            JavaPlatform[] java14Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.4");
            if (java14Platforms.length > 0) {
                return WARN_SET_JDK_14;
            }
            return WARN_SET_SOURCE_LEVEL_14;
        }
        if (j2eeProfile == Profile.JAVA_EE_5) {
            JavaPlatform[] java15Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.5");
            if (java15Platforms.length > 0) {
                return WARN_SET_JDK_15;
            }
            return WARN_SET_SOURCE_LEVEL_15;
        }
        if (j2eeProfile == Profile.JAVA_EE_6_FULL || j2eeProfile == Profile.JAVA_EE_6_WEB) {
            JavaPlatform[] java16Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.6");
            if (java16Platforms.length > 0) {
                return WARN_SET_JDK_6;
            }
            return WARN_SET_SOURCE_LEVEL_6;
        }
        if (j2eeProfile == Profile.JAVA_EE_7_FULL || j2eeProfile == Profile.JAVA_EE_7_WEB) {
            JavaPlatform[] java17Platforms = J2eeVersionWarningPanel.getJavaPlatforms("1.7");
            if (java17Platforms.length > 0) {
                return WARN_SET_JDK_7;
            }
            return WARN_SET_SOURCE_LEVEL_7;
        }
        return null;
    }

    @Deprecated
    public static String findWarningType(String j2eeLevel) {
        return J2eeVersionWarningPanel.findWarningType(Profile.fromPropertiesString((String)j2eeLevel));
    }

    private static JavaPlatform[] getJavaPlatforms(String level) {
        return JavaPlatformManager.getDefault().getPlatforms(null, new Specification("J2SE", new SpecificationVersion(level)));
    }

    private void initComponents() {
        this.jLabel = new JLabel();
        this.jCheckBox = new JCheckBox();
        this.jLabel.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MSG_RecommendationSetJdk14"));
        this.jCheckBox.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetJdk14"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox, -1, 468, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel, -2, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 0, -2).addComponent(this.jLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

