/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.openide.awt.HtmlBrowser;

class WebUrlHyperlinkSupport {
    private static MouseAdapter urlListener;

    WebUrlHyperlinkSupport() {
    }

    static void register(final JTextPane pane) {
        final StyledDocument doc = pane.getStyledDocument();
        String text = "";
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
        final int[] boundaries = WebUrlHyperlinkSupport.findBoundaries(text);
        if (boundaries != null && boundaries.length != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Style defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
                    Style hlStyle = doc.addStyle("regularBlue-url", defStyle);
                    hlStyle.addAttribute("attribute.url.link", new UrlAction());
                    StyleConstants.setForeground(hlStyle, Color.BLUE);
                    StyleConstants.setUnderline(hlStyle, true);
                    for (int i = 0; i < boundaries.length; i += 2) {
                        doc.setCharacterAttributes(boundaries[i], boundaries[i + 1] - boundaries[i], hlStyle, true);
                    }
                    pane.removeMouseListener(WebUrlHyperlinkSupport.getUrlMouseListener());
                    pane.addMouseListener(WebUrlHyperlinkSupport.getUrlMouseListener());
                }
            });
        }
    }

    private static MouseAdapter getUrlMouseListener() {
        if (urlListener == null) {
            urlListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        JTextPane pane;
                        StyledDocument doc;
                        Element elem;
                        AttributeSet as;
                        UrlAction urlAction;
                        if (SwingUtilities.isLeftMouseButton(e) && (urlAction = (UrlAction)(as = (elem = (doc = (pane = (JTextPane)e.getSource()).getStyledDocument()).getCharacterElement(pane.viewToModel(e.getPoint()))).getAttributes()).getAttribute("attribute.url.link")) != null) {
                            int startOffset = elem.getStartOffset();
                            int endOffset = elem.getEndOffset();
                            int length = endOffset - startOffset;
                            String hyperlinkText = doc.getText(startOffset, length);
                            urlAction.openUrlHyperlink(hyperlinkText);
                            return;
                        }
                    }
                    catch (Exception ex) {
                        BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
                    }
                }
            };
        }
        return urlListener;
    }

    static int[] findBoundaries(String text) {
        return new SearchMachine(text).findBoundaries();
    }

    static final class SearchMachine {
        private static final String URI_INIT_CHARS = " <[(\"'";
        private static final String GEN_DELIMS = ":/?#[]@";
        private static final String SUB_DELIMS = "!$&'()*+,;=";
        private static final String RESERVED = ":/?#[]@!$&'()*+,;=";
        private static final String PUNCT_CHARS = ".,:;()[]{}";
        private static final String[] SUPPORTED_SCHEMES = new String[]{"http", "https", "mailto"};
        private static final int LOWER_A = 97;
        private static final int LOWER_F = 102;
        private static final int LOWER_Z = 122;
        private State state = State.INIT;
        private final CharSequence text;
        int[] result;
        int start;
        int end;

        SearchMachine(CharSequence text) {
            this.text = text;
            this.reset();
        }

        private void reset() {
            this.state = State.INIT;
            this.start = -1;
            this.end = -1;
            this.result = null;
        }

        int[] findBoundaries() {
            int length = this.text.length();
            if (length == 0) {
                return new int[0];
            }
            int schemeStart = -1;
            int authorityStart = -1;
            int hostStart = -1;
            int portStart = -1;
            int pathStart = -1;
            int queryStart = -1;
            int fragmentStart = -1;
            int remainingHexaChars = 0;
            int ipv4Parts = 0;
            int ipv4Digits = 0;
            int ipv4PartAddr = 0;
            int ipv6Parts = 0;
            int ipv6Digits = 0;
            boolean ipv6QDotPresent = false;
            boolean wasValidUri = false;
            boolean reuseCharInNextRound = false;
            int bracketsDepth = 0;
            for (int i = 0; i < length; ++i) {
                boolean isValidUri = false;
                if (reuseCharInNextRound) {
                    --i;
                    reuseCharInNextRound = false;
                }
                char c = this.text.charAt(i);
                State newState = null;
                if (remainingHexaChars != 0) {
                    if (!SearchMachine.isHexDigit(c)) continue;
                    --remainingHexaChars;
                    newState = this.state;
                    continue;
                }
                switch (this.state) {
                    case WAITING_FOR_URI_END_CHAR: {
                        if (SearchMachine.isUriEndChar(c)) {
                            if (SearchMachine.isInitChar(c)) {
                                newState = State.INIT;
                                reuseCharInNextRound = true;
                                break;
                            }
                            newState = State.WAITING_FOR_INIT_CHAR;
                            break;
                        }
                        newState = State.WAITING_FOR_URI_END_CHAR;
                        break;
                    }
                    case WAITING_FOR_INIT_CHAR: {
                        if (SearchMachine.isInitChar(c)) {
                            newState = State.INIT;
                            reuseCharInNextRound = true;
                            break;
                        }
                        newState = State.WAITING_FOR_INIT_CHAR;
                        break;
                    }
                    case INIT: {
                        if (SearchMachine.isLetter(c)) {
                            newState = State.SCHEME;
                            schemeStart = i;
                            this.rememberIsStart(i);
                            break;
                        }
                        if (SearchMachine.isInitChar(c)) {
                            newState = State.INIT;
                            break;
                        }
                        newState = State.WAITING_FOR_INIT_CHAR;
                        break;
                    }
                    case SCHEME: {
                        if (c == ':') {
                            newState = State.HIER_START;
                            isValidUri = true;
                            break;
                        }
                        if (!SearchMachine.isSchemeChar(c)) break;
                        newState = State.SCHEME;
                        break;
                    }
                    case HIER_START: {
                        if (c == '/') {
                            pathStart = i;
                            newState = State.HIER_SLASH;
                            isValidUri = true;
                            break;
                        }
                        if (!SearchMachine.isPathSegmentChar(c)) break;
                        if (c == '%') {
                            remainingHexaChars = 2;
                        } else if (c == '(') {
                            ++bracketsDepth;
                        }
                        pathStart = i;
                        newState = State.PATH;
                        isValidUri = true;
                        break;
                    }
                    case HIER_SLASH: {
                        if (c == '/') {
                            pathStart = -1;
                            authorityStart = i + 1;
                            newState = State.USERINFO_OR_HOST_START;
                            isValidUri = true;
                            break;
                        }
                        if (!SearchMachine.isPathSegmentChar(c)) break;
                        if (c == '%') {
                            remainingHexaChars = 2;
                        } else if (c == '(') {
                            ++bracketsDepth;
                        }
                        newState = State.PATH;
                        isValidUri = true;
                        break;
                    }
                    case USERINFO_OR_HOST_START: {
                        if (c == ':') {
                            portStart = i + 1;
                            newState = State.USERINFO_OR_PORT_NUMBER;
                            isValidUri = true;
                            break;
                        }
                        if (SearchMachine.isDigit(c)) {
                            ipv4Parts = 1;
                            ipv4Digits = 1;
                            ipv4PartAddr = c - 48;
                            hostStart = i;
                            newState = State.USERINFO_OR_IPV4_OR_REGNAME;
                            break;
                        }
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                remainingHexaChars = 2;
                            } else if (c == '(') {
                                ++bracketsDepth;
                            }
                            hostStart = i;
                            newState = State.USERINFO_OR_REGNAME;
                            isValidUri = true;
                            break;
                        }
                        if (c == '@') {
                            hostStart = i + 1;
                            newState = State.HOST_START;
                            isValidUri = true;
                            break;
                        }
                        if (c == '[') {
                            hostStart = i;
                            newState = State.IP_LITERAL_START;
                            break;
                        }
                        if (c == '/') {
                            pathStart = i;
                            newState = State.PATH;
                            isValidUri = true;
                            break;
                        }
                        if (c == '?') {
                            queryStart = i + 1;
                            newState = State.QUERY;
                            isValidUri = true;
                            break;
                        }
                        if (c != '#') break;
                        fragmentStart = i + 1;
                        newState = State.FRAGMENT;
                        isValidUri = true;
                        break;
                    }
                    case USERINFO_OR_IPV4_OR_REGNAME: {
                        if (c == ':') {
                            portStart = i + 1;
                            newState = State.USERINFO_OR_PORT_NUMBER;
                            isValidUri = true;
                            break;
                        }
                        if (SearchMachine.isDigit(c)) {
                            newState = ++ipv4Digits > 3 ? State.USERINFO_OR_REGNAME : (ipv4Digits < 3 ? State.USERINFO_OR_IPV4_OR_REGNAME : ((ipv4PartAddr = 10 * ipv4PartAddr + (c - 48)) <= 255 ? State.USERINFO_OR_IPV4_OR_REGNAME : State.USERINFO_OR_REGNAME));
                            isValidUri = true;
                            break;
                        }
                        if (c == '.') {
                            if (++ipv4Parts > 4) {
                                newState = State.USERINFO_OR_REGNAME;
                            } else if (ipv4Digits == 0) {
                                newState = State.USERINFO_OR_REGNAME;
                            } else {
                                ipv4Digits = 0;
                                ipv4PartAddr = 0;
                                newState = State.USERINFO_OR_IPV4_OR_REGNAME;
                            }
                            isValidUri = true;
                            break;
                        }
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                remainingHexaChars = 2;
                            } else if (c == '(') {
                                assert (bracketsDepth == 0);
                                ++bracketsDepth;
                            }
                            newState = State.USERINFO_OR_REGNAME;
                            isValidUri = true;
                            break;
                        }
                        if (c == '@') {
                            hostStart = i + 1;
                            newState = State.HOST_START;
                            isValidUri = true;
                            break;
                        }
                        if (c == '/') {
                            pathStart = i;
                            newState = State.PATH;
                            isValidUri = true;
                            break;
                        }
                        if (c == '?') {
                            queryStart = i + 1;
                            newState = State.QUERY;
                            isValidUri = true;
                            break;
                        }
                        if (c != '#') break;
                        fragmentStart = i + 1;
                        newState = State.FRAGMENT;
                        isValidUri = true;
                        break;
                    }
                    case USERINFO_OR_REGNAME: {
                        if (c == ':') {
                            bracketsDepth = 0;
                            portStart = i + 1;
                            newState = State.USERINFO_OR_PORT_NUMBER;
                            isValidUri = true;
                            break;
                        }
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                remainingHexaChars = 2;
                            } else if (c == '(') {
                                ++bracketsDepth;
                            } else if (c == ')') {
                                --bracketsDepth;
                            }
                            newState = State.USERINFO_OR_REGNAME;
                            isValidUri = true;
                            break;
                        }
                        if (c == '@') {
                            bracketsDepth = 0;
                            hostStart = i + 1;
                            newState = State.HOST_START;
                            isValidUri = true;
                            break;
                        }
                        if (c == '/') {
                            bracketsDepth = 0;
                            pathStart = i;
                            newState = State.PATH;
                            isValidUri = true;
                            break;
                        }
                        if (c == '?') {
                            bracketsDepth = 0;
                            queryStart = i + 1;
                            newState = State.QUERY;
                            isValidUri = true;
                            break;
                        }
                        if (c != '#') break;
                        bracketsDepth = 0;
                        fragmentStart = i + 1;
                        newState = State.FRAGMENT;
                        isValidUri = true;
                        break;
                    }
                    case USERINFO_OR_PORT_NUMBER: {
                        if (SearchMachine.isDigit(c)) {
                            newState = State.USERINFO_OR_PORT_NUMBER;
                            isValidUri = true;
                            break;
                        }
                        if (SearchMachine.isUserInfoChar(c)) {
                            hostStart = -1;
                            portStart = -1;
                            newState = State.USERINFO;
                            break;
                        }
                        if (c == '@') {
                            hostStart = i + 1;
                            portStart = -1;
                            newState = State.HOST_START;
                            isValidUri = true;
                            break;
                        }
                        if (c == '/') {
                            newState = State.PATH;
                            isValidUri = true;
                            break;
                        }
                        if (c == '?') {
                            newState = State.QUERY;
                            isValidUri = true;
                            break;
                        }
                        if (c != '#') break;
                        newState = State.FRAGMENT;
                        isValidUri = true;
                        break;
                    }
                    case USERINFO: {
                        if (SearchMachine.isUserInfoChar(c)) {
                            newState = State.USERINFO;
                            break;
                        }
                        if (c != '@') break;
                        hostStart = i + 1;
                        newState = State.HOST_START;
                        isValidUri = true;
                        break;
                    }
                    case HOST_START: {
                        if (SearchMachine.isDigit(c)) {
                            ipv4Parts = 1;
                            ipv4Digits = 1;
                            ipv4PartAddr = c - 48;
                            hostStart = i;
                            newState = State.IPV4_OR_REGNAME;
                            isValidUri = true;
                            break;
                        }
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                remainingHexaChars = 2;
                            } else if (c == '(') {
                                assert (bracketsDepth == 0);
                                ++bracketsDepth;
                            }
                            hostStart = i;
                            newState = State.REGNAME;
                            isValidUri = true;
                            break;
                        }
                        if (c == '[') {
                            hostStart = i;
                            newState = State.IP_LITERAL_START;
                            break;
                        }
                        if (c == '/') {
                            pathStart = i;
                            newState = State.PATH;
                            isValidUri = true;
                            break;
                        }
                        if (c == '?') {
                            queryStart = i + 1;
                            newState = State.QUERY;
                            isValidUri = true;
                            break;
                        }
                        if (c != '#') break;
                        fragmentStart = i + 1;
                        newState = State.FRAGMENT;
                        isValidUri = true;
                        break;
                    }
                    case IPV4_OR_REGNAME: {
                        if (SearchMachine.isDigit(c)) {
                            newState = ++ipv4Digits > 3 ? State.REGNAME : (ipv4Digits < 3 ? State.IPV4_OR_REGNAME : ((ipv4PartAddr = 10 * ipv4PartAddr + (c - 48)) <= 255 ? State.IPV4_OR_REGNAME : State.REGNAME));
                            isValidUri = true;
                            break;
                        }
                        if (c == '.') {
                            if (++ipv4Parts > 4) {
                                newState = State.REGNAME;
                            } else if (ipv4Digits == 0) {
                                newState = State.REGNAME;
                            } else {
                                ipv4Digits = 0;
                                ipv4PartAddr = 0;
                                newState = State.IPV4_OR_REGNAME;
                            }
                            isValidUri = true;
                            break;
                        }
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                remainingHexaChars = 2;
                            } else if (c == '(') {
                                assert (bracketsDepth == 0);
                                ++bracketsDepth;
                            }
                            newState = State.REGNAME;
                            isValidUri = true;
                            break;
                        }
                        if (c == '/') {
                            pathStart = i;
                            newState = State.PATH;
                            isValidUri = true;
                            break;
                        }
                        if (c == '?') {
                            queryStart = i + 1;
                            newState = State.QUERY;
                            isValidUri = true;
                            break;
                        }
                        if (c != '#') break;
                        fragmentStart = i + 1;
                        newState = State.FRAGMENT;
                        isValidUri = true;
                        break;
                    }
                    case REGNAME: {
                        if (SearchMachine.isRegnameChar(c)) {
                            if (c == '%') {
                                remainingHexaChars = 2;
                            } else if (c == '(') {
                                ++bracketsDepth;
                            } else if (c == ')') {
                                --bracketsDepth;
                            }
                            newState = State.REGNAME;
                            isValidUri = true;
                            break;
                        }
                        if (c == '/') {
                            bracketsDepth = 0;
                            pathStart = i;
                            newState = State.PATH;
                            isValidUri = true;
                            break;
                        }
                        if (c == '?') {
                            bracketsDepth = 0;
                            queryStart = i + 1;
                            newState = State.QUERY;
                            isValidUri = true;
                            break;
                        }
                        if (c != '#') break;
                        bracketsDepth = 0;
                        fragmentStart = i + 1;
                        newState = State.FRAGMENT;
                        isValidUri = true;
                        break;
                    }
                    case IP_LITERAL_START: {
                        if (c == 'v' || c == 'V') {
                            newState = State.IP_FUTURE_START;
                            break;
                        }
                        if (c == ':') {
                            newState = State.IPV6_QDOT_1;
                            ipv6Parts = 0;
                            ipv6Digits = 0;
                            break;
                        }
                        if (!SearchMachine.isHexDigit(c)) break;
                        ipv6Parts = 1;
                        ipv6Digits = 1;
                        newState = State.IPV6;
                        break;
                    }
                    case IPV6: {
                        boolean ipv6PartsOk;
                        if (c == ':') {
                            int maxParts;
                            int n = maxParts = ipv6QDotPresent ? 7 : 8;
                            if (ipv6Parts >= maxParts) break;
                            newState = State.IPV6_DDOT;
                            break;
                        }
                        if (SearchMachine.isHexDigit(c)) {
                            if (++ipv6Digits > 4) break;
                            newState = State.IPV6;
                            break;
                        }
                        if (c != ']') break;
                        boolean bl = ipv6QDotPresent ? ipv6Parts < 8 : (ipv6PartsOk = ipv6Parts == 8);
                        if (!ipv6PartsOk) break;
                        newState = State.PORT_NUMBER_OR_AUTHORITY_END;
                        isValidUri = true;
                        break;
                    }
                    case IPV6_DDOT: {
                        if (c == ':') {
                            if (ipv6QDotPresent) break;
                            ipv6QDotPresent = true;
                            newState = State.IPV6_QDOT_2;
                            break;
                        }
                        if (!SearchMachine.isHexDigit(c)) break;
                        ++ipv6Parts;
                        ipv6Digits = 1;
                        newState = State.IPV6;
                        break;
                    }
                    case IPV6_QDOT_1: {
                        if (c != ':') break;
                        ipv6QDotPresent = true;
                        newState = State.IPV6_QDOT_2;
                        break;
                    }
                    case IPV6_QDOT_2: {
                        boolean ipv6PartsOk;
                        if (SearchMachine.isHexDigit(c)) {
                            ++ipv6Parts;
                            ipv6Digits = 1;
                            newState = State.IPV6;
                            break;
                        }
                        if (c != ']') break;
                        boolean bl = ipv6QDotPresent ? ipv6Parts < 8 : (ipv6PartsOk = ipv6Parts == 8);
                        if (!ipv6PartsOk) break;
                        newState = State.PORT_NUMBER_OR_AUTHORITY_END;
                        break;
                    }
                    case IP_FUTURE_START: {
                        if (!SearchMachine.isHexDigit(c)) break;
                        newState = State.IP_FUTURE_VER_NUM;
                        break;
                    }
                    case IP_FUTURE_VER_NUM: {
                        if (c == '.') {
                            newState = State.IP_FUTURE_ADDR_START;
                            break;
                        }
                        if (!SearchMachine.isHexDigit(c)) break;
                        newState = State.IP_FUTURE_VER_NUM;
                        break;
                    }
                    case IP_FUTURE_ADDR_START: {
                        if (!SearchMachine.isIpFutureAddrChar(c)) break;
                        newState = State.IP_FUTURE_ADDR;
                        break;
                    }
                    case IP_FUTURE_ADDR: {
                        if (SearchMachine.isIpFutureAddrChar(c)) {
                            newState = State.IP_FUTURE_ADDR;
                            break;
                        }
                        if (c != ']') break;
                        newState = State.PORT_NUMBER_OR_AUTHORITY_END;
                        isValidUri = true;
                        break;
                    }
                    case PORT_NUMBER_OR_AUTHORITY_END: {
                        if (c == ':') {
                            newState = State.PORT_NUMBER;
                            isValidUri = true;
                            break;
                        }
                        if (c == '/') {
                            pathStart = i;
                            newState = State.PATH;
                            isValidUri = true;
                            break;
                        }
                        if (c == '?') {
                            queryStart = i + 1;
                            newState = State.QUERY;
                            isValidUri = true;
                            break;
                        }
                        if (c != '#') break;
                        fragmentStart = i + 1;
                        newState = State.FRAGMENT;
                        isValidUri = true;
                        break;
                    }
                    case PORT_NUMBER: {
                        if (SearchMachine.isDigit(c)) {
                            newState = State.PORT_NUMBER;
                            isValidUri = true;
                            break;
                        }
                        if (c == '/') {
                            pathStart = i;
                            newState = State.PATH;
                            isValidUri = true;
                            break;
                        }
                        if (c == '?') {
                            queryStart = i + 1;
                            newState = State.QUERY;
                            isValidUri = true;
                            break;
                        }
                        if (c != '#') break;
                        fragmentStart = i + 1;
                        newState = State.FRAGMENT;
                        isValidUri = true;
                        break;
                    }
                    case PATH: {
                        if (c == '?') {
                            bracketsDepth = 0;
                            queryStart = i + 1;
                            newState = State.QUERY;
                            isValidUri = true;
                            break;
                        }
                        if (c == '#') {
                            bracketsDepth = 0;
                            fragmentStart = i + 1;
                            newState = State.FRAGMENT;
                            isValidUri = true;
                            break;
                        }
                        if (c != '/' && !SearchMachine.isPathSegmentChar(c)) break;
                        if (c == '%') {
                            remainingHexaChars = 2;
                        } else if (c == '(') {
                            ++bracketsDepth;
                        } else if (c == ')') {
                            --bracketsDepth;
                        }
                        newState = State.PATH;
                        isValidUri = true;
                        break;
                    }
                    case QUERY: {
                        if (c == '#') {
                            bracketsDepth = 0;
                            fragmentStart = i + 1;
                            newState = State.FRAGMENT;
                            isValidUri = true;
                            break;
                        }
                        if (!SearchMachine.isQueryChar(c)) break;
                        if (c == '%') {
                            remainingHexaChars = 2;
                        } else if (c == '(') {
                            ++bracketsDepth;
                        } else if (c == ')') {
                            --bracketsDepth;
                        }
                        newState = State.QUERY;
                        isValidUri = true;
                        break;
                    }
                    case FRAGMENT: {
                        if (!SearchMachine.isFragmentChar(c)) break;
                        if (c == '%') {
                            remainingHexaChars = 2;
                        } else if (c == '(') {
                            ++bracketsDepth;
                        } else if (c == ')') {
                            --bracketsDepth;
                        }
                        newState = State.FRAGMENT;
                        isValidUri = true;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                isValidUri &= remainingHexaChars == 0;
                if (newState == null) {
                    assert (!reuseCharInNextRound);
                    if (SearchMachine.isUriEndChar(c)) {
                        if (wasValidUri) {
                            assert (this.start != -1);
                            this.checkAndStoreResult(this.start, i, bracketsDepth);
                        }
                        newState = SearchMachine.isInitChar(c) ? State.INIT : State.WAITING_FOR_INIT_CHAR;
                    } else {
                        newState = State.WAITING_FOR_URI_END_CHAR;
                    }
                    this.start = -1;
                }
                if (this.state != State.INIT && newState == State.INIT) {
                    schemeStart = -1;
                    authorityStart = -1;
                    hostStart = -1;
                    portStart = -1;
                    pathStart = -1;
                    queryStart = -1;
                    fragmentStart = -1;
                    remainingHexaChars = 0;
                    bracketsDepth = 0;
                }
                wasValidUri = isValidUri;
                this.state = newState;
            }
            if (wasValidUri) {
                assert (this.start != -1);
                if (authorityStart != -1 || ((Object)this.text.subSequence(this.start, length)).toString().startsWith("mailto")) {
                    this.checkAndStoreResult(this.start, length, bracketsDepth);
                }
            }
            return this.result;
        }

        private void rememberIsStart(int pos) {
            this.start = pos;
        }

        private void checkAndStoreResult(int start, int end, int bracketsDepth) {
            char lastChar = this.text.charAt(end - 1);
            if (lastChar == '.' || lastChar == ',' || lastChar == ':' || lastChar == ';') {
                lastChar = this.text.charAt(--end - 1);
            }
            if (bracketsDepth < 0 && lastChar == ')') {
                lastChar = this.text.charAt(--end - 1);
            }
            if (this.checkUrl(start, end)) {
                this.storeResult(start, end);
            }
        }

        private boolean checkUrl(int start, int end) {
            String hyperlink = ((Object)this.text.subSequence(start, end)).toString();
            try {
                URI uri = new URI(hyperlink);
                if (!uri.isAbsolute()) {
                    return false;
                }
                String scheme = uri.getScheme();
                if (uri.isOpaque() && !scheme.equals("mailto")) {
                    return false;
                }
                if (!(scheme.equals("http") || scheme.equals("https") || scheme.equals("mailto"))) {
                    return false;
                }
                uri.toURL();
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }

        private void storeResult(int start, int end) {
            assert (start != -1);
            if (this.result == null) {
                this.result = new int[]{start, end};
            } else {
                int[] newResult = new int[this.result.length + 2];
                System.arraycopy(this.result, 0, newResult, 0, this.result.length);
                newResult[this.result.length] = start;
                newResult[this.result.length + 1] = end;
                this.result = newResult;
            }
        }

        private static boolean isSupportedScheme(String scheme) {
            for (String suppScheme : SUPPORTED_SCHEMES) {
                if (!scheme.equals(suppScheme)) continue;
                return true;
            }
            return false;
        }

        private static State getInitialState(int c) {
            return SearchMachine.isInitChar(c) ? State.INIT : State.WAITING_FOR_INIT_CHAR;
        }

        private static boolean isInitChar(int c) {
            return c < 32 || URI_INIT_CHARS.indexOf(c) != -1 || c > 255 && Character.isSpaceChar(c);
        }

        private static boolean isUriEndChar(int c) {
            return c < 32 || c == 32 || c == 62 || c == 34 || c > 255 && Character.isSpaceChar(c);
        }

        private static boolean isSchemeChar(int c) {
            if (c >= 255) {
                return false;
            }
            return SearchMachine.isLetter(c) || SearchMachine.isDigit(c) || c == 43 || c == 45 || c == 46;
        }

        private static boolean isIpFutureAddrChar(int c) {
            return SearchMachine.isUnreserved(c) || SearchMachine.isSubDelim(c) || c == 58;
        }

        private static boolean isUserInfoChar(int c) {
            return SearchMachine.isUnreserved(c) || SearchMachine.isPctEncoded(c) || SearchMachine.isSubDelim(c) || c == 58;
        }

        private static boolean isRegnameChar(int c) {
            return SearchMachine.isUnreserved(c) || SearchMachine.isPctEncoded(c) || SearchMachine.isSubDelim(c);
        }

        private static boolean isPathSegmentChar(int c) {
            return SearchMachine.isUnreserved(c) || SearchMachine.isPctEncoded(c) || SearchMachine.isSubDelim(c) || c == 58 || c == 64;
        }

        private static boolean isQueryChar(int c) {
            return SearchMachine.isPathSegmentChar(c) || c == 47 || c == 63;
        }

        private static boolean isFragmentChar(int c) {
            return SearchMachine.isPathSegmentChar(c) || c == 47 || c == 63;
        }

        private static boolean isPctEncoded(int c) {
            return c == 37;
        }

        private static boolean isGenDelim(int c) {
            return GEN_DELIMS.indexOf(c) != -1;
        }

        private static boolean isSubDelim(int c) {
            return SUB_DELIMS.indexOf(c) != -1;
        }

        private static boolean isReserved(int c) {
            return RESERVED.indexOf(c) != -1;
        }

        private static boolean isUnreserved(int c) {
            return SearchMachine.isLetter(c) || SearchMachine.isDigit(c) || c == 45 || c == 46 || c == 95 || c == 126;
        }

        private static boolean isLetterOrDigit(int c) {
            return SearchMachine.isLetter(c) || SearchMachine.isDigit(c);
        }

        private static boolean isLetter(int c) {
            return (c |= 0x20) >= 97 && c <= 122;
        }

        private static boolean isHexDigit(int c) {
            if (SearchMachine.isDigit(c)) {
                return true;
            }
            return (c |= 0x20) >= 97 && c <= 102;
        }

        private static boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }

        private static boolean isSpaceOrPunct(int c) {
            return c == 13 || c == 10 || Character.isSpaceChar(c) || SearchMachine.isPunct(c);
        }

        private static boolean isPunct(int c) {
            return PUNCT_CHARS.indexOf(c) != -1;
        }

        static enum State {
            WAITING_FOR_INIT_CHAR,
            WAITING_FOR_URI_END_CHAR,
            INIT,
            SCHEME,
            HIER_START,
            HIER_SLASH,
            USERINFO_OR_HOST_START,
            USERINFO_OR_PORT_NUMBER,
            USERINFO,
            HOST_START,
            USERINFO_OR_IPV4_OR_REGNAME,
            USERINFO_OR_REGNAME,
            IP_LITERAL_START,
            IPV6,
            IPV6_DDOT,
            IPV6_QDOT_1,
            IPV6_QDOT_2,
            IP_FUTURE_START,
            IP_FUTURE_VER_NUM,
            IP_FUTURE_ADDR,
            IP_FUTURE_ADDR_START,
            IPV4_OR_REGNAME,
            PORT_NUMBER_OR_AUTHORITY_END,
            PORT_NUMBER,
            REGNAME,
            PATH,
            QUERY,
            FRAGMENT;

        }
    }

    private static class UrlAction {
        private UrlAction() {
        }

        void openUrlHyperlink(String hyperlinkText) {
            try {
                URL url = new URI(hyperlinkText).toURL();
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
            catch (Exception ex) {
                assert (false);
                BugtrackingManager.LOG.log(Level.WARNING, "Could not open URL: " + hyperlinkText);
            }
        }
    }
}

