/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.windows.WindowManager;

public class UIUtils {
    private static FocusListener scrollingFocusListener;

    public static void setWaitCursor(final boolean on) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
                mainWindow.getGlassPane().setCursor(Cursor.getPredefinedCursor(on ? 3 : 0));
                mainWindow.getGlassPane().setVisible(on);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public static void keepFocusedComponentVisible(JComponent component) {
        UIUtils.keepFocusedComponentVisible((Component)component, component);
    }

    public static void keepFocusedComponentVisible(Component component, JComponent container) {
        FocusListener listener = component instanceof JComponent ? UIUtils.getNotShowingFieldsFocusListener(container) : UIUtils.getScrollingFocusListener();
        UIUtils.keepFocusedComponentVisible(component, listener);
    }

    private static void keepFocusedComponentVisible(Component component, FocusListener l) {
        component.removeFocusListener(l);
        component.addFocusListener(l);
        if (component instanceof Container) {
            for (Component subComponent : ((Container)component).getComponents()) {
                UIUtils.keepFocusedComponentVisible(subComponent, l);
            }
        }
    }

    private static FocusListener getNotShowingFieldsFocusListener(JComponent container) {
        String key = "notShowingFieldFocusListener";
        Object l = container.getClientProperty(key);
        if (l == null) {
            l = new NotShowingFieldsFocusListener(container);
            container.putClientProperty(key, l);
        }
        return (FocusListener)l;
    }

    private static FocusListener getScrollingFocusListener() {
        if (scrollingFocusListener == null) {
            scrollingFocusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (!e.isTemporary()) {
                        Component comp = e.getComponent();
                        Container cont = comp.getParent();
                        if (cont instanceof JViewport) {
                            comp = cont;
                            cont = cont.getParent();
                        }
                        if (cont instanceof JComponent) {
                            ((JComponent)cont).scrollRectToVisible(comp.getBounds());
                        }
                    }
                }
            };
        }
        return scrollingFocusListener;
    }

    public static void keepComponentsWidthByVisibleArea(final JPanel panel, final SizeController sc) {
        panel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                final JViewport v = UIUtils.getViewport(panel);
                assert (v != null);
                if (v == null) {
                    return;
                }
                sc.setWidth(this.computeWidth(v));
                v.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        sc.setWidth(this.computeWidth(v));
                    }
                });
                v.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        sc.setWidth(this.computeWidth(v));
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }
                });
            }

            private int computeWidth(JViewport v) {
                Rectangle vr = v.getViewRect();
                return vr.width + vr.x;
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private static JViewport getViewport(Container c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JScrollPane) {
            return ((JScrollPane)c).getViewport();
        }
        return UIUtils.getViewport(c.getParent());
    }

    public static void fixFocusTraversalKeys(JComponent component) {
        Set<AWTKeyStroke> set = component.getFocusTraversalKeys(0);
        set = new HashSet<AWTKeyStroke>(set);
        set.add(AWTKeyStroke.getAWTKeyStroke(9, 640));
        component.setFocusTraversalKeys(0, set);
    }

    public static void issue163946Hack(final JScrollPane scrollPane) {
        MouseWheelListener listener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (scrollPane.getVerticalScrollBar().isShowing()) {
                    if (e.getSource() != scrollPane) {
                        e.setSource(scrollPane);
                        scrollPane.dispatchEvent(e);
                    }
                } else {
                    scrollPane.getParent().dispatchEvent(e);
                }
            }
        };
        scrollPane.addMouseWheelListener(listener);
        scrollPane.getViewport().getView().addMouseWheelListener(listener);
    }

    public static int getColumnWidthInPixels(int widthInLeters, JComponent comp) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < widthInLeters; ++i) {
            sb.append("w");
        }
        return UIUtils.getColumnWidthInPixels(sb.toString(), comp);
    }

    public static int getColumnWidthInPixels(String str, JComponent comp) {
        FontMetrics fm = comp.getFontMetrics(comp.getFont());
        return fm.stringWidth(str);
    }

    public static int getLongestWordWidth(String header, List<String> values, JComponent comp) {
        return UIUtils.getLongestWordWidth(header, values, comp, false);
    }

    public static int getLongestWordWidth(String header, List<String> values, JComponent comp, boolean regardIcon) {
        String[] valuesArray = values.toArray(new String[values.size()]);
        return UIUtils.getLongestWordWidth(header, valuesArray, comp, regardIcon);
    }

    public static int getLongestWordWidth(String header, String[] values, JComponent comp) {
        return UIUtils.getLongestWordWidth(header, values, comp, false);
    }

    public static int getLongestWordWidth(String header, String[] values, JComponent comp, boolean regardIcon) {
        int size = header.length();
        for (String s : values) {
            if (size >= s.length()) continue;
            size = s.length();
        }
        return UIUtils.getColumnWidthInPixels(size, comp) + (regardIcon ? 16 : 0);
    }

    private static class NotShowingFieldsFocusListener
    implements FocusListener {
        private final JComponent container;

        public NotShowingFieldsFocusListener(JComponent container) {
            this.container = container;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            Component cmp = e.getComponent();
            if (cmp instanceof JComponent) {
                Point p;
                Rectangle r;
                JViewport vp = UIUtils.getViewport(this.container);
                if (vp == null) {
                    return;
                }
                Rectangle vr = vp.getViewRect();
                if (vr.intersects(r = new Rectangle(p = SwingUtilities.convertPoint(cmp.getParent(), cmp.getLocation(), this.container), cmp.getSize()))) {
                    return;
                }
                this.container.scrollRectToVisible(r);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    public static interface SizeController {
        public void setWidth(int var1);
    }
}

