/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.openide.util.NbBundle;

public class RepositoryComboRenderer
extends DefaultListCellRenderer {
    private final String loadingReposText = NbBundle.getMessage(RepositoryComboSupport.class, (String)"RepositoryComboSupport.loadingRepositories");
    private final String noRepositories = NbBundle.getMessage(RepositoryComboSupport.class, (String)"RepositoryComboSupport.noRepositories");
    private final String selectRepoText = NbBundle.getMessage(RepositoryComboSupport.class, (String)"RepositoryComboSupport.selectRepository");

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text;
        Repository repo = null;
        if (value == null) {
            text = null;
        } else if (value instanceof Repository) {
            repo = (Repository)value;
            text = repo.getDisplayName();
        } else if (value instanceof RepositoryImpl) {
            assert (false) : "the value provided to the renderer should be a Repository";
            repo = ((RepositoryImpl)value).getRepository();
            text = repo.getDisplayName();
        } else if (value == "loading") {
            text = this.loadingReposText;
        } else if (value == "no repositories") {
            text = this.noRepositories;
        } else {
            assert (value == "select") : value;
            text = this.selectRepoText;
        }
        Component result = super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        if (result instanceof JLabel) {
            JLabel label = (JLabel)result;
            if (repo != null) {
                Image icon = repo.getIcon();
                if (icon instanceof Icon) {
                    label.setIcon((Icon)((Object)icon));
                } else {
                    label.setIcon(new ImageIcon(icon));
                }
            } else {
                Font font = label.getFont();
                label.setFont(new Font(font.getName(), font.getStyle() | 2, font.getSize()));
            }
        }
        return result;
    }
}

