/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.spi.RepositoryProvider;

public final class LogUtils {
    private static Logger METRICS_LOG = Logger.getLogger("org.netbeans.ui.metrics.bugtracking");
    public static final String USG_BUGTRACKING_AUTOMATIC_REFRESH = "USG_BUGTRACKING_AUTOMATIC_REFRESH";
    public static final String USG_BUGTRACKING_QUERY = "USG_BUGTRACKING_QUERY";
    private static final String USG_ISSUE_TRACKING = "USG_ISSUE_TRACKING";
    private static Set<String> loggedParams;

    public static void logQueryEvent(String connector, String name, int count, boolean isKenai, boolean isAutoRefresh) {
        name = LogUtils.obfuscateQueryName(name);
        LogUtils.logBugtrackingEvents(USG_BUGTRACKING_QUERY, new Object[]{connector, name, count, isKenai, isAutoRefresh});
    }

    public static void logAutoRefreshEvent(String connector, String queryName, boolean isKenai, boolean on) {
        queryName = LogUtils.obfuscateQueryName(queryName);
        LogUtils.logBugtrackingEvents(USG_BUGTRACKING_AUTOMATIC_REFRESH, new Object[]{connector, queryName, isKenai, on});
    }

    public static synchronized void logBugtrackingUsage(Repository repository, String operation) {
        if (repository == null) {
            return;
        }
        String btType = LogUtils.getBugtrackingType(APIAccessor.IMPL.getImpl(repository).getProvider());
        if (btType == null) {
            return;
        }
        if (KenaiUtil.isKenai(repository)) {
            KenaiUtil.logKenaiUsage(repository.getUrl(), "ISSUE_TRACKING", btType);
        }
        if (operation == null) {
            return;
        }
        String paramStr = LogUtils.getParamString(btType, operation);
        if (loggedParams == null || !loggedParams.contains(paramStr)) {
            LogRecord rec = new LogRecord(Level.INFO, USG_ISSUE_TRACKING);
            rec.setParameters(new Object[]{btType, operation});
            rec.setLoggerName(METRICS_LOG.getName());
            METRICS_LOG.log(rec);
            if (loggedParams == null) {
                loggedParams = new HashSet<String>();
            }
            loggedParams.add(paramStr);
        }
    }

    private static String getParamString(Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return "";
        }
        if (parameters.length == 1) {
            return parameters[0].toString();
        }
        StringBuilder buf = new StringBuilder();
        for (Object p : parameters) {
            buf.append(p.toString());
        }
        return buf.toString();
    }

    private static String getBugtrackingType(RepositoryProvider repository) {
        String clsName = repository.getClass().getName();
        if (clsName.contains(".bugzilla.")) {
            return "Bugzilla";
        }
        if (clsName.contains(".jira.")) {
            return "Jira";
        }
        if (clsName.contains(".ods.")) {
            return "ODS";
        }
        return null;
    }

    private static void logBugtrackingEvents(String key, Object[] parameters) {
        LogRecord rec = new LogRecord(Level.INFO, key);
        rec.setParameters(parameters);
        rec.setLoggerName(METRICS_LOG.getName());
        METRICS_LOG.log(rec);
    }

    private static String obfuscateQueryName(String name) {
        name = name == null ? "Find Issues" : LogUtils.getMD5(name);
        return name;
    }

    private static String getMD5(String name) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(name.getBytes());
        byte[] hash = digest.digest();
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i] & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret.append(hex);
        }
        return ret.toString();
    }
}

