/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingConfig;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.spi.RecentIssue;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.netbeans.modules.bugtracking.ui.issue.PatchContextChooser;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.ui.selectors.RepositorySelector;
import org.netbeans.modules.bugtracking.util.Scrambler;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class BugtrackingUtil {
    private static RequestProcessor parallelRP;
    private static Pattern netbeansUrlPattern;
    private static final String NB_BUGZILLA_PASSWORD = "nbbugzilla.password";
    private static final String NB_BUGZILLA_USERNAME = "nbbugzilla.username";

    public static boolean show(JPanel panel, String title, String okName) {
        JButton ok = new JButton(okName);
        ok.getAccessibleContext().setAccessibleDescription(ok.getText());
        JButton cancel = new JButton(NbBundle.getMessage(BugtrackingUtil.class, (String)"LBL_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(cancel.getText());
        DialogDescriptor dd = new DialogDescriptor((Object)panel, title, true, new Object[]{ok, cancel}, (Object)ok, 0, new HelpCtx(panel.getClass()), null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == ok;
    }

    public static Collection<IssueImpl> getOpenIssues() {
        Set tcs = TopComponent.getRegistry().getOpened();
        ArrayList<IssueImpl> issues = new ArrayList<IssueImpl>();
        for (TopComponent tc : tcs) {
            IssueImpl issue;
            if (!(tc instanceof IssueTopComponent) || (issue = ((IssueTopComponent)tc).getIssue()).isNew()) continue;
            issues.add(issue);
        }
        return issues;
    }

    public static boolean isOpened(IssueImpl issue) {
        IssueTopComponent tc = IssueTopComponent.find(issue, false);
        return tc != null ? tc.isOpened() : false;
    }

    public static boolean isShowing(IssueImpl issue) {
        IssueTopComponent tc = IssueTopComponent.find(issue, false);
        return tc != null ? tc.isShowing() : false;
    }

    public static boolean isOpened(QueryImpl query) {
        QueryTopComponent tc = QueryTopComponent.find(query);
        return tc != null ? tc.isOpened() : false;
    }

    public static boolean isShowing(QueryImpl query) {
        QueryTopComponent tc = QueryTopComponent.find(query);
        return tc != null ? tc.isShowing() : false;
    }

    public static Collection<IssueImpl> getByIdOrSummary(Collection<IssueImpl> issues, String criteria) {
        if (criteria == null) {
            return issues;
        }
        if ((criteria = criteria.trim()).equals("")) {
            return issues;
        }
        criteria = criteria.toLowerCase();
        ArrayList<IssueImpl> ret = new ArrayList<IssueImpl>();
        for (IssueImpl issue : issues) {
            String id;
            if (issue.isNew() || (id = issue.getID()) == null) continue;
            String summary = issue.getSummary();
            if (!id.toLowerCase().startsWith(criteria) && (summary == null || summary.toLowerCase().indexOf(criteria) <= -1)) continue;
            ret.add(issue);
        }
        return ret;
    }

    public static RepositoryImpl createRepository() {
        return BugtrackingUtil.createRepository(true);
    }

    public static RepositoryImpl createRepository(boolean selectNode) {
        RepositorySelector rs = new RepositorySelector();
        RepositoryImpl repo = rs.create(selectNode);
        return repo;
    }

    public static boolean editRepository(Repository repository, String errorMessage) {
        RepositorySelector rs = new RepositorySelector();
        return rs.edit(APIAccessor.IMPL.getImpl(repository), errorMessage);
    }

    public static boolean editRepository(Repository repository) {
        return BugtrackingUtil.editRepository(repository, null);
    }

    public static Collection<RepositoryImpl> getKnownRepositories(boolean pingOpenProjects) {
        return RepositoryRegistry.getInstance().getKnownRepositories(pingOpenProjects);
    }

    public static Collection<RepositoryImpl> getRepositories(String id) {
        return RepositoryRegistry.getInstance().getRepositories(id);
    }

    public static BugtrackingConnector[] getBugtrackingConnectors() {
        DelegatingConnector[] dcs = BugtrackingManager.getInstance().getConnectors();
        BugtrackingConnector[] cons = new BugtrackingConnector[dcs.length];
        for (int i = 0; i < cons.length; ++i) {
            cons[i] = dcs[i].getDelegate();
        }
        return cons;
    }

    public static String scramble(String str) {
        return Scrambler.getInstance().scramble(str);
    }

    public static String descramble(String str) {
        return Scrambler.getInstance().descramble(str);
    }

    public static String selectIssue(String message, Repository repository, JPanel caller, HelpCtx helpCtx) {
        QuickSearchComboBar bar = new QuickSearchComboBar(caller);
        bar.setRepository(repository);
        bar.setAlignmentX(0.0f);
        bar.setMaximumSize(new Dimension(Short.MAX_VALUE, bar.getPreferredSize().height));
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 3);
        panel.setLayout(layout);
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)message);
        panel.add(label);
        label.setLabelFor(bar.getIssueComponent());
        LayoutStyle layoutStyle = LayoutStyle.getInstance();
        int gap = layoutStyle.getPreferredGap(label, bar, LayoutStyle.ComponentPlacement.RELATED, 5, panel);
        panel.add(Box.createVerticalStrut(gap));
        panel.add(bar);
        panel.add(Box.createVerticalStrut(gap));
        ResourceBundle bundle = NbBundle.getBundle(BugtrackingUtil.class);
        JLabel hintLabel = new JLabel(bundle.getString("MSG_SelectIssueHint"));
        hintLabel.setEnabled(false);
        panel.add(hintLabel);
        panel.add(Box.createVerticalStrut(80));
        panel.setBorder(BorderFactory.createEmptyBorder(layoutStyle.getContainerGap(panel, 1, null), layoutStyle.getContainerGap(panel, 7, null), 0, layoutStyle.getContainerGap(panel, 3, null)));
        panel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_IssueSelector"));
        Issue issue = null;
        JButton ok = new JButton(bundle.getString("LBL_Select"));
        ok.getAccessibleContext().setAccessibleDescription(ok.getText());
        JButton cancel = new JButton(bundle.getString("LBL_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(cancel.getText());
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, bundle.getString("LBL_Issues"), true, 2, (Object)ok, null);
        descriptor.setOptions(new Object[]{ok, cancel});
        descriptor.setHelpCtx(helpCtx);
        DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
        if (descriptor.getValue() == ok) {
            issue = bar.getIssue();
        }
        return issue != null ? issue.getID() : null;
    }

    public static File selectPatchContext() {
        PatchContextChooser chooser = new PatchContextChooser();
        ResourceBundle bundle = NbBundle.getBundle(BugtrackingUtil.class);
        JButton ok = new JButton(bundle.getString("LBL_Apply"));
        JButton cancel = new JButton(bundle.getString("LBL_Cancel"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)chooser, bundle.getString("LBL_ApplyPatch"), true, 2, (Object)ok, null);
        descriptor.setOptions(new Object[]{ok, cancel});
        descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.bugtracking.patchContextChooser"));
        File context = null;
        DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
        if (descriptor.getValue() == ok) {
            context = chooser.getSelectedFile();
        }
        return context;
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                BugtrackingUtil.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static boolean isNbRepository(String url) {
        boolean ret = netbeansUrlPattern.matcher(url).matches();
        if (ret) {
            return true;
        }
        String nbUrl = System.getProperty("netbeans.bugzilla.url");
        if (nbUrl == null || nbUrl.equals("")) {
            return false;
        }
        return url.startsWith(nbUrl);
    }

    public static void savePassword(String password, String prefix, String user, String url) throws MissingResourceException {
        BugtrackingUtil.savePassword(password.toCharArray(), prefix, user, url);
    }

    public static void savePassword(char[] password, String prefix, String user, String url) throws MissingResourceException {
        if (password != null && password.length != 0) {
            Keyring.save((String)BugtrackingUtil.getPasswordKey(prefix, user, url), (char[])password, (String)NbBundle.getMessage(BugtrackingUtil.class, (String)"password_keyring_description", (Object)url));
        } else {
            Keyring.delete((String)BugtrackingUtil.getPasswordKey(prefix, user, url));
        }
    }

    public static char[] readPassword(String scrambledPassword, String keyPrefix, String user, String url) {
        if (scrambledPassword != null && !scrambledPassword.equals("")) {
            return BugtrackingUtil.descramble(scrambledPassword).toCharArray();
        }
        char[] password = Keyring.read((String)BugtrackingUtil.getPasswordKey(keyPrefix, user, url));
        return password != null ? password : new char[]{};
    }

    public static RequestProcessor getParallelRP() {
        if (parallelRP == null) {
            parallelRP = new RequestProcessor("Bugtracking parallel tasks", 5, true);
        }
        return parallelRP;
    }

    private static String getPasswordKey(String prefix, String user, String url) {
        return (prefix != null ? prefix + "-" : "") + user + "@" + url;
    }

    public static boolean isJiraInstalled() {
        DelegatingConnector[] connectors;
        for (DelegatingConnector c : connectors = BugtrackingManager.getInstance().getConnectors()) {
            if (!c.getDelegate().getClass().getName().startsWith("org.netbeans.modules.jira")) continue;
            return true;
        }
        return false;
    }

    public static void openQuery(QueryImpl query, RepositoryImpl repository, boolean suggestedSelectionOnly) {
        QueryAction.openQuery(query, repository, suggestedSelectionOnly);
    }

    public static void openIssue(File file, String issueId) {
        IssueAction.openIssue(file, issueId);
    }

    public static Map<String, List<RecentIssue>> getAllRecentIssues() {
        return BugtrackingManager.getInstance().getAllRecentIssues();
    }

    public static Collection<IssueImpl> getRecentIssues(RepositoryImpl repo) {
        return BugtrackingManager.getInstance().getRecentIssues(repo);
    }

    public static String getPasswordLog(char[] psswd) {
        if (psswd == null) {
            return "";
        }
        if ("true".equals(System.getProperty("org.netbeans.modules.bugtracking.logPasswords", "false"))) {
            return new String(psswd);
        }
        return "******";
    }

    public static String getNBUsername() {
        String user = BugtrackingConfig.getInstance().getPreferences().get(NB_BUGZILLA_USERNAME, "");
        if ("".equals(user)) {
            user = RepositoryRegistry.getBugzillaNBUsername();
        }
        return user.equals("") ? null : user;
    }

    public static char[] getNBPassword() {
        return Keyring.read((String)NB_BUGZILLA_PASSWORD);
    }

    public static void saveNBUsername(String username) {
        if (username == null) {
            return;
        }
        BugtrackingConfig.getInstance().getPreferences().put(NB_BUGZILLA_USERNAME, username);
    }

    public static void saveNBPassword(char[] password) {
        if (password == null) {
            Keyring.delete((String)NB_BUGZILLA_PASSWORD);
        } else {
            Keyring.save((String)NB_BUGZILLA_PASSWORD, (char[])password, (String)NbBundle.getMessage(BugtrackingUtil.class, (String)"NBRepositorySupport.password_keyring_description"));
        }
    }

    public static File getFile(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        Lookup nodeLookup = nodes[0].getLookup();
        Project project = (Project)nodeLookup.lookup(Project.class);
        if (project != null) {
            return BugtrackingUtil.getFile(project);
        }
        DataObject dataObj = (DataObject)nodeLookup.lookup(DataObject.class);
        if (dataObj != null) {
            return BugtrackingUtil.getFile(dataObj);
        }
        return null;
    }

    private static File getFile(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        return FileUtil.toFile((FileObject)fileObject);
    }

    private static File getFile(DataObject dataObj) {
        FileObject fileObj = dataObj.getPrimaryFile();
        if (fileObj == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObj);
        if (project != null) {
            return BugtrackingUtil.getFile(project);
        }
        return FileUtil.toFile((FileObject)fileObj);
    }

    static {
        netbeansUrlPattern = Pattern.compile("(https|http)://(([a-z]|\\d)+\\.)*([a-z]|\\d)*netbeans([a-z]|\\d)*(([a-z]|\\d)*\\.)+org(.*)");
    }
}

