/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.api.diff.PatchUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.util.AttachmentPanel;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.Bundle;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.UIUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AttachmentsPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(220, 220, 220);
    private static final Logger LOG = Logger.getLogger(AttachmentsPanel.class.getName());
    private boolean hadNoAttachments = true;
    private List<AttachmentPanel> newAttachments;
    private JLabel noneLabel;
    private LinkButton createNewButton;
    private LinkButton attachLogFileButton;
    private JLabel dummyCreateLabel = new JLabel();
    private JLabel dummyAttachLabel = new JLabel();
    private Method maxMethod;
    private JComponent parentPanel;
    private PropertyChangeListener deletedListener;

    public AttachmentsPanel(JComponent parentPanel) {
        this.parentPanel = parentPanel;
        this.setBackground(UIManager.getColor("TextArea.background"));
        ResourceBundle bundle = NbBundle.getBundle(AttachmentsPanel.class);
        this.noneLabel = new JLabel(bundle.getString("AttachmentsPanel.noneLabel.text"));
        this.createNewButton = new LinkButton(new CreateNewAction());
        this.createNewButton.getAccessibleContext().setAccessibleDescription(bundle.getString("AttachmentPanels.createNewButton.AccessibleContext.accessibleDescription"));
        try {
            this.maxMethod = GroupLayout.Group.class.getDeclaredMethod("calculateMaximumSize", Integer.TYPE);
            this.maxMethod.setAccessible(true);
        }
        catch (NoSuchMethodException nsmex) {
            LOG.log(Level.INFO, nsmex.getMessage(), nsmex);
        }
    }

    public void setAttachments(List<? extends Attachment> attachments) {
        GroupLayout.ParallelGroup pg;
        GroupLayout.SequentialGroup sg;
        this.hadNoAttachments = attachments.isEmpty();
        this.newAttachments = new LinkedList<AttachmentPanel>();
        this.removeAll();
        GroupLayout layout = new GroupLayout(this);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        ResourceBundle bundle = NbBundle.getBundle(AttachmentsPanel.class);
        GroupLayout.SequentialGroup newVerticalGroup = layout.createSequentialGroup();
        boolean noAttachments = this.hadNoAttachments;
        if (this.attachLogFileButton != null) {
            sg = layout.createSequentialGroup();
            sg.addComponent(this.noneLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(noAttachments ? this.createNewButton : this.dummyCreateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(noAttachments ? this.attachLogFileButton : this.dummyAttachLabel);
            horizontalGroup.addGroup(sg);
        } else {
            horizontalGroup.addGroup(layout.createSequentialGroup().addComponent(this.noneLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(noAttachments ? this.createNewButton : this.dummyCreateLabel));
        }
        if (this.attachLogFileButton != null) {
            pg = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            pg.addComponent(this.noneLabel).addComponent(noAttachments ? this.createNewButton : this.dummyCreateLabel).addComponent(noAttachments ? this.attachLogFileButton : this.dummyAttachLabel);
            verticalGroup.addGroup(pg);
        } else {
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noneLabel).addComponent(noAttachments ? this.createNewButton : this.dummyCreateLabel));
        }
        this.dummyCreateLabel.setVisible(false);
        this.dummyAttachLabel.setVisible(false);
        this.noneLabel.setVisible(noAttachments);
        this.updateButtonText(noAttachments);
        if (noAttachments) {
            verticalGroup.addGroup(newVerticalGroup);
        } else {
            ArrayList<JPanel> panels = new ArrayList<JPanel>();
            JLabel descriptionLabel = new JLabel(bundle.getString("AttachmentsPanel.table.description"));
            JLabel filenameLabel = new JLabel(bundle.getString("AttachmentsPanel.table.filename"));
            JLabel dateLabel = new JLabel(bundle.getString("AttachmentsPanel.table.date"));
            JLabel authorLabel = new JLabel(bundle.getString("AttachmentsPanel.table.author"));
            this.makeBold(descriptionLabel);
            this.makeBold(filenameLabel);
            this.makeBold(dateLabel);
            this.makeBold(authorLabel);
            GroupLayout.ParallelGroup descriptionGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup filenameGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup dateGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup authorGroup = layout.createParallelGroup();
            int descriptionWidth = Math.max(descriptionLabel.getPreferredSize().width, 150);
            descriptionGroup.addComponent(descriptionLabel, descriptionWidth, descriptionWidth, descriptionWidth);
            filenameGroup.addComponent(filenameLabel);
            dateGroup.addComponent(dateLabel);
            authorGroup.addComponent(authorLabel);
            JPanel panel = this.createHighlightPanel();
            panels.add(panel);
            horizontalGroup.addGroup(layout.createSequentialGroup().addGroup(descriptionGroup).addPreferredGap(descriptionLabel, filenameLabel, LayoutStyle.ComponentPlacement.UNRELATED).addGroup(filenameGroup).addPreferredGap(filenameLabel, dateLabel, LayoutStyle.ComponentPlacement.UNRELATED).addGroup(dateGroup).addPreferredGap(dateLabel, authorLabel, LayoutStyle.ComponentPlacement.UNRELATED).addGroup(authorGroup));
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(panel, 0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(descriptionLabel).addComponent(filenameLabel).addComponent(dateLabel).addComponent(authorLabel)));
            for (Attachment attachment : attachments) {
                boolean isPatch = attachment.isPatch();
                String description = attachment.getDesc();
                String filename = attachment.getFilename();
                Date date = attachment.getDate();
                String author = attachment.getAuthor();
                String authorName = attachment.getAuthorName();
                authorName = authorName != null && authorName.trim().length() > 0 ? authorName : author;
                descriptionLabel = new JLabel(description);
                LinkButton filenameButton = new LinkButton();
                LinkButton patchButton = null;
                JLabel lBrace = null;
                JLabel rBrace = null;
                GroupLayout.SequentialGroup hPatchGroup = null;
                if (isPatch) {
                    patchButton = new LinkButton();
                    lBrace = new JLabel("(");
                    rBrace = new JLabel(")");
                    hPatchGroup = layout.createSequentialGroup().addComponent(filenameButton).addPreferredGap(filenameButton, lBrace, LayoutStyle.ComponentPlacement.RELATED).addComponent(lBrace).addComponent(patchButton).addComponent(rBrace);
                }
                JPopupMenu menu = this.menuFor(attachment, patchButton);
                filenameButton.setAction(attachment.getOpenAction());
                filenameButton.setText(filename);
                filenameButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentPanels.filenameButton.AccessibleContext.accessibleDescription"));
                dateLabel = new JLabel(date != null ? DateFormat.getDateInstance().format(date) : "");
                JComponent authorComponent = author.indexOf("@") > -1 ? new LinkButton.MailtoButton(authorName, NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentPanel.authorButton.AccessibleContext.accessibleDescription"), author) : new JLabel(authorName);
                descriptionLabel.setComponentPopupMenu(menu);
                filenameButton.setComponentPopupMenu(menu);
                dateLabel.setComponentPopupMenu(menu);
                authorComponent.setComponentPopupMenu(menu);
                descriptionGroup.addComponent(descriptionLabel, 0, -1, -2);
                if (isPatch) {
                    lBrace.setComponentPopupMenu(menu);
                    patchButton.setComponentPopupMenu(menu);
                    rBrace.setComponentPopupMenu(menu);
                    filenameGroup.addGroup(hPatchGroup);
                } else {
                    filenameGroup.addComponent(filenameButton);
                }
                dateGroup.addComponent(dateLabel);
                authorGroup.addComponent(authorComponent);
                panel = this.createHighlightPanel();
                panel.addMouseListener(new MouseAdapter(){});
                panel.setComponentPopupMenu(menu);
                panels.add(panel);
                GroupLayout.ParallelGroup pGroup = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
                pGroup.addComponent(descriptionLabel);
                pGroup.addComponent(filenameButton);
                if (isPatch) {
                    pGroup.addComponent(lBrace);
                    pGroup.addComponent(patchButton);
                    pGroup.addComponent(rBrace);
                }
                pGroup.addComponent(dateLabel);
                pGroup.addComponent(authorComponent);
                verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(panel, 0, 0, Short.MAX_VALUE).addGroup(pGroup));
            }
            verticalGroup.addGroup(newVerticalGroup);
            int groupWidth = 0;
            if (this.maxMethod != null) {
                try {
                    groupWidth = (Integer)this.maxMethod.invoke((Object)horizontalGroup, 0);
                }
                catch (Exception exception) {
                    LOG.log(Level.INFO, exception.getMessage(), exception);
                }
            }
            for (JPanel p : panels) {
                horizontalGroup.addComponent(p, 0, 0, groupWidth);
            }
        }
        if (this.attachLogFileButton != null) {
            sg = layout.createSequentialGroup();
            sg.addComponent(noAttachments ? this.dummyCreateLabel : this.createNewButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(noAttachments ? this.dummyAttachLabel : this.attachLogFileButton).addGap(0, 0, Short.MAX_VALUE);
            horizontalGroup.addGroup(sg);
        } else {
            horizontalGroup.addGroup(layout.createSequentialGroup().addComponent(noAttachments ? this.dummyCreateLabel : this.createNewButton).addGap(0, 0, Short.MAX_VALUE));
        }
        if (this.attachLogFileButton != null) {
            pg = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            pg.addComponent(noAttachments ? this.dummyCreateLabel : this.createNewButton).addComponent(noAttachments ? this.dummyAttachLabel : this.attachLogFileButton);
            verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            verticalGroup.addGroup(pg);
        } else {
            verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            verticalGroup.addComponent(noAttachments ? this.dummyCreateLabel : this.createNewButton);
        }
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        ((CreateNewAction)this.createNewButton.getAction()).setLayoutGroups(horizontalGroup, newVerticalGroup);
        if (this.attachLogFileButton != null) {
            ((CreateNewAction)this.attachLogFileButton.getAction()).setLayoutGroups(horizontalGroup, newVerticalGroup);
        }
        this.setLayout(layout);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, super.getMinimumSize().height);
    }

    private JPopupMenu menuFor(Attachment attachment, LinkButton patchButton) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(attachment.getOpenAction());
        menu.add(attachment.getSaveAction());
        if (attachment.isPatch()) {
            Action action = attachment.getApplyPatchAction();
            menu.add(action);
            patchButton.setAction(action);
            String label = patchButton.getText();
            patchButton.setText(label.substring(0, 1).toLowerCase() + label.substring(1));
            patchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentPanels.patchButton.AccessibleContext.accessibleDescription"));
        }
        return menu;
    }

    private void updateButtonText(boolean noAttachments) {
        String txt = NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentsPanel.createNewButton.text");
        this.createNewButton.setText(noAttachments ? '(' + txt + ')' : txt);
        if (this.attachLogFileButton != null) {
            txt = NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentsPanel.attachLogFileButton.text");
            this.attachLogFileButton.setText(noAttachments ? '(' + txt + ')' : txt);
        }
    }

    private void makeBold(JLabel label) {
        Font font = label.getFont().deriveFont(1);
        label.setFont(font);
    }

    private JPanel createHighlightPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(BG_COLOR);
        this.add(panel);
        return panel;
    }

    PropertyChangeListener getDeletedListener() {
        if (this.deletedListener == null) {
            this.deletedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("attachmentDeleted".equals(evt.getPropertyName())) {
                        for (AttachmentPanel panel : AttachmentsPanel.this.newAttachments) {
                            if (panel.isDeleted()) continue;
                            return;
                        }
                        AttachmentsPanel.this.noneLabel.setVisible(true);
                        AttachmentsPanel.this.switchHelper();
                        AttachmentsPanel.this.updateButtonText(true);
                    }
                }
            };
        }
        return this.deletedListener;
    }

    private void switchHelper() {
        JLabel temp = new JLabel();
        GroupLayout layout = (GroupLayout)this.getLayout();
        layout.replace(this.dummyCreateLabel, temp);
        layout.replace(this.createNewButton, this.dummyCreateLabel);
        layout.replace(temp, this.createNewButton);
        if (this.attachLogFileButton != null) {
            layout.replace(this.dummyAttachLabel, temp);
            layout.replace(this.attachLogFileButton, this.dummyAttachLabel);
            layout.replace(temp, this.attachLogFileButton);
        }
    }

    public List<AttachmentInfo> getNewAttachments() {
        ArrayList<AttachmentInfo> infos = new ArrayList<AttachmentInfo>(this.newAttachments.size());
        for (AttachmentPanel attachment : this.newAttachments) {
            if (attachment.isDeleted()) continue;
            AttachmentInfo info = new AttachmentInfo();
            info.file = attachment.getFile();
            info.description = attachment.getDescription();
            info.contentType = attachment.getContentType();
            info.isPatch = attachment.isPatch();
            if (info.description.trim().isEmpty()) {
                info.description = Bundle.IssuePanel_attachment_noDescription();
            }
            infos.add(info);
        }
        return infos;
    }

    public static abstract class AbstractAttachment
    implements Attachment {
        @Override
        public Action getOpenAction() {
            return new DefaultAttachmentAction();
        }

        @Override
        public Action getApplyPatchAction() {
            return new ApplyPatchAction();
        }

        @Override
        public Action getSaveAction() {
            return new SaveAttachmentAction();
        }

        protected abstract void getAttachementData(OutputStream var1);

        protected abstract String getContentType();

        private void open() {
            String progressFormat = NbBundle.getMessage(DefaultAttachmentAction.class, (String)"Attachment.open.progress");
            String progressMessage = MessageFormat.format(progressFormat, this.getFilename());
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)progressMessage);
            handle.start();
            handle.switchToIndeterminate();
            BugtrackingUtil.getParallelRP().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        File file = AbstractAttachment.this.saveToTempFile();
                        String contentType = AbstractAttachment.this.getContentType();
                        if ("image/png".equals(contentType) || "image/gif".equals(contentType) || "image/jpeg".equals(contentType)) {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(Utilities.toURI((File)file).toURL());
                        } else {
                            FileObject fob = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
                            DataObject dob = DataObject.find((FileObject)fob);
                            OpenCookie open = (OpenCookie)dob.getCookie(OpenCookie.class);
                            if (open != null) {
                                open.open();
                            }
                        }
                    }
                    catch (DataObjectNotFoundException dnfex) {
                        LOG.log(Level.INFO, dnfex.getMessage(), dnfex);
                    }
                    catch (IOException ioex) {
                        LOG.log(Level.INFO, ioex.getMessage(), ioex);
                    }
                    finally {
                        handle.finish();
                    }
                }
            });
        }

        private void saveToFile() {
            final File file = new FileChooserBuilder(AttachmentsPanel.class).setFilesOnly(true).showSaveDialog();
            if (file != null) {
                String progressFormat = NbBundle.getMessage(SaveAttachmentAction.class, (String)"Attachment.saveToFile.progress");
                String progressMessage = MessageFormat.format(progressFormat, this.getFilename());
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)progressMessage);
                handle.start();
                handle.switchToIndeterminate();
                BugtrackingUtil.getParallelRP().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractAttachment.this.getAttachmentData(file);
                        }
                        catch (IOException ioex) {
                            LOG.log(Level.INFO, ioex.getMessage(), ioex);
                        }
                    }
                });
            }
        }

        private void applyPatch() {
            final File context = BugtrackingUtil.selectPatchContext();
            if (context != null) {
                String progressFormat = NbBundle.getMessage(ApplyPatchAction.class, (String)"Attachment.applyPatch.progress");
                String progressMessage = MessageFormat.format(progressFormat, this.getFilename());
                final ProgressHandle handle = ProgressHandleFactory.createHandle((String)progressMessage);
                handle.start();
                handle.switchToIndeterminate();
                BugtrackingUtil.getParallelRP().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            File file = AbstractAttachment.this.saveToTempFile();
                            PatchUtils.applyPatch((File)file, (File)context);
                        }
                        catch (IOException ioex) {
                            LOG.log(Level.INFO, ioex.getMessage(), ioex);
                        }
                        finally {
                            handle.finish();
                        }
                    }
                });
            }
        }

        private File saveToTempFile() throws IOException {
            String suffix;
            String filename = this.getFilename();
            int index = filename.lastIndexOf(46);
            String prefix = index == -1 ? filename : filename.substring(0, index);
            String string = suffix = index == -1 ? null : filename.substring(index);
            if (prefix.length() < 3) {
                prefix = prefix + "tmp";
            }
            File file = File.createTempFile(prefix, suffix);
            this.getAttachmentData(file);
            return file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getAttachmentData(File file) throws IOException {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                this.getAttachementData(fos);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private class ApplyPatchAction
        extends AbstractAction {
            public ApplyPatchAction() {
                this.putValue("Name", NbBundle.getMessage(ApplyPatchAction.class, (String)"Attachment.ApplyPatchAction.name"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAttachment.this.applyPatch();
            }
        }

        private class SaveAttachmentAction
        extends AbstractAction {
            public SaveAttachmentAction() {
                this.putValue("Name", NbBundle.getMessage(SaveAttachmentAction.class, (String)"Attachment.SaveAction.name"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAttachment.this.saveToFile();
            }
        }

        private class DefaultAttachmentAction
        extends AbstractAction {
            public DefaultAttachmentAction() {
                this.putValue("Name", NbBundle.getMessage(DefaultAttachmentAction.class, (String)"Attachment.DefaultAction.name"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAttachment.this.open();
            }
        }
    }

    public static interface Attachment {
        public boolean isPatch();

        public Action getOpenAction();

        public Action getApplyPatchAction();

        public Action getSaveAction();

        public String getDesc();

        public String getFilename();

        public Date getDate();

        public String getAuthor();

        public String getAuthorName();
    }

    class CreateNewAction
    extends AbstractAction {
        private GroupLayout.ParallelGroup horizontalGroup;
        private GroupLayout.SequentialGroup verticalGroup;

        void setLayoutGroups(GroupLayout.ParallelGroup horizontalGroup, GroupLayout.SequentialGroup verticalGroup) {
            this.horizontalGroup = horizontalGroup;
            this.verticalGroup = verticalGroup;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttachmentPanel attachment = new AttachmentPanel();
            attachment.setBackground(BG_COLOR);
            this.horizontalGroup.addComponent(attachment, -2, -1, -2);
            this.verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            this.verticalGroup.addComponent(attachment, -2, -1, -2);
            if (AttachmentsPanel.this.noneLabel.isVisible()) {
                AttachmentsPanel.this.noneLabel.setVisible(false);
                AttachmentsPanel.this.switchHelper();
                AttachmentsPanel.this.updateButtonText(false);
            }
            if (AttachmentsPanel.this.hadNoAttachments) {
                attachment.addPropertyChangeListener(AttachmentsPanel.this.getDeletedListener());
            }
            AttachmentsPanel.this.newAttachments.add(attachment);
            UIUtils.keepFocusedComponentVisible((Component)attachment, AttachmentsPanel.this.parentPanel);
            AttachmentsPanel.this.revalidate();
        }
    }

    public final class AttachmentInfo {
        private File file;
        private String description;
        private String contentType;
        private boolean isPatch;

        public String getContentType() {
            return this.contentType;
        }

        public String getDescription() {
            return this.description;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isPatch() {
            return this.isPatch;
        }
    }
}

