/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.ui.query.QueriesPanel;
import org.netbeans.modules.bugtracking.ui.query.RepoSelectorPanel;
import org.netbeans.modules.bugtracking.ui.query.ViewportWidthAwarePanel;

class RepoPanel
extends ViewportWidthAwarePanel {
    private static final int MIN_SPACE = 24;
    private final RepoSelectorPanel repoSelectorPanel;
    private final QueriesPanel queriesPanel;

    RepoPanel(JComponent repoSelector, JComponent newRepoButton) {
        super(null);
        this.repoSelectorPanel = new RepoSelectorPanel(repoSelector, newRepoButton);
        this.queriesPanel = new QueriesPanel();
        this.queriesPanel.setVisible(false);
        this.queriesPanel.setBackground(new Color(224, 224, 224));
        LayoutStyle layoutStyle = LayoutStyle.getInstance();
        this.setBorder(BorderFactory.createEmptyBorder(0, layoutStyle.getContainerGap(this, 7, this.getParent()), 0, layoutStyle.getContainerGap(this, 3, this.getParent())));
        this.add(this.repoSelectorPanel);
        this.add(this.queriesPanel);
    }

    @Override
    public Dimension getPreferredSize() {
        int height;
        Dimension repoSelectorPrefSize = this.repoSelectorPanel.getPreferredSize();
        int width = repoSelectorPrefSize.width;
        Insets insets = this.getInsets();
        if (!this.queriesPanel.isVisible()) {
            height = repoSelectorPrefSize.height + insets.top + insets.bottom;
        } else {
            Dimension queriesPanelPrefSize = this.queriesPanel.getPreferredSize();
            int aboveBaseline = this.getBaseline();
            int belowBaseline1 = repoSelectorPrefSize.height - this.repoSelectorPanel.getBaseline();
            int belowBaseline2 = queriesPanelPrefSize.height - this.queriesPanel.getBaseline();
            int belowBaseline = Math.max(belowBaseline1, belowBaseline2);
            width += 24 + queriesPanelPrefSize.width;
            height = aboveBaseline + belowBaseline + insets.bottom;
        }
        return new Dimension(width += insets.left + insets.right, height);
    }

    @Override
    public void doLayout() {
        int baseline = this.getBaseline();
        Insets insets = this.getInsets();
        int availableWidth = this.getAvailableWidth() - insets.left - insets.right;
        int x = insets.left;
        Dimension tmpPrefSize = this.repoSelectorPanel.getPreferredSize();
        this.repoSelectorPanel.setBounds(x, baseline - this.repoSelectorPanel.getBaseline(), tmpPrefSize.width, tmpPrefSize.height);
        if (this.queriesPanel.isVisible()) {
            x += tmpPrefSize.width;
            tmpPrefSize = this.queriesPanel.getPreferredSize();
            int space = !this.queriesPanel.isWrapped() ? Math.max(24, (availableWidth -= tmpPrefSize.width) - tmpPrefSize.width) : 24;
            this.queriesPanel.setBounds(x += space, baseline - this.queriesPanel.getBaseline(), tmpPrefSize.width, tmpPrefSize.height);
        }
    }

    public int getBaseline() {
        int baseline = this.queriesPanel.isVisible() ? Math.max(this.repoSelectorPanel.getBaseline(), this.queriesPanel.getBaseline()) : this.repoSelectorPanel.getBaseline();
        return baseline += this.getInsets().top;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, this.getPreferredSize().height);
    }

    void setQueries(QueryImpl[] queries) {
        boolean hadQueries;
        boolean queriesChanged;
        assert (EventQueue.isDispatchThread());
        if (queries != null && queries.length == 0) {
            queries = null;
        }
        boolean bl = queriesChanged = (hadQueries = this.queriesPanel.hasQueries()) || queries != null;
        if (queriesChanged) {
            if (queries == null) {
                this.queriesPanel.setVisible(false);
            }
            this.queriesPanel.setQueries(queries);
            if (!hadQueries && queries != null) {
                this.notifyChildrenOfVisibleWidth();
                this.queriesPanel.setVisible(true);
            }
        }
    }

    @Override
    protected void notifyChildrenOfVisibleWidth() {
        if (this.queriesPanel.hasQueries()) {
            int availableWidth = this.getAvailableWidth();
            int usedWidth = this.getInsets().left + this.repoSelectorPanel.getPreferredSize().width;
            this.queriesPanel.setAvailableWidth(availableWidth - usedWidth - 24);
        }
    }
}

